package org.apache.xml.serialize;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;

final class SecuritySupport
{
  private static final SecuritySupport securitySupport = new SecuritySupport();

  static SecuritySupport getInstance()
  {
    return securitySupport;
  }

  ClassLoader getContextClassLoader()
  {
    return (ClassLoader)AccessController.doPrivileged(new PrivilegedAction()
    {
      public Object run()
      {
        ClassLoader localClassLoader = null;
        try
        {
          localClassLoader = Thread.currentThread().getContextClassLoader();
        }
        catch (SecurityException localSecurityException)
        {
        }
        return localClassLoader;
      }
    });
  }

  ClassLoader getSystemClassLoader()
  {
    return (ClassLoader)AccessController.doPrivileged(new PrivilegedAction()
    {
      public Object run()
      {
        ClassLoader localClassLoader = null;
        try
        {
          localClassLoader = ClassLoader.getSystemClassLoader();
        }
        catch (SecurityException localSecurityException)
        {
        }
        return localClassLoader;
      }
    });
  }

  ClassLoader getParentClassLoader(ClassLoader paramClassLoader)
  {
    return (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(paramClassLoader)
    {
      private final ClassLoader val$cl;

      public Object run()
      {
        ClassLoader localClassLoader = null;
        try
        {
          localClassLoader = this.val$cl.getParent();
        }
        catch (SecurityException localSecurityException)
        {
        }
        return localClassLoader == this.val$cl ? null : localClassLoader;
      }
    });
  }

  String getSystemProperty(String paramString)
  {
    return (String)AccessController.doPrivileged(new PrivilegedAction(paramString)
    {
      private final String val$propName;

      public Object run()
      {
        return System.getProperty(this.val$propName);
      }
    });
  }

  FileInputStream getFileInputStream(File paramFile)
    throws FileNotFoundException
  {
    try
    {
      return (FileInputStream)AccessController.doPrivileged(new PrivilegedExceptionAction(paramFile)
      {
        private final File val$file;

        public Object run()
          throws FileNotFoundException
        {
          return new FileInputStream(this.val$file);
        }
      });
    }
    catch (PrivilegedActionException localPrivilegedActionException)
    {
    }
    throw ((FileNotFoundException)localPrivilegedActionException.getException());
  }

  InputStream getResourceAsStream(ClassLoader paramClassLoader, String paramString)
  {
    return (InputStream)AccessController.doPrivileged(new PrivilegedAction(paramClassLoader, paramString)
    {
      private final ClassLoader val$cl;
      private final String val$name;

      public Object run()
      {
        InputStream localInputStream;
        if (this.val$cl == null)
          localInputStream = ClassLoader.getSystemResourceAsStream(this.val$name);
        else
          localInputStream = this.val$cl.getResourceAsStream(this.val$name);
        return localInputStream;
      }
    });
  }

  boolean getFileExists(File paramFile)
  {
    return ((Boolean)AccessController.doPrivileged(new PrivilegedAction(paramFile)
    {
      private final File val$f;

      public Object run()
      {
        return this.val$f.exists() ? Boolean.TRUE : Boolean.FALSE;
      }
    })).booleanValue();
  }

  long getLastModified(File paramFile)
  {
    return ((Long)AccessController.doPrivileged(new PrivilegedAction(paramFile)
    {
      private final File val$f;

      public Object run()
      {
        return new Long(this.val$f.lastModified());
      }
    })).longValue();
  }
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.apache.xml.serialize.SecuritySupport
 * JD-Core Version:    0.6.0
 */