/*     */ package org.apache.xml.resolver.tools;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.InputStream;
/*     */ import java.net.MalformedURLException;
/*     */ import java.net.URL;
/*     */ import javax.xml.parsers.ParserConfigurationException;
/*     */ import javax.xml.parsers.SAXParser;
/*     */ import javax.xml.parsers.SAXParserFactory;
/*     */ import javax.xml.transform.Source;
/*     */ import javax.xml.transform.TransformerException;
/*     */ import javax.xml.transform.URIResolver;
/*     */ import javax.xml.transform.sax.SAXSource;
/*     */ import org.apache.xml.resolver.Catalog;
/*     */ import org.apache.xml.resolver.CatalogManager;
/*     */ import org.apache.xml.resolver.helpers.Debug;
/*     */ import org.apache.xml.resolver.helpers.FileURL;
/*     */ import org.xml.sax.EntityResolver;
/*     */ import org.xml.sax.InputSource;
/*     */ import org.xml.sax.SAXException;
/*     */ import org.xml.sax.XMLReader;
/*     */ 
/*     */ public class CatalogResolver
/*     */   implements EntityResolver, URIResolver
/*     */ {
/*  64 */   public boolean namespaceAware = true;
/*     */ 
/*  67 */   public boolean validating = false;
/*     */ 
/*  70 */   private Catalog catalog = null;
/*     */ 
/*  73 */   private CatalogManager catalogManager = CatalogManager.getStaticManager();
/*     */ 
/*     */   public CatalogResolver()
/*     */   {
/*  77 */     initializeCatalogs(false);
/*     */   }
/*     */ 
/*     */   public CatalogResolver(boolean privateCatalog)
/*     */   {
/*  82 */     initializeCatalogs(privateCatalog);
/*     */   }
/*     */ 
/*     */   public CatalogResolver(CatalogManager manager)
/*     */   {
/*  87 */     this.catalogManager = manager;
/*  88 */     initializeCatalogs(!this.catalogManager.getUseStaticCatalog());
/*     */   }
/*     */ 
/*     */   private void initializeCatalogs(boolean privateCatalog)
/*     */   {
/*  93 */     this.catalog = this.catalogManager.getCatalog();
/*     */   }
/*     */ 
/*     */   public Catalog getCatalog()
/*     */   {
/*  98 */     return this.catalog;
/*     */   }
/*     */ 
/*     */   public String getResolvedEntity(String publicId, String systemId)
/*     */   {
/* 122 */     String resolved = null;
/*     */ 
/* 124 */     if (this.catalog == null) {
/* 125 */       this.catalogManager.debug.message(1, "Catalog resolution attempted with null catalog; ignored");
/* 126 */       return null;
/*     */     }
/*     */ 
/* 129 */     if (systemId != null) {
/*     */       try {
/* 131 */         resolved = this.catalog.resolveSystem(systemId);
/*     */       } catch (MalformedURLException me) {
/* 133 */         this.catalogManager.debug.message(1, "Malformed URL exception trying to resolve", publicId);
/*     */ 
/* 135 */         resolved = null;
/*     */       } catch (IOException ie) {
/* 137 */         this.catalogManager.debug.message(1, "I/O exception trying to resolve", publicId);
/* 138 */         resolved = null;
/*     */       }
/*     */     }
/*     */ 
/* 142 */     if (resolved == null) {
/* 143 */       if (publicId != null) {
/*     */         try {
/* 145 */           resolved = this.catalog.resolvePublic(publicId, systemId);
/*     */         } catch (MalformedURLException me) {
/* 147 */           this.catalogManager.debug.message(1, "Malformed URL exception trying to resolve", publicId);
/*     */         }
/*     */         catch (IOException ie) {
/* 150 */           this.catalogManager.debug.message(1, "I/O exception trying to resolve", publicId);
/*     */         }
/*     */       }
/*     */ 
/* 154 */       if (resolved != null)
/* 155 */         this.catalogManager.debug.message(2, "Resolved public", publicId, resolved);
/*     */     }
/*     */     else {
/* 158 */       this.catalogManager.debug.message(2, "Resolved system", systemId, resolved);
/*     */     }
/*     */ 
/* 161 */     return resolved;
/*     */   }
/*     */ 
/*     */   public InputSource resolveEntity(String publicId, String systemId)
/*     */   {
/* 192 */     String resolved = getResolvedEntity(publicId, systemId);
/*     */ 
/* 194 */     if (resolved != null) {
/*     */       try {
/* 196 */         InputSource iSource = new InputSource(resolved);
/* 197 */         iSource.setPublicId(publicId);
/*     */ 
/* 210 */         URL url = new URL(resolved);
/* 211 */         InputStream iStream = url.openStream();
/* 212 */         iSource.setByteStream(iStream);
/*     */ 
/* 214 */         return iSource;
/*     */       } catch (Exception e) {
/* 216 */         this.catalogManager.debug.message(1, "Failed to create InputSource (" + e.toString() + ")", resolved);
/*     */ 
/* 220 */         return null;
/*     */       }
/*     */     }
/*     */ 
/* 224 */     return null;
/*     */   }
/*     */ 
/*     */   public Source resolve(String href, String base)
/*     */     throws TransformerException
/*     */   {
/* 231 */     String uri = href;
/* 232 */     String fragment = null;
/* 233 */     int hashPos = href.indexOf("#");
/* 234 */     if (hashPos >= 0) {
/* 235 */       uri = href.substring(0, hashPos);
/* 236 */       fragment = href.substring(hashPos + 1);
/*     */     }
/*     */ 
/* 239 */     String result = null;
/*     */     try
/*     */     {
/* 242 */       result = this.catalog.resolveURI(href);
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/*     */     }
/* 247 */     if (result == null) {
/*     */       try {
/* 249 */         URL url = null;
/*     */ 
/* 251 */         if (base == null) {
/* 252 */           url = new URL(uri);
/* 253 */           result = url.toString();
/*     */         } else {
/* 255 */           URL baseURL = new URL(base);
/* 256 */           url = href.length() == 0 ? baseURL : new URL(baseURL, uri);
/* 257 */           result = url.toString();
/*     */         }
/*     */       }
/*     */       catch (MalformedURLException mue) {
/* 261 */         String absBase = makeAbsolute(base);
/* 262 */         if (!absBase.equals(base))
/*     */         {
/* 264 */           return resolve(href, absBase);
/*     */         }
/* 266 */         throw new TransformerException("Malformed URL " + href + "(base " + base + ")", mue);
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 273 */     this.catalogManager.debug.message(2, "Resolved URI", href, result);
/*     */ 
/* 275 */     SAXSource source = new SAXSource();
/* 276 */     source.setInputSource(new InputSource(result));
/* 277 */     setEntityResolver(source);
/* 278 */     return source;
/*     */   }
/*     */ 
/*     */   private void setEntityResolver(SAXSource source)
/*     */     throws TransformerException
/*     */   {
/* 303 */     XMLReader reader = source.getXMLReader();
/* 304 */     if (reader == null) {
/* 305 */       SAXParserFactory spFactory = SAXParserFactory.newInstance();
/* 306 */       spFactory.setNamespaceAware(true);
/*     */       try {
/* 308 */         reader = spFactory.newSAXParser().getXMLReader();
/*     */       }
/*     */       catch (ParserConfigurationException ex) {
/* 311 */         throw new TransformerException(ex);
/*     */       }
/*     */       catch (SAXException ex) {
/* 314 */         throw new TransformerException(ex);
/*     */       }
/*     */     }
/* 317 */     reader.setEntityResolver(this);
/* 318 */     source.setXMLReader(reader);
/*     */   }
/*     */ 
/*     */   private String makeAbsolute(String uri)
/*     */   {
/* 323 */     if (uri == null) {
/* 324 */       uri = "";
/*     */     }
/*     */     try
/*     */     {
/* 328 */       URL url = new URL(uri);
/* 329 */       return url.toString();
/*     */     } catch (MalformedURLException mue) {
/*     */       try {
/* 332 */         URL fileURL = FileURL.makeURL(uri);
/* 333 */         return fileURL.toString(); } catch (MalformedURLException mue2) {
/*     */       }
/*     */     }
/* 336 */     return uri;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.apache.xml.resolver.tools.CatalogResolver
 * JD-Core Version:    0.6.0
 */