/*     */ package org.apache.xml.resolver.readers;
/*     */ 
/*     */ import java.util.Vector;
/*     */ import javax.xml.parsers.SAXParserFactory;
/*     */ import org.apache.xml.resolver.Catalog;
/*     */ import org.apache.xml.resolver.CatalogEntry;
/*     */ import org.apache.xml.resolver.CatalogException;
/*     */ import org.apache.xml.resolver.CatalogManager;
/*     */ import org.apache.xml.resolver.helpers.Debug;
/*     */ import org.apache.xml.resolver.helpers.PublicId;
/*     */ import org.xml.sax.Attributes;
/*     */ import org.xml.sax.Locator;
/*     */ import org.xml.sax.SAXException;
/*     */ 
/*     */ public class XCatalogReader extends SAXCatalogReader
/*     */   implements SAXCatalogParser
/*     */ {
/*  47 */   protected Catalog catalog = null;
/*     */ 
/*     */   public void setCatalog(Catalog catalog)
/*     */   {
/*  51 */     this.catalog = catalog;
/*  52 */     this.debug = catalog.getCatalogManager().debug;
/*     */   }
/*     */ 
/*     */   public Catalog getCatalog()
/*     */   {
/*  57 */     return this.catalog;
/*     */   }
/*     */ 
/*     */   public XCatalogReader()
/*     */   {
/*     */   }
/*     */ 
/*     */   public XCatalogReader(SAXParserFactory parserFactory, Catalog catalog)
/*     */   {
/*  67 */     super(parserFactory);
/*  68 */     setCatalog(catalog);
/*     */   }
/*     */ 
/*     */   public void setDocumentLocator(Locator locator)
/*     */   {
/*     */   }
/*     */ 
/*     */   public void startDocument()
/*     */     throws SAXException
/*     */   {
/*     */   }
/*     */ 
/*     */   public void endDocument()
/*     */     throws SAXException
/*     */   {
/*     */   }
/*     */ 
/*     */   public void startElement(String namespaceURI, String localName, String qName, Attributes atts)
/*     */     throws SAXException
/*     */   {
/* 109 */     int entryType = -1;
/* 110 */     Vector entryArgs = new Vector();
/*     */ 
/* 112 */     if (localName.equals("Base")) {
/* 113 */       entryType = Catalog.BASE;
/* 114 */       entryArgs.add(atts.getValue("HRef"));
/*     */ 
/* 116 */       this.debug.message(4, "Base", atts.getValue("HRef"));
/* 117 */     } else if (localName.equals("Delegate")) {
/* 118 */       entryType = Catalog.DELEGATE_PUBLIC;
/* 119 */       entryArgs.add(atts.getValue("PublicID"));
/* 120 */       entryArgs.add(atts.getValue("HRef"));
/*     */ 
/* 122 */       this.debug.message(4, "Delegate", PublicId.normalize(atts.getValue("PublicID")), atts.getValue("HRef"));
/*     */     }
/* 125 */     else if (localName.equals("Extend")) {
/* 126 */       entryType = Catalog.CATALOG;
/* 127 */       entryArgs.add(atts.getValue("HRef"));
/*     */ 
/* 129 */       this.debug.message(4, "Extend", atts.getValue("HRef"));
/* 130 */     } else if (localName.equals("Map")) {
/* 131 */       entryType = Catalog.PUBLIC;
/* 132 */       entryArgs.add(atts.getValue("PublicID"));
/* 133 */       entryArgs.add(atts.getValue("HRef"));
/*     */ 
/* 135 */       this.debug.message(4, "Map", PublicId.normalize(atts.getValue("PublicID")), atts.getValue("HRef"));
/*     */     }
/* 138 */     else if (localName.equals("Remap")) {
/* 139 */       entryType = Catalog.SYSTEM;
/* 140 */       entryArgs.add(atts.getValue("SystemID"));
/* 141 */       entryArgs.add(atts.getValue("HRef"));
/*     */ 
/* 143 */       this.debug.message(4, "Remap", atts.getValue("SystemID"), atts.getValue("HRef"));
/*     */     }
/* 146 */     else if (!localName.equals("XCatalog"))
/*     */     {
/* 150 */       this.debug.message(1, "Invalid catalog entry type", localName);
/*     */     }
/*     */ 
/* 153 */     if (entryType >= 0)
/*     */       try {
/* 155 */         CatalogEntry ce = new CatalogEntry(entryType, entryArgs);
/* 156 */         this.catalog.addEntry(ce);
/*     */       } catch (CatalogException cex) {
/* 158 */         if (cex.getExceptionType() == 3)
/* 159 */           this.debug.message(1, "Invalid catalog entry type", localName);
/* 160 */         else if (cex.getExceptionType() == 2)
/* 161 */           this.debug.message(1, "Invalid catalog entry", localName);
/*     */       }
/*     */   }
/*     */ 
/*     */   public void endElement(String namespaceURI, String localName, String qName)
/*     */     throws SAXException
/*     */   {
/*     */   }
/*     */ 
/*     */   public void characters(char[] ch, int start, int length)
/*     */     throws SAXException
/*     */   {
/*     */   }
/*     */ 
/*     */   public void ignorableWhitespace(char[] ch, int start, int length)
/*     */     throws SAXException
/*     */   {
/*     */   }
/*     */ 
/*     */   public void processingInstruction(String target, String data)
/*     */     throws SAXException
/*     */   {
/*     */   }
/*     */ 
/*     */   public void skippedEntity(String name)
/*     */     throws SAXException
/*     */   {
/*     */   }
/*     */ 
/*     */   public void startPrefixMapping(String prefix, String uri)
/*     */     throws SAXException
/*     */   {
/*     */   }
/*     */ 
/*     */   public void endPrefixMapping(String prefix)
/*     */     throws SAXException
/*     */   {
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.apache.xml.resolver.readers.XCatalogReader
 * JD-Core Version:    0.6.0
 */