/*     */ package org.apache.xml.resolver.readers;
/*     */ 
/*     */ import java.util.Enumeration;
/*     */ import java.util.Stack;
/*     */ import java.util.Vector;
/*     */ import javax.xml.parsers.SAXParserFactory;
/*     */ import org.apache.xml.resolver.Catalog;
/*     */ import org.apache.xml.resolver.CatalogEntry;
/*     */ import org.apache.xml.resolver.CatalogException;
/*     */ import org.apache.xml.resolver.CatalogManager;
/*     */ import org.apache.xml.resolver.helpers.Debug;
/*     */ import org.apache.xml.resolver.helpers.PublicId;
/*     */ import org.xml.sax.Attributes;
/*     */ import org.xml.sax.Locator;
/*     */ import org.xml.sax.SAXException;
/*     */ 
/*     */ public class OASISXMLCatalogReader extends SAXCatalogReader
/*     */   implements SAXCatalogParser
/*     */ {
/*  49 */   protected Catalog catalog = null;
/*     */   public static final String namespaceName = "urn:oasis:names:tc:entity:xmlns:xml:catalog";
/*     */   public static final String tr9401NamespaceName = "urn:oasis:names:tc:entity:xmlns:tr9401:catalog";
/*  57 */   protected Stack baseURIStack = new Stack();
/*  58 */   protected Stack overrideStack = new Stack();
/*  59 */   protected Stack namespaceStack = new Stack();
/*     */ 
/*     */   public void setCatalog(Catalog catalog)
/*     */   {
/*  63 */     this.catalog = catalog;
/*  64 */     this.debug = catalog.getCatalogManager().debug;
/*     */   }
/*     */ 
/*     */   public Catalog getCatalog()
/*     */   {
/*  69 */     return this.catalog;
/*     */   }
/*     */ 
/*     */   public OASISXMLCatalogReader()
/*     */   {
/*     */   }
/*     */ 
/*     */   public OASISXMLCatalogReader(SAXParserFactory parserFactory, Catalog catalog)
/*     */   {
/*  79 */     super(parserFactory);
/*  80 */     setCatalog(catalog);
/*     */   }
/*     */ 
/*     */   protected boolean inExtensionNamespace()
/*     */   {
/*  90 */     boolean inExtension = false;
/*     */ 
/*  92 */     Enumeration elements = this.namespaceStack.elements();
/*  93 */     while ((!inExtension) && (elements.hasMoreElements())) {
/*  94 */       String ns = (String)elements.nextElement();
/*  95 */       if (ns == null)
/*  96 */         inExtension = true;
/*     */       else {
/*  98 */         inExtension = (!ns.equals("urn:oasis:names:tc:entity:xmlns:tr9401:catalog")) && (!ns.equals("urn:oasis:names:tc:entity:xmlns:xml:catalog"));
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 103 */     return inExtension;
/*     */   }
/*     */ 
/*     */   public void setDocumentLocator(Locator locator)
/*     */   {
/*     */   }
/*     */ 
/*     */   public void startDocument()
/*     */     throws SAXException
/*     */   {
/* 117 */     this.baseURIStack.push(this.catalog.getCurrentBase());
/* 118 */     this.overrideStack.push(this.catalog.getDefaultOverride());
/*     */   }
/*     */ 
/*     */   public void endDocument()
/*     */     throws SAXException
/*     */   {
/*     */   }
/*     */ 
/*     */   public void startElement(String namespaceURI, String localName, String qName, Attributes atts)
/*     */     throws SAXException
/*     */   {
/* 146 */     int entryType = -1;
/* 147 */     Vector entryArgs = new Vector();
/*     */ 
/* 149 */     this.namespaceStack.push(namespaceURI);
/*     */ 
/* 151 */     boolean inExtension = inExtensionNamespace();
/*     */ 
/* 153 */     if ((namespaceURI != null) && ("urn:oasis:names:tc:entity:xmlns:xml:catalog".equals(namespaceURI)) && (!inExtension))
/*     */     {
/* 157 */       if (atts.getValue("xml:base") != null) {
/* 158 */         String baseURI = atts.getValue("xml:base");
/* 159 */         entryType = Catalog.BASE;
/* 160 */         entryArgs.add(baseURI);
/* 161 */         this.baseURIStack.push(baseURI);
/*     */ 
/* 163 */         this.debug.message(4, "xml:base", baseURI);
/*     */         try
/*     */         {
/* 166 */           CatalogEntry ce = new CatalogEntry(entryType, entryArgs);
/* 167 */           this.catalog.addEntry(ce);
/*     */         } catch (CatalogException cex) {
/* 169 */           if (cex.getExceptionType() == 3)
/* 170 */             this.debug.message(1, "Invalid catalog entry type", localName);
/* 171 */           else if (cex.getExceptionType() == 2) {
/* 172 */             this.debug.message(1, "Invalid catalog entry (base)", localName);
/*     */           }
/*     */         }
/*     */ 
/* 176 */         entryType = -1;
/* 177 */         entryArgs = new Vector();
/*     */       }
/*     */       else {
/* 180 */         this.baseURIStack.push(this.baseURIStack.peek());
/*     */       }
/*     */ 
/* 183 */       if (((localName.equals("catalog")) || (localName.equals("group"))) && (atts.getValue("prefer") != null))
/*     */       {
/* 185 */         String override = atts.getValue("prefer");
/*     */ 
/* 187 */         if (override.equals("public")) {
/* 188 */           override = "yes";
/* 189 */         } else if (override.equals("system")) {
/* 190 */           override = "no";
/*     */         } else {
/* 192 */           this.debug.message(1, "Invalid prefer: must be 'system' or 'public'", localName);
/*     */ 
/* 195 */           override = this.catalog.getDefaultOverride();
/*     */         }
/*     */ 
/* 198 */         entryType = Catalog.OVERRIDE;
/* 199 */         entryArgs.add(override);
/* 200 */         this.overrideStack.push(override);
/*     */ 
/* 202 */         this.debug.message(4, "override", override);
/*     */         try
/*     */         {
/* 205 */           CatalogEntry ce = new CatalogEntry(entryType, entryArgs);
/* 206 */           this.catalog.addEntry(ce);
/*     */         } catch (CatalogException cex) {
/* 208 */           if (cex.getExceptionType() == 3)
/* 209 */             this.debug.message(1, "Invalid catalog entry type", localName);
/* 210 */           else if (cex.getExceptionType() == 2) {
/* 211 */             this.debug.message(1, "Invalid catalog entry (override)", localName);
/*     */           }
/*     */         }
/*     */ 
/* 215 */         entryType = -1;
/* 216 */         entryArgs = new Vector();
/*     */       }
/*     */       else {
/* 219 */         this.overrideStack.push(this.overrideStack.peek());
/*     */       }
/*     */ 
/* 222 */       if (localName.equals("delegatePublic")) {
/* 223 */         if (checkAttributes(atts, "publicIdStartString", "catalog")) {
/* 224 */           entryType = Catalog.DELEGATE_PUBLIC;
/* 225 */           entryArgs.add(atts.getValue("publicIdStartString"));
/* 226 */           entryArgs.add(atts.getValue("catalog"));
/*     */ 
/* 228 */           this.debug.message(4, "delegatePublic", PublicId.normalize(atts.getValue("publicIdStartString")), atts.getValue("catalog"));
/*     */         }
/*     */ 
/*     */       }
/* 232 */       else if (localName.equals("delegateSystem")) {
/* 233 */         if (checkAttributes(atts, "systemIdStartString", "catalog")) {
/* 234 */           entryType = Catalog.DELEGATE_SYSTEM;
/* 235 */           entryArgs.add(atts.getValue("systemIdStartString"));
/* 236 */           entryArgs.add(atts.getValue("catalog"));
/*     */ 
/* 238 */           this.debug.message(4, "delegateSystem", atts.getValue("systemIdStartString"), atts.getValue("catalog"));
/*     */         }
/*     */ 
/*     */       }
/* 242 */       else if (localName.equals("delegateURI")) {
/* 243 */         if (checkAttributes(atts, "uriStartString", "catalog")) {
/* 244 */           entryType = Catalog.DELEGATE_URI;
/* 245 */           entryArgs.add(atts.getValue("uriStartString"));
/* 246 */           entryArgs.add(atts.getValue("catalog"));
/*     */ 
/* 248 */           this.debug.message(4, "delegateURI", atts.getValue("uriStartString"), atts.getValue("catalog"));
/*     */         }
/*     */ 
/*     */       }
/* 252 */       else if (localName.equals("rewriteSystem")) {
/* 253 */         if (checkAttributes(atts, "systemIdStartString", "rewritePrefix")) {
/* 254 */           entryType = Catalog.REWRITE_SYSTEM;
/* 255 */           entryArgs.add(atts.getValue("systemIdStartString"));
/* 256 */           entryArgs.add(atts.getValue("rewritePrefix"));
/*     */ 
/* 258 */           this.debug.message(4, "rewriteSystem", atts.getValue("systemIdStartString"), atts.getValue("rewritePrefix"));
/*     */         }
/*     */ 
/*     */       }
/* 262 */       else if (localName.equals("systemSuffix")) {
/* 263 */         if (checkAttributes(atts, "systemIdSuffix", "uri")) {
/* 264 */           entryType = Catalog.SYSTEM_SUFFIX;
/* 265 */           entryArgs.add(atts.getValue("systemIdSuffix"));
/* 266 */           entryArgs.add(atts.getValue("uri"));
/*     */ 
/* 268 */           this.debug.message(4, "systemSuffix", atts.getValue("systemIdSuffix"), atts.getValue("uri"));
/*     */         }
/*     */ 
/*     */       }
/* 272 */       else if (localName.equals("rewriteURI")) {
/* 273 */         if (checkAttributes(atts, "uriStartString", "rewritePrefix")) {
/* 274 */           entryType = Catalog.REWRITE_URI;
/* 275 */           entryArgs.add(atts.getValue("uriStartString"));
/* 276 */           entryArgs.add(atts.getValue("rewritePrefix"));
/*     */ 
/* 278 */           this.debug.message(4, "rewriteURI", atts.getValue("uriStartString"), atts.getValue("rewritePrefix"));
/*     */         }
/*     */ 
/*     */       }
/* 282 */       else if (localName.equals("uriSuffix")) {
/* 283 */         if (checkAttributes(atts, "uriSuffix", "uri")) {
/* 284 */           entryType = Catalog.URI_SUFFIX;
/* 285 */           entryArgs.add(atts.getValue("uriSuffix"));
/* 286 */           entryArgs.add(atts.getValue("uri"));
/*     */ 
/* 288 */           this.debug.message(4, "uriSuffix", atts.getValue("uriSuffix"), atts.getValue("uri"));
/*     */         }
/*     */ 
/*     */       }
/* 292 */       else if (localName.equals("nextCatalog")) {
/* 293 */         if (checkAttributes(atts, "catalog")) {
/* 294 */           entryType = Catalog.CATALOG;
/* 295 */           entryArgs.add(atts.getValue("catalog"));
/*     */ 
/* 297 */           this.debug.message(4, "nextCatalog", atts.getValue("catalog"));
/*     */         }
/* 299 */       } else if (localName.equals("public")) {
/* 300 */         if (checkAttributes(atts, "publicId", "uri")) {
/* 301 */           entryType = Catalog.PUBLIC;
/* 302 */           entryArgs.add(atts.getValue("publicId"));
/* 303 */           entryArgs.add(atts.getValue("uri"));
/*     */ 
/* 305 */           this.debug.message(4, "public", PublicId.normalize(atts.getValue("publicId")), atts.getValue("uri"));
/*     */         }
/*     */ 
/*     */       }
/* 309 */       else if (localName.equals("system")) {
/* 310 */         if (checkAttributes(atts, "systemId", "uri")) {
/* 311 */           entryType = Catalog.SYSTEM;
/* 312 */           entryArgs.add(atts.getValue("systemId"));
/* 313 */           entryArgs.add(atts.getValue("uri"));
/*     */ 
/* 315 */           this.debug.message(4, "system", atts.getValue("systemId"), atts.getValue("uri"));
/*     */         }
/*     */ 
/*     */       }
/* 319 */       else if (localName.equals("uri")) {
/* 320 */         if (checkAttributes(atts, "name", "uri")) {
/* 321 */           entryType = Catalog.URI;
/* 322 */           entryArgs.add(atts.getValue("name"));
/* 323 */           entryArgs.add(atts.getValue("uri"));
/*     */ 
/* 325 */           this.debug.message(4, "uri", atts.getValue("name"), atts.getValue("uri"));
/*     */         }
/*     */ 
/*     */       }
/* 329 */       else if (!localName.equals("catalog"))
/*     */       {
/* 331 */         if (!localName.equals("group"))
/*     */         {
/* 335 */           this.debug.message(1, "Invalid catalog entry type", localName);
/*     */         }
/*     */       }
/* 338 */       if (entryType >= 0) {
/*     */         try {
/* 340 */           CatalogEntry ce = new CatalogEntry(entryType, entryArgs);
/* 341 */           this.catalog.addEntry(ce);
/*     */         } catch (CatalogException cex) {
/* 343 */           if (cex.getExceptionType() == 3)
/* 344 */             this.debug.message(1, "Invalid catalog entry type", localName);
/* 345 */           else if (cex.getExceptionType() == 2) {
/* 346 */             this.debug.message(1, "Invalid catalog entry", localName);
/*     */           }
/*     */         }
/*     */       }
/*     */     }
/*     */ 
/* 352 */     if ((namespaceURI != null) && ("urn:oasis:names:tc:entity:xmlns:tr9401:catalog".equals(namespaceURI)) && (!inExtension))
/*     */     {
/* 356 */       if (atts.getValue("xml:base") != null) {
/* 357 */         String baseURI = atts.getValue("xml:base");
/* 358 */         entryType = Catalog.BASE;
/* 359 */         entryArgs.add(baseURI);
/* 360 */         this.baseURIStack.push(baseURI);
/*     */ 
/* 362 */         this.debug.message(4, "xml:base", baseURI);
/*     */         try
/*     */         {
/* 365 */           CatalogEntry ce = new CatalogEntry(entryType, entryArgs);
/* 366 */           this.catalog.addEntry(ce);
/*     */         } catch (CatalogException cex) {
/* 368 */           if (cex.getExceptionType() == 3)
/* 369 */             this.debug.message(1, "Invalid catalog entry type", localName);
/* 370 */           else if (cex.getExceptionType() == 2) {
/* 371 */             this.debug.message(1, "Invalid catalog entry (base)", localName);
/*     */           }
/*     */         }
/*     */ 
/* 375 */         entryType = -1;
/* 376 */         entryArgs = new Vector();
/*     */       }
/*     */       else {
/* 379 */         this.baseURIStack.push(this.baseURIStack.peek());
/*     */       }
/*     */ 
/* 382 */       if (localName.equals("doctype")) {
/* 383 */         entryType = Catalog.DOCTYPE;
/* 384 */         entryArgs.add(atts.getValue("name"));
/* 385 */         entryArgs.add(atts.getValue("uri"));
/* 386 */       } else if (localName.equals("document")) {
/* 387 */         entryType = Catalog.DOCUMENT;
/* 388 */         entryArgs.add(atts.getValue("uri"));
/* 389 */       } else if (localName.equals("dtddecl")) {
/* 390 */         entryType = Catalog.DTDDECL;
/* 391 */         entryArgs.add(atts.getValue("publicId"));
/* 392 */         entryArgs.add(atts.getValue("uri"));
/* 393 */       } else if (localName.equals("entity")) {
/* 394 */         entryType = Catalog.ENTITY;
/* 395 */         entryArgs.add(atts.getValue("name"));
/* 396 */         entryArgs.add(atts.getValue("uri"));
/* 397 */       } else if (localName.equals("linktype")) {
/* 398 */         entryType = Catalog.LINKTYPE;
/* 399 */         entryArgs.add(atts.getValue("name"));
/* 400 */         entryArgs.add(atts.getValue("uri"));
/* 401 */       } else if (localName.equals("notation")) {
/* 402 */         entryType = Catalog.NOTATION;
/* 403 */         entryArgs.add(atts.getValue("name"));
/* 404 */         entryArgs.add(atts.getValue("uri"));
/* 405 */       } else if (localName.equals("sgmldecl")) {
/* 406 */         entryType = Catalog.SGMLDECL;
/* 407 */         entryArgs.add(atts.getValue("uri"));
/*     */       }
/*     */       else {
/* 410 */         this.debug.message(1, "Invalid catalog entry type", localName);
/*     */       }
/*     */ 
/* 413 */       if (entryType >= 0)
/*     */         try {
/* 415 */           CatalogEntry ce = new CatalogEntry(entryType, entryArgs);
/* 416 */           this.catalog.addEntry(ce);
/*     */         } catch (CatalogException cex) {
/* 418 */           if (cex.getExceptionType() == 3)
/* 419 */             this.debug.message(1, "Invalid catalog entry type", localName);
/* 420 */           else if (cex.getExceptionType() == 2)
/* 421 */             this.debug.message(1, "Invalid catalog entry", localName);
/*     */         }
/*     */     }
/*     */   }
/*     */ 
/*     */   public boolean checkAttributes(Attributes atts, String attName)
/*     */   {
/* 429 */     if (atts.getValue(attName) == null) {
/* 430 */       this.debug.message(1, "Error: required attribute " + attName + " missing.");
/* 431 */       return false;
/*     */     }
/* 433 */     return true;
/*     */   }
/*     */ 
/*     */   public boolean checkAttributes(Attributes atts, String attName1, String attName2)
/*     */   {
/* 440 */     return (checkAttributes(atts, attName1)) && (checkAttributes(atts, attName2));
/*     */   }
/*     */ 
/*     */   public void endElement(String namespaceURI, String localName, String qName)
/*     */     throws SAXException
/*     */   {
/* 450 */     int entryType = -1;
/* 451 */     Vector entryArgs = new Vector();
/*     */ 
/* 453 */     boolean inExtension = inExtensionNamespace();
/*     */ 
/* 455 */     if ((namespaceURI != null) && (!inExtension) && (("urn:oasis:names:tc:entity:xmlns:xml:catalog".equals(namespaceURI)) || ("urn:oasis:names:tc:entity:xmlns:tr9401:catalog".equals(namespaceURI))))
/*     */     {
/* 460 */       String popURI = (String)this.baseURIStack.pop();
/* 461 */       String baseURI = (String)this.baseURIStack.peek();
/*     */ 
/* 463 */       if (!baseURI.equals(popURI)) {
/* 464 */         entryType = Catalog.BASE;
/* 465 */         entryArgs.add(baseURI);
/*     */ 
/* 467 */         this.debug.message(4, "(reset) xml:base", baseURI);
/*     */         try
/*     */         {
/* 470 */           CatalogEntry ce = new CatalogEntry(entryType, entryArgs);
/* 471 */           this.catalog.addEntry(ce);
/*     */         } catch (CatalogException cex) {
/* 473 */           if (cex.getExceptionType() == 3)
/* 474 */             this.debug.message(1, "Invalid catalog entry type", localName);
/* 475 */           else if (cex.getExceptionType() == 2) {
/* 476 */             this.debug.message(1, "Invalid catalog entry (rbase)", localName);
/*     */           }
/*     */         }
/*     */       }
/*     */     }
/*     */ 
/* 482 */     if ((namespaceURI != null) && ("urn:oasis:names:tc:entity:xmlns:xml:catalog".equals(namespaceURI)) && (!inExtension))
/*     */     {
/* 484 */       if ((localName.equals("catalog")) || (localName.equals("group"))) {
/* 485 */         String popOverride = (String)this.overrideStack.pop();
/* 486 */         String override = (String)this.overrideStack.peek();
/*     */ 
/* 488 */         if (!override.equals(popOverride)) {
/* 489 */           entryType = Catalog.OVERRIDE;
/* 490 */           entryArgs.add(override);
/* 491 */           this.overrideStack.push(override);
/*     */ 
/* 493 */           this.debug.message(4, "(reset) override", override);
/*     */           try
/*     */           {
/* 496 */             CatalogEntry ce = new CatalogEntry(entryType, entryArgs);
/* 497 */             this.catalog.addEntry(ce);
/*     */           } catch (CatalogException cex) {
/* 499 */             if (cex.getExceptionType() == 3)
/* 500 */               this.debug.message(1, "Invalid catalog entry type", localName);
/* 501 */             else if (cex.getExceptionType() == 2) {
/* 502 */               this.debug.message(1, "Invalid catalog entry (roverride)", localName);
/*     */             }
/*     */           }
/*     */         }
/*     */       }
/*     */     }
/*     */ 
/* 509 */     this.namespaceStack.pop();
/*     */   }
/*     */ 
/*     */   public void characters(char[] ch, int start, int length)
/*     */     throws SAXException
/*     */   {
/*     */   }
/*     */ 
/*     */   public void ignorableWhitespace(char[] ch, int start, int length)
/*     */     throws SAXException
/*     */   {
/*     */   }
/*     */ 
/*     */   public void processingInstruction(String target, String data)
/*     */     throws SAXException
/*     */   {
/*     */   }
/*     */ 
/*     */   public void skippedEntity(String name)
/*     */     throws SAXException
/*     */   {
/*     */   }
/*     */ 
/*     */   public void startPrefixMapping(String prefix, String uri)
/*     */     throws SAXException
/*     */   {
/*     */   }
/*     */ 
/*     */   public void endPrefixMapping(String prefix)
/*     */     throws SAXException
/*     */   {
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.apache.xml.resolver.readers.OASISXMLCatalogReader
 * JD-Core Version:    0.6.0
 */