/*     */ package org.apache.xml.resolver.apps;
/*     */ 
/*     */ import java.io.FileNotFoundException;
/*     */ import java.io.IOException;
/*     */ import java.io.PrintStream;
/*     */ import java.net.MalformedURLException;
/*     */ import java.net.URL;
/*     */ import java.util.Vector;
/*     */ import org.apache.xml.resolver.Catalog;
/*     */ import org.apache.xml.resolver.CatalogManager;
/*     */ import org.apache.xml.resolver.helpers.Debug;
/*     */ import org.apache.xml.resolver.helpers.FileURL;
/*     */ import org.apache.xml.resolver.tools.CatalogResolver;
/*     */ 
/*     */ public class resolver
/*     */ {
/*  75 */   private static Debug debug = CatalogManager.getStaticManager().debug;
/*     */ 
/*     */   public static void main(String[] args)
/*     */     throws FileNotFoundException, IOException
/*     */   {
/*  81 */     int debuglevel = 0;
/*  82 */     Vector catalogFiles = new Vector();
/*  83 */     int resType = 0;
/*  84 */     String resTypeStr = null;
/*  85 */     String name = null;
/*  86 */     String publicId = null;
/*  87 */     String systemId = null;
/*  88 */     String uri = null;
/*  89 */     boolean absoluteSystem = false;
/*     */ 
/*  91 */     for (int i = 0; i < args.length; i++) {
/*  92 */       if (args[i].equals("-c")) {
/*  93 */         i++;
/*  94 */         catalogFiles.add(args[i]);
/*     */       }
/*  98 */       else if (args[i].equals("-p")) {
/*  99 */         i++;
/* 100 */         publicId = args[i];
/*     */       }
/* 104 */       else if (args[i].equals("-s")) {
/* 105 */         i++;
/* 106 */         systemId = args[i];
/*     */       }
/* 110 */       else if (args[i].equals("-n")) {
/* 111 */         i++;
/* 112 */         name = args[i];
/*     */       }
/* 116 */       else if (args[i].equals("-u")) {
/* 117 */         i++;
/* 118 */         uri = args[i];
/*     */       }
/* 122 */       else if (args[i].equals("-a")) {
/* 123 */         absoluteSystem = true;
/*     */       }
/* 127 */       else if (args[i].equals("-d")) {
/* 128 */         i++;
/* 129 */         String debugstr = args[i];
/*     */         try {
/* 131 */           debuglevel = Integer.parseInt(debugstr);
/* 132 */           if (debuglevel > 0)
/* 133 */             debug.setDebug(debuglevel);
/*     */         }
/*     */         catch (Exception e)
/*     */         {
/*     */         }
/*     */       }
/*     */       else
/*     */       {
/* 141 */         resTypeStr = args[i];
/*     */       }
/*     */     }
/* 144 */     if (resTypeStr == null) {
/* 145 */       usage();
/*     */     }
/*     */ 
/* 148 */     if (resTypeStr.equalsIgnoreCase("doctype")) {
/* 149 */       resType = Catalog.DOCTYPE;
/* 150 */       if ((publicId == null) && (systemId == null)) {
/* 151 */         System.out.println("DOCTYPE requires public or system identifier.");
/* 152 */         usage();
/*     */       }
/* 154 */     } else if (resTypeStr.equalsIgnoreCase("document")) {
/* 155 */       resType = Catalog.DOCUMENT;
/* 156 */     } else if (resTypeStr.equalsIgnoreCase("entity")) {
/* 157 */       resType = Catalog.ENTITY;
/* 158 */       if ((publicId == null) && (systemId == null) && (name == null)) {
/* 159 */         System.out.println("ENTITY requires name or public or system identifier.");
/* 160 */         usage();
/*     */       }
/* 162 */     } else if (resTypeStr.equalsIgnoreCase("notation")) {
/* 163 */       resType = Catalog.NOTATION;
/* 164 */       if ((publicId == null) && (systemId == null) && (name == null)) {
/* 165 */         System.out.println("NOTATION requires name or public or system identifier.");
/* 166 */         usage();
/*     */       }
/* 168 */     } else if (resTypeStr.equalsIgnoreCase("public")) {
/* 169 */       resType = Catalog.PUBLIC;
/* 170 */       if (publicId == null) {
/* 171 */         System.out.println("PUBLIC requires public identifier.");
/* 172 */         usage();
/*     */       }
/* 174 */     } else if (resTypeStr.equalsIgnoreCase("system")) {
/* 175 */       resType = Catalog.SYSTEM;
/* 176 */       if (systemId == null) {
/* 177 */         System.out.println("SYSTEM requires system identifier.");
/* 178 */         usage();
/*     */       }
/* 180 */     } else if (resTypeStr.equalsIgnoreCase("uri")) {
/* 181 */       resType = Catalog.URI;
/* 182 */       if (uri == null) {
/* 183 */         System.out.println("URI requires a uri.");
/* 184 */         usage();
/*     */       }
/*     */     } else {
/* 187 */       System.out.println(resTypeStr + " is not a recognized keyword.");
/* 188 */       usage();
/*     */     }
/*     */ 
/* 191 */     if (absoluteSystem) {
/* 192 */       URL base = null;
/* 193 */       URL sysid = null;
/*     */       try
/*     */       {
/* 198 */         base = FileURL.makeURL("basename");
/*     */       } catch (MalformedURLException e) {
/* 200 */         String userdir = System.getProperty("user.dir");
/* 201 */         userdir = userdir.replace('\\', '/');
/* 202 */         debug.message(1, "Malformed URL on cwd", userdir);
/* 203 */         base = null;
/*     */       }
/*     */       try
/*     */       {
/* 207 */         sysid = new URL(base, systemId);
/* 208 */         systemId = sysid.toString();
/*     */       } catch (MalformedURLException e) {
/*     */         try {
/* 211 */           sysid = new URL("file:///" + systemId);
/*     */         } catch (MalformedURLException e2) {
/* 213 */           debug.message(1, "Malformed URL on system id", systemId);
/*     */         }
/*     */       }
/*     */     }
/*     */ 
/* 218 */     CatalogResolver catalogResolver = new CatalogResolver();
/* 219 */     Catalog resolver = catalogResolver.getCatalog();
/*     */ 
/* 221 */     for (int count = 0; count < catalogFiles.size(); count++) {
/* 222 */       String file = (String)catalogFiles.elementAt(count);
/* 223 */       resolver.parseCatalog(file);
/*     */     }
/* 225 */     String result = null;
/*     */ 
/* 227 */     if (resType == Catalog.DOCTYPE) {
/* 228 */       System.out.println("Resolve DOCTYPE (name, publicid, systemid):");
/* 229 */       if (name != null) System.out.println("       name: " + name);
/* 230 */       if (publicId != null) System.out.println("  public id: " + publicId);
/* 231 */       if (systemId != null) System.out.println("  system id: " + systemId);
/* 232 */       if (uri != null) System.out.println("        uri: " + uri);
/* 233 */       result = resolver.resolveDoctype(name, publicId, systemId);
/* 234 */     } else if (resType == Catalog.DOCUMENT) {
/* 235 */       System.out.println("Resolve DOCUMENT ():");
/* 236 */       result = resolver.resolveDocument();
/* 237 */     } else if (resType == Catalog.ENTITY) {
/* 238 */       System.out.println("Resolve ENTITY (name, publicid, systemid):");
/* 239 */       if (name != null) System.out.println("       name: " + name);
/* 240 */       if (publicId != null) System.out.println("  public id: " + publicId);
/* 241 */       if (systemId != null) System.out.println("  system id: " + systemId);
/* 242 */       result = resolver.resolveEntity(name, publicId, systemId);
/* 243 */     } else if (resType == Catalog.NOTATION) {
/* 244 */       System.out.println("Resolve NOTATION (name, publicid, systemid):");
/* 245 */       if (name != null) System.out.println("       name: " + name);
/* 246 */       if (publicId != null) System.out.println("  public id: " + publicId);
/* 247 */       if (systemId != null) System.out.println("  system id: " + systemId);
/* 248 */       result = resolver.resolveNotation(name, publicId, systemId);
/* 249 */     } else if (resType == Catalog.PUBLIC) {
/* 250 */       System.out.println("Resolve PUBLIC (publicid, systemid):");
/* 251 */       if (publicId != null) System.out.println("  public id: " + publicId);
/* 252 */       if (systemId != null) System.out.println("  system id: " + systemId);
/* 253 */       result = resolver.resolvePublic(publicId, systemId);
/* 254 */     } else if (resType == Catalog.SYSTEM) {
/* 255 */       System.out.println("Resolve SYSTEM (systemid):");
/* 256 */       if (systemId != null) System.out.println("  system id: " + systemId);
/* 257 */       result = resolver.resolveSystem(systemId);
/* 258 */     } else if (resType == Catalog.URI) {
/* 259 */       System.out.println("Resolve URI (uri):");
/* 260 */       if (uri != null) System.out.println("        uri: " + uri);
/* 261 */       result = resolver.resolveURI(uri);
/*     */     } else {
/* 263 */       System.out.println("resType is wrong!? This can't happen!");
/* 264 */       usage();
/*     */     }
/*     */ 
/* 267 */     System.out.println("Result: " + result);
/*     */   }
/*     */ 
/*     */   public static void usage() {
/* 271 */     System.out.println("Usage: resolver [options] keyword");
/* 272 */     System.out.println("");
/* 273 */     System.out.println("Where:");
/* 274 */     System.out.println("");
/* 275 */     System.out.println("-c catalogfile  Loads a particular catalog file.");
/* 276 */     System.out.println("-n name         Sets the name.");
/* 277 */     System.out.println("-p publicId     Sets the public identifier.");
/* 278 */     System.out.println("-s systemId     Sets the system identifier.");
/* 279 */     System.out.println("-a              Makes the system URI absolute before resolution");
/* 280 */     System.out.println("-u uri          Sets the URI.");
/* 281 */     System.out.println("-d integer      Set the debug level.");
/* 282 */     System.out.println("keyword         Identifies the type of resolution to perform:");
/* 283 */     System.out.println("                doctype, document, entity, notation, public, system,");
/* 284 */     System.out.println("                or uri.");
/*     */ 
/* 286 */     System.exit(1);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.apache.xml.resolver.apps.resolver
 * JD-Core Version:    0.6.0
 */