/*     */ package org.apache.xml.resolver;
/*     */ 
/*     */ import java.util.Hashtable;
/*     */ import java.util.Vector;
/*     */ 
/*     */ public class CatalogEntry
/*     */ {
/*  53 */   protected static int nextEntry = 0;
/*     */ 
/*  60 */   protected static Hashtable entryTypes = new Hashtable();
/*     */ 
/*  64 */   protected static Vector entryArgs = new Vector();
/*     */ 
/* 139 */   protected int entryType = 0;
/*     */ 
/* 142 */   protected Vector args = null;
/*     */ 
/*     */   public static int addEntryType(String name, int numArgs)
/*     */   {
/*  78 */     entryTypes.put(name, new Integer(nextEntry));
/*  79 */     entryArgs.add(nextEntry, new Integer(numArgs));
/*  80 */     nextEntry += 1;
/*     */ 
/*  82 */     return nextEntry - 1;
/*     */   }
/*     */ 
/*     */   public static int getEntryType(String name)
/*     */     throws CatalogException
/*     */   {
/*  95 */     if (!entryTypes.containsKey(name)) {
/*  96 */       throw new CatalogException(3);
/*     */     }
/*     */ 
/*  99 */     Integer iType = (Integer)entryTypes.get(name);
/*     */ 
/* 101 */     if (iType == null) {
/* 102 */       throw new CatalogException(3);
/*     */     }
/*     */ 
/* 105 */     return iType.intValue();
/*     */   }
/*     */ 
/*     */   public static int getEntryArgCount(String name)
/*     */     throws CatalogException
/*     */   {
/* 118 */     return getEntryArgCount(getEntryType(name));
/*     */   }
/*     */ 
/*     */   public static int getEntryArgCount(int type)
/*     */     throws CatalogException
/*     */   {
/*     */     try
/*     */     {
/* 131 */       Integer iArgs = (Integer)entryArgs.get(type);
/* 132 */       return iArgs.intValue(); } catch (ArrayIndexOutOfBoundsException e) {
/*     */     }
/* 134 */     throw new CatalogException(3);
/*     */   }
/*     */ 
/*     */   public CatalogEntry()
/*     */   {
/*     */   }
/*     */ 
/*     */   public CatalogEntry(String name, Vector args)
/*     */     throws CatalogException
/*     */   {
/* 161 */     Integer iType = (Integer)entryTypes.get(name);
/*     */ 
/* 163 */     if (iType == null) {
/* 164 */       throw new CatalogException(3);
/*     */     }
/*     */ 
/* 167 */     int type = iType.intValue();
/*     */     try
/*     */     {
/* 170 */       Integer iArgs = (Integer)entryArgs.get(type);
/* 171 */       if (iArgs.intValue() != args.size())
/* 172 */         throw new CatalogException(2);
/*     */     }
/*     */     catch (ArrayIndexOutOfBoundsException e) {
/* 175 */       throw new CatalogException(3);
/*     */     }
/*     */ 
/* 178 */     this.entryType = type;
/* 179 */     this.args = args;
/*     */   }
/*     */ 
/*     */   public CatalogEntry(int type, Vector args)
/*     */     throws CatalogException
/*     */   {
/*     */     try
/*     */     {
/* 195 */       Integer iArgs = (Integer)entryArgs.get(type);
/* 196 */       if (iArgs.intValue() != args.size())
/* 197 */         throw new CatalogException(2);
/*     */     }
/*     */     catch (ArrayIndexOutOfBoundsException e) {
/* 200 */       throw new CatalogException(3);
/*     */     }
/*     */ 
/* 203 */     this.entryType = type;
/* 204 */     this.args = args;
/*     */   }
/*     */ 
/*     */   public int getEntryType()
/*     */   {
/* 213 */     return this.entryType;
/*     */   }
/*     */ 
/*     */   public String getEntryArg(int argNum)
/*     */   {
/*     */     try
/*     */     {
/* 225 */       String arg = (String)this.args.get(argNum);
/* 226 */       return arg; } catch (ArrayIndexOutOfBoundsException e) {
/*     */     }
/* 228 */     return null;
/*     */   }
/*     */ 
/*     */   public void setEntryArg(int argNum, String newspec)
/*     */     throws ArrayIndexOutOfBoundsException
/*     */   {
/* 247 */     this.args.set(argNum, newspec);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.apache.xml.resolver.CatalogEntry
 * JD-Core Version:    0.6.0
 */