package org.apache.xerces.xpointer;

import java.util.Hashtable;
import java.util.Vector;
import org.apache.xerces.impl.XMLErrorReporter;
import org.apache.xerces.util.MessageFormatter;
import org.apache.xerces.util.SymbolTable;
import org.apache.xerces.util.XMLChar;
import org.apache.xerces.util.XMLSymbols;
import org.apache.xerces.xinclude.XIncludeHandler;
import org.apache.xerces.xinclude.XIncludeNamespaceSupport;
import org.apache.xerces.xni.Augmentations;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xni.XMLAttributes;
import org.apache.xerces.xni.XMLDocumentHandler;
import org.apache.xerces.xni.XMLString;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.parser.XMLConfigurationException;
import org.apache.xerces.xni.parser.XMLErrorHandler;

public final class XPointerHandler extends XIncludeHandler
  implements XPointerProcessor
{
  protected Vector fXPointerParts = null;
  protected XPointerPart fXPointerPart = null;
  protected boolean fFoundMatchingPtrPart = false;
  protected XMLErrorReporter fXPointerErrorReporter;
  protected XMLErrorHandler fErrorHandler;
  protected SymbolTable fSymbolTable = null;
  private final String ELEMENT_SCHEME_NAME = "element";
  protected boolean fIsXPointerResolved = false;
  protected boolean fFixupBase = false;
  protected boolean fFixupLang = false;

  public XPointerHandler()
  {
    this.fSymbolTable = new SymbolTable();
  }

  public XPointerHandler(SymbolTable paramSymbolTable, XMLErrorHandler paramXMLErrorHandler, XMLErrorReporter paramXMLErrorReporter)
  {
    this.fSymbolTable = paramSymbolTable;
    this.fErrorHandler = paramXMLErrorHandler;
    this.fXPointerErrorReporter = paramXMLErrorReporter;
  }

  public void setDocumentHandler(XMLDocumentHandler paramXMLDocumentHandler)
  {
    this.fDocumentHandler = paramXMLDocumentHandler;
  }

  public void parseXPointer(String paramString)
    throws XNIException
  {
    init();
    Tokens localTokens = new Tokens(this.fSymbolTable, null);
    1 local1 = new Scanner(this.fSymbolTable)
    {
      protected void addToken(XPointerHandler.Tokens paramTokens, int paramInt)
        throws XNIException
      {
        if ((paramInt == 0) || (paramInt == 1) || (paramInt == 3) || (paramInt == 4) || (paramInt == 2))
        {
          super.addToken(paramTokens, paramInt);
          return;
        }
        XPointerHandler.this.reportError("InvalidXPointerToken", new Object[] { XPointerHandler.Tokens.access$200(paramTokens, paramInt) });
      }
    };
    int i = paramString.length();
    boolean bool = local1.scanExpr(this.fSymbolTable, localTokens, paramString, 0, i);
    if (!bool)
      reportError("InvalidXPointerExpression", new Object[] { paramString });
    while (localTokens.hasMore())
    {
      int j = localTokens.nextToken();
      String str1;
      Object localObject;
      switch (j)
      {
      case 2:
        j = localTokens.nextToken();
        str1 = localTokens.getTokenString(j);
        if (str1 == null)
          reportError("InvalidXPointerExpression", new Object[] { paramString });
        localObject = new ShortHandPointer(this.fSymbolTable);
        ((XPointerPart)localObject).setSchemeName(str1);
        this.fXPointerParts.add(localObject);
        break;
      case 3:
        j = localTokens.nextToken();
        str1 = localTokens.getTokenString(j);
        j = localTokens.nextToken();
        localObject = localTokens.getTokenString(j);
        String str2 = str1 + (String)localObject;
        int k = 0;
        int m = 0;
        j = localTokens.nextToken();
        String str3 = localTokens.getTokenString(j);
        if (str3 != "XPTRTOKEN_OPEN_PAREN")
          if (j == 2)
            reportError("MultipleShortHandPointers", new Object[] { paramString });
          else
            reportError("InvalidXPointerExpression", new Object[] { paramString });
        k++;
        String str4 = null;
        while (localTokens.hasMore())
        {
          j = localTokens.nextToken();
          str4 = localTokens.getTokenString(j);
          if (str4 != "XPTRTOKEN_OPEN_PAREN")
            break;
          k++;
        }
        j = localTokens.nextToken();
        str4 = localTokens.getTokenString(j);
        j = localTokens.nextToken();
        String str5 = localTokens.getTokenString(j);
        if (str5 != "XPTRTOKEN_CLOSE_PAREN")
          reportError("SchemeDataNotFollowedByCloseParenthesis", new Object[] { paramString });
        m++;
        while (localTokens.hasMore())
        {
          if (localTokens.getTokenString(Tokens.access$700(localTokens)) != "XPTRTOKEN_OPEN_PAREN")
            break;
          m++;
        }
        if (k != m)
          reportError("UnbalancedParenthesisInXPointerExpression", new Object[] { paramString, new Integer(k), new Integer(m) });
        if (str2.equals("element"))
        {
          ElementSchemePointer localElementSchemePointer = new ElementSchemePointer(this.fSymbolTable, this.fErrorReporter);
          localElementSchemePointer.setSchemeName(str2);
          localElementSchemePointer.setSchemeData(str4);
          try
          {
            localElementSchemePointer.parseXPointer(str4);
            this.fXPointerParts.add(localElementSchemePointer);
          }
          catch (XNIException localXNIException)
          {
            throw new XNIException(localXNIException);
          }
        }
        else
        {
          reportWarning("SchemeUnsupported", new Object[] { str2 });
        }
        break;
      default:
        reportError("InvalidXPointerExpression", new Object[] { paramString });
      }
    }
  }

  public boolean resolveXPointer(QName paramQName, XMLAttributes paramXMLAttributes, Augmentations paramAugmentations, int paramInt)
    throws XNIException
  {
    boolean bool = false;
    if (!this.fFoundMatchingPtrPart)
      for (int i = 0; i < this.fXPointerParts.size(); i++)
      {
        this.fXPointerPart = ((XPointerPart)this.fXPointerParts.get(i));
        if (!this.fXPointerPart.resolveXPointer(paramQName, paramXMLAttributes, paramAugmentations, paramInt))
          continue;
        this.fFoundMatchingPtrPart = true;
        bool = true;
      }
    else if (this.fXPointerPart.resolveXPointer(paramQName, paramXMLAttributes, paramAugmentations, paramInt))
      bool = true;
    if (!this.fIsXPointerResolved)
      this.fIsXPointerResolved = bool;
    return bool;
  }

  public boolean isFragmentResolved()
    throws XNIException
  {
    boolean bool = this.fXPointerPart != null ? this.fXPointerPart.isFragmentResolved() : false;
    if (!this.fIsXPointerResolved)
      this.fIsXPointerResolved = bool;
    return bool;
  }

  public boolean isChildFragmentResolved()
    throws XNIException
  {
    int i = this.fXPointerPart != null ? this.fXPointerPart.isChildFragmentResolved() : 0;
    return i;
  }

  public boolean isXPointerResolved()
    throws XNIException
  {
    return this.fIsXPointerResolved;
  }

  public XPointerPart getXPointerPart()
  {
    return this.fXPointerPart;
  }

  private void reportError(String paramString, Object[] paramArrayOfObject)
    throws XNIException
  {
    throw new XNIException(this.fErrorReporter.getMessageFormatter("http://www.w3.org/TR/XPTR").formatMessage(this.fErrorReporter.getLocale(), paramString, paramArrayOfObject));
  }

  private void reportWarning(String paramString, Object[] paramArrayOfObject)
    throws XNIException
  {
    this.fXPointerErrorReporter.reportError("http://www.w3.org/TR/XPTR", paramString, paramArrayOfObject, 0);
  }

  protected void initErrorReporter()
  {
    if (this.fXPointerErrorReporter == null)
      this.fXPointerErrorReporter = new XMLErrorReporter();
    if (this.fErrorHandler == null)
      this.fErrorHandler = new XPointerErrorHandler();
    this.fXPointerErrorReporter.putMessageFormatter("http://www.w3.org/TR/XPTR", new XPointerMessageFormatter());
  }

  protected void init()
  {
    this.fXPointerParts.clear();
    this.fXPointerPart = null;
    this.fFoundMatchingPtrPart = false;
    this.fIsXPointerResolved = false;
    initErrorReporter();
  }

  public Vector getPointerParts()
  {
    return this.fXPointerParts;
  }

  public void comment(XMLString paramXMLString, Augmentations paramAugmentations)
    throws XNIException
  {
    if (!isChildFragmentResolved())
      return;
    super.comment(paramXMLString, paramAugmentations);
  }

  public void processingInstruction(String paramString, XMLString paramXMLString, Augmentations paramAugmentations)
    throws XNIException
  {
    if (!isChildFragmentResolved())
      return;
    super.processingInstruction(paramString, paramXMLString, paramAugmentations);
  }

  public void startElement(QName paramQName, XMLAttributes paramXMLAttributes, Augmentations paramAugmentations)
    throws XNIException
  {
    if (!resolveXPointer(paramQName, paramXMLAttributes, paramAugmentations, 0))
    {
      if (this.fFixupBase)
        processXMLBaseAttributes(paramXMLAttributes);
      if (this.fFixupLang)
        processXMLLangAttributes(paramXMLAttributes);
      this.fNamespaceContext.setContextInvalid();
      return;
    }
    super.startElement(paramQName, paramXMLAttributes, paramAugmentations);
  }

  public void emptyElement(QName paramQName, XMLAttributes paramXMLAttributes, Augmentations paramAugmentations)
    throws XNIException
  {
    if (!resolveXPointer(paramQName, paramXMLAttributes, paramAugmentations, 2))
    {
      if (this.fFixupBase)
        processXMLBaseAttributes(paramXMLAttributes);
      if (this.fFixupLang)
        processXMLLangAttributes(paramXMLAttributes);
      this.fNamespaceContext.setContextInvalid();
      return;
    }
    super.emptyElement(paramQName, paramXMLAttributes, paramAugmentations);
  }

  public void characters(XMLString paramXMLString, Augmentations paramAugmentations)
    throws XNIException
  {
    if (!isChildFragmentResolved())
      return;
    super.characters(paramXMLString, paramAugmentations);
  }

  public void ignorableWhitespace(XMLString paramXMLString, Augmentations paramAugmentations)
    throws XNIException
  {
    if (!isChildFragmentResolved())
      return;
    super.ignorableWhitespace(paramXMLString, paramAugmentations);
  }

  public void endElement(QName paramQName, Augmentations paramAugmentations)
    throws XNIException
  {
    if (!resolveXPointer(paramQName, null, paramAugmentations, 1))
      return;
    super.endElement(paramQName, paramAugmentations);
  }

  public void startCDATA(Augmentations paramAugmentations)
    throws XNIException
  {
    if (!isChildFragmentResolved())
      return;
    super.startCDATA(paramAugmentations);
  }

  public void endCDATA(Augmentations paramAugmentations)
    throws XNIException
  {
    if (!isChildFragmentResolved())
      return;
    super.endCDATA(paramAugmentations);
  }

  public void setProperty(String paramString, Object paramObject)
    throws XMLConfigurationException
  {
    if (paramString == "http://apache.org/xml/properties/internal/error-reporter")
      if (paramObject != null)
        this.fXPointerErrorReporter = ((XMLErrorReporter)paramObject);
      else
        this.fXPointerErrorReporter = null;
    if (paramString == "http://apache.org/xml/properties/internal/error-handler")
      if (paramObject != null)
        this.fErrorHandler = ((XMLErrorHandler)paramObject);
      else
        this.fErrorHandler = null;
    if (paramString == "http://apache.org/xml/features/xinclude/fixup-language")
      if (paramObject != null)
        this.fFixupLang = ((Boolean)paramObject).booleanValue();
      else
        this.fFixupLang = false;
    if (paramString == "http://apache.org/xml/features/xinclude/fixup-base-uris")
      if (paramObject != null)
        this.fFixupBase = ((Boolean)paramObject).booleanValue();
      else
        this.fFixupBase = false;
    if (paramString == "http://apache.org/xml/properties/internal/namespace-context")
      this.fNamespaceContext = ((XIncludeNamespaceSupport)paramObject);
    super.setProperty(paramString, paramObject);
  }

  private class Scanner
  {
    private static final byte CHARTYPE_INVALID = 0;
    private static final byte CHARTYPE_OTHER = 1;
    private static final byte CHARTYPE_WHITESPACE = 2;
    private static final byte CHARTYPE_CARRET = 3;
    private static final byte CHARTYPE_OPEN_PAREN = 4;
    private static final byte CHARTYPE_CLOSE_PAREN = 5;
    private static final byte CHARTYPE_MINUS = 6;
    private static final byte CHARTYPE_PERIOD = 7;
    private static final byte CHARTYPE_SLASH = 8;
    private static final byte CHARTYPE_DIGIT = 9;
    private static final byte CHARTYPE_COLON = 10;
    private static final byte CHARTYPE_EQUAL = 11;
    private static final byte CHARTYPE_LETTER = 12;
    private static final byte CHARTYPE_UNDERSCORE = 13;
    private static final byte CHARTYPE_NONASCII = 14;
    private final byte[] fASCIICharMap;
    private SymbolTable fSymbolTable;
    private final XPointerHandler this$0;

    private Scanner(SymbolTable arg2)
    {
      this.this$0 = this$1;
      this.fASCIICharMap = new byte[] { 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 2, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 1, 1, 1, 1, 1, 1, 1, 4, 5, 1, 1, 1, 6, 7, 8, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 10, 1, 1, 11, 1, 1, 1, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 1, 1, 1, 3, 13, 1, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 1, 1, 1, 1, 1 };
      Object localObject;
      this.fSymbolTable = localObject;
    }

    private boolean scanExpr(SymbolTable paramSymbolTable, XPointerHandler.Tokens paramTokens, String paramString, int paramInt1, int paramInt2)
      throws XNIException
    {
      int j = 0;
      int k = 0;
      int i1 = 0;
      String str1 = null;
      String str2 = null;
      String str3 = null;
      StringBuffer localStringBuffer = new StringBuffer();
      while (paramInt1 != paramInt2)
      {
        for (int i = paramString.charAt(paramInt1); (i == 32) || (i == 10) || (i == 9) || (i == 13); i = paramString.charAt(paramInt1))
        {
          paramInt1++;
          if (paramInt1 == paramInt2)
            break;
        }
        if (paramInt1 == paramInt2)
          break;
        int i2 = i >= 128 ? 14 : this.fASCIICharMap[i];
        switch (i2)
        {
        case 4:
          addToken(paramTokens, 0);
          j++;
          paramInt1++;
          break;
        case 5:
          addToken(paramTokens, 1);
          k++;
          paramInt1++;
          break;
        case 1:
        case 2:
        case 3:
        case 6:
        case 7:
        case 8:
        case 9:
        case 10:
        case 11:
        case 12:
        case 13:
        case 14:
          if (j == 0)
          {
            int m = paramInt1;
            paramInt1 = scanNCName(paramString, paramInt2, paramInt1);
            if (paramInt1 == m)
            {
              this.this$0.reportError("InvalidShortHandPointer", new Object[] { paramString });
              return false;
            }
            if (paramInt1 < paramInt2)
              i = paramString.charAt(paramInt1);
            else
              i = -1;
            str1 = paramSymbolTable.addSymbol(paramString.substring(m, paramInt1));
            str2 = XMLSymbols.EMPTY_STRING;
            if (i == 58)
            {
              paramInt1++;
              if (paramInt1 == paramInt2)
                return false;
              i = paramString.charAt(paramInt1);
              str2 = str1;
              m = paramInt1;
              paramInt1 = scanNCName(paramString, paramInt2, paramInt1);
              if (paramInt1 == m)
                return false;
              if (paramInt1 < paramInt2)
                i = paramString.charAt(paramInt1);
              else
                i = -1;
              i1 = 1;
              str1 = paramSymbolTable.addSymbol(paramString.substring(m, paramInt1));
            }
            if (paramInt1 != paramInt2)
            {
              addToken(paramTokens, 3);
              XPointerHandler.Tokens.access$800(paramTokens, str2);
              XPointerHandler.Tokens.access$800(paramTokens, str1);
              i1 = 0;
            }
            else if (paramInt1 == paramInt2)
            {
              addToken(paramTokens, 2);
              XPointerHandler.Tokens.access$800(paramTokens, str1);
              i1 = 0;
            }
            k = 0;
          }
          else if ((j > 0) && (k == 0) && (str1 != null))
          {
            int n = paramInt1;
            paramInt1 = scanData(paramString, localStringBuffer, paramInt2, paramInt1);
            if (paramInt1 == n)
            {
              this.this$0.reportError("InvalidSchemeDataInXPointer", new Object[] { paramString });
              return false;
            }
            if (paramInt1 < paramInt2)
              i = paramString.charAt(paramInt1);
            else
              i = -1;
            str3 = paramSymbolTable.addSymbol(localStringBuffer.toString());
            addToken(paramTokens, 4);
            XPointerHandler.Tokens.access$800(paramTokens, str3);
            j = 0;
            localStringBuffer.delete(0, localStringBuffer.length());
          }
          else
          {
            return false;
          }
        }
      }
      return true;
    }

    private int scanNCName(String paramString, int paramInt1, int paramInt2)
    {
      int i = paramString.charAt(paramInt2);
      int j;
      if (i >= 128)
      {
        if (!XMLChar.isNameStart(i))
          return paramInt2;
      }
      else
      {
        j = this.fASCIICharMap[i];
        if ((j != 12) && (j != 13))
          return paramInt2;
      }
      do
      {
        i = paramString.charAt(paramInt2);
        if (i >= 128)
        {
          if (!XMLChar.isName(i))
            break;
        }
        else
        {
          j = this.fASCIICharMap[i];
          if ((j != 12) && (j != 9) && (j != 7) && (j != 6) && (j != 13))
            break;
        }
        paramInt2++;
      }
      while (paramInt2 < paramInt1);
      return paramInt2;
    }

    private int scanData(String paramString, StringBuffer paramStringBuffer, int paramInt1, int paramInt2)
    {
      while (paramInt2 != paramInt1)
      {
        int i = paramString.charAt(paramInt2);
        int j = i >= 128 ? 14 : this.fASCIICharMap[i];
        if (j == 4)
        {
          paramStringBuffer.append(i);
          paramInt2++;
          paramInt2 = scanData(paramString, paramStringBuffer, paramInt1, paramInt2);
          if (paramInt2 == paramInt1)
            return paramInt2;
          i = paramString.charAt(paramInt2);
          j = i >= 128 ? 14 : this.fASCIICharMap[i];
          if (j != 5)
            return paramInt1;
          paramStringBuffer.append((char)i);
          paramInt2++;
          continue;
        }
        if (j == 5)
          return paramInt2;
        if (j == 3)
        {
          paramInt2++;
          i = paramString.charAt(paramInt2);
          j = i >= 128 ? 14 : this.fASCIICharMap[i];
          if ((j != 3) && (j != 4) && (j != 5))
            break;
          paramStringBuffer.append((char)i);
          paramInt2++;
          continue;
        }
        paramStringBuffer.append((char)i);
        paramInt2++;
      }
      return paramInt2;
    }

    protected void addToken(XPointerHandler.Tokens paramTokens, int paramInt)
      throws XNIException
    {
      XPointerHandler.Tokens.access$900(paramTokens, paramInt);
    }

    Scanner(SymbolTable param1, XPointerHandler.1 arg3)
    {
      this(param1);
    }
  }

  private final class Tokens
  {
    private static final int XPTRTOKEN_OPEN_PAREN = 0;
    private static final int XPTRTOKEN_CLOSE_PAREN = 1;
    private static final int XPTRTOKEN_SHORTHAND = 2;
    private static final int XPTRTOKEN_SCHEMENAME = 3;
    private static final int XPTRTOKEN_SCHEMEDATA = 4;
    private final String[] fgTokenNames;
    private static final int INITIAL_TOKEN_COUNT = 256;
    private int[] fTokens;
    private int fTokenCount;
    private int fCurrentTokenIndex;
    private SymbolTable fSymbolTable;
    private Hashtable fTokenNames;
    private final XPointerHandler this$0;

    private Tokens(SymbolTable arg2)
    {
      this.this$0 = this$1;
      this.fgTokenNames = new String[] { "XPTRTOKEN_OPEN_PAREN", "XPTRTOKEN_CLOSE_PAREN", "XPTRTOKEN_SHORTHAND", "XPTRTOKEN_SCHEMENAME", "XPTRTOKEN_SCHEMEDATA" };
      this.fTokens = new int[256];
      this.fTokenCount = 0;
      this.fTokenNames = new Hashtable();
      Object localObject;
      this.fSymbolTable = localObject;
      this.fTokenNames.put(new Integer(0), "XPTRTOKEN_OPEN_PAREN");
      this.fTokenNames.put(new Integer(1), "XPTRTOKEN_CLOSE_PAREN");
      this.fTokenNames.put(new Integer(2), "XPTRTOKEN_SHORTHAND");
      this.fTokenNames.put(new Integer(3), "XPTRTOKEN_SCHEMENAME");
      this.fTokenNames.put(new Integer(4), "XPTRTOKEN_SCHEMEDATA");
    }

    private String getTokenString(int paramInt)
    {
      return (String)this.fTokenNames.get(new Integer(paramInt));
    }

    private void addToken(String paramString)
    {
      Integer localInteger = (Integer)this.fTokenNames.get(paramString);
      if (localInteger == null)
      {
        localInteger = new Integer(this.fTokenNames.size());
        this.fTokenNames.put(localInteger, paramString);
      }
      addToken(localInteger.intValue());
    }

    private void addToken(int paramInt)
    {
      try
      {
        this.fTokens[this.fTokenCount] = paramInt;
      }
      catch (ArrayIndexOutOfBoundsException localArrayIndexOutOfBoundsException)
      {
        int[] arrayOfInt = this.fTokens;
        this.fTokens = new int[this.fTokenCount << 1];
        System.arraycopy(arrayOfInt, 0, this.fTokens, 0, this.fTokenCount);
        this.fTokens[this.fTokenCount] = paramInt;
      }
      this.fTokenCount += 1;
    }

    private void rewind()
    {
      this.fCurrentTokenIndex = 0;
    }

    private boolean hasMore()
    {
      return this.fCurrentTokenIndex < this.fTokenCount;
    }

    private int nextToken()
      throws XNIException
    {
      if (this.fCurrentTokenIndex == this.fTokenCount)
        this.this$0.reportError("XPointerProcessingError", null);
      return this.fTokens[(this.fCurrentTokenIndex++)];
    }

    private int peekToken()
      throws XNIException
    {
      if (this.fCurrentTokenIndex == this.fTokenCount)
        this.this$0.reportError("XPointerProcessingError", null);
      return this.fTokens[this.fCurrentTokenIndex];
    }

    private String nextTokenAsString()
      throws XNIException
    {
      String str = getTokenString(nextToken());
      if (str == null)
        this.this$0.reportError("XPointerProcessingError", null);
      return str;
    }

    Tokens(SymbolTable param1, XPointerHandler.1 arg3)
    {
      this(param1);
    }
  }
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.apache.xerces.xpointer.XPointerHandler
 * JD-Core Version:    0.6.0
 */