package org.apache.xerces.xpointer;

import java.util.Hashtable;
import org.apache.xerces.impl.XMLErrorReporter;
import org.apache.xerces.util.MessageFormatter;
import org.apache.xerces.util.SymbolTable;
import org.apache.xerces.util.XMLChar;
import org.apache.xerces.xni.Augmentations;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xni.XMLAttributes;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.parser.XMLErrorHandler;

class ElementSchemePointer
  implements XPointerPart
{
  private String fSchemeName;
  private String fSchemeData;
  private String fShortHandPointerName;
  private boolean fIsResolveElement = false;
  private boolean fIsElementFound = false;
  private boolean fWasOnlyEmptyElementFound = false;
  boolean fIsShortHand = false;
  int fFoundDepth = 0;
  private int[] fChildSequence;
  private int fCurrentChildPosition = 1;
  private int fCurrentChildDepth = 0;
  private int[] fCurrentChildSequence;
  private boolean fIsFragmentResolved = false;
  private ShortHandPointer fShortHandPointer;
  protected XMLErrorReporter fErrorReporter;
  protected XMLErrorHandler fErrorHandler;
  private SymbolTable fSymbolTable;

  public ElementSchemePointer()
  {
  }

  public ElementSchemePointer(SymbolTable paramSymbolTable)
  {
    this.fSymbolTable = paramSymbolTable;
  }

  public ElementSchemePointer(SymbolTable paramSymbolTable, XMLErrorReporter paramXMLErrorReporter)
  {
    this.fSymbolTable = paramSymbolTable;
    this.fErrorReporter = paramXMLErrorReporter;
  }

  public void parseXPointer(String paramString)
    throws XNIException
  {
    init();
    Tokens localTokens = new Tokens(this.fSymbolTable, null);
    1 local1 = new Scanner(this.fSymbolTable)
    {
      protected void addToken(ElementSchemePointer.Tokens paramTokens, int paramInt)
        throws XNIException
      {
        if ((paramInt == 1) || (paramInt == 0))
        {
          super.addToken(paramTokens, paramInt);
          return;
        }
        ElementSchemePointer.this.reportError("InvalidElementSchemeToken", new Object[] { ElementSchemePointer.Tokens.access$200(paramTokens, paramInt) });
      }
    };
    int i = paramString.length();
    boolean bool = local1.scanExpr(this.fSymbolTable, localTokens, paramString, 0, i);
    if (!bool)
      reportError("InvalidElementSchemeXPointer", new Object[] { paramString });
    int[] arrayOfInt = new int[localTokens.getTokenCount() / 2 + 1];
    int j = 0;
    while (localTokens.hasMore())
    {
      int k = localTokens.nextToken();
      switch (k)
      {
      case 0:
        k = localTokens.nextToken();
        this.fShortHandPointerName = localTokens.getTokenString(k);
        this.fShortHandPointer = new ShortHandPointer(this.fSymbolTable);
        this.fShortHandPointer.setSchemeName(this.fShortHandPointerName);
        break;
      case 1:
        arrayOfInt[j] = Tokens.access$600(localTokens);
        j++;
        break;
      default:
        reportError("InvalidElementSchemeXPointer", new Object[] { paramString });
      }
    }
    this.fChildSequence = new int[j];
    this.fCurrentChildSequence = new int[j];
    System.arraycopy(arrayOfInt, 0, this.fChildSequence, 0, j);
  }

  public String getSchemeName()
  {
    return this.fSchemeName;
  }

  public String getSchemeData()
  {
    return this.fSchemeData;
  }

  public void setSchemeName(String paramString)
  {
    this.fSchemeName = paramString;
  }

  public void setSchemeData(String paramString)
  {
    this.fSchemeData = paramString;
  }

  public boolean resolveXPointer(QName paramQName, XMLAttributes paramXMLAttributes, Augmentations paramAugmentations, int paramInt)
    throws XNIException
  {
    boolean bool = false;
    if (this.fShortHandPointerName != null)
    {
      bool = this.fShortHandPointer.resolveXPointer(paramQName, paramXMLAttributes, paramAugmentations, paramInt);
      if (bool)
      {
        this.fIsResolveElement = true;
        this.fIsShortHand = true;
      }
      else
      {
        this.fIsResolveElement = false;
      }
    }
    else
    {
      this.fIsResolveElement = true;
    }
    if (this.fChildSequence.length > 0)
      this.fIsFragmentResolved = matchChildSequence(paramQName, paramInt);
    else if ((bool) && (this.fChildSequence.length <= 0))
      this.fIsFragmentResolved = bool;
    else
      this.fIsFragmentResolved = false;
    return this.fIsFragmentResolved;
  }

  protected boolean matchChildSequence(QName paramQName, int paramInt)
    throws XNIException
  {
    if (this.fCurrentChildDepth >= this.fCurrentChildSequence.length)
    {
      int[] arrayOfInt = new int[this.fCurrentChildSequence.length];
      System.arraycopy(this.fCurrentChildSequence, 0, arrayOfInt, 0, this.fCurrentChildSequence.length);
      this.fCurrentChildSequence = new int[this.fCurrentChildDepth * 2];
      System.arraycopy(arrayOfInt, 0, this.fCurrentChildSequence, 0, arrayOfInt.length);
    }
    if (this.fIsResolveElement)
      if (paramInt == 0)
      {
        this.fCurrentChildSequence[this.fCurrentChildDepth] = this.fCurrentChildPosition;
        this.fCurrentChildDepth += 1;
        this.fCurrentChildPosition = 1;
        if ((this.fCurrentChildDepth <= this.fFoundDepth) || (this.fFoundDepth == 0))
          if (checkMatch())
          {
            this.fIsElementFound = true;
            this.fFoundDepth = this.fCurrentChildDepth;
          }
          else
          {
            this.fIsElementFound = false;
            this.fFoundDepth = 0;
          }
      }
      else if (paramInt == 1)
      {
        if (this.fCurrentChildDepth == this.fFoundDepth)
          this.fIsElementFound = true;
        else if (((this.fCurrentChildDepth < this.fFoundDepth) && (this.fFoundDepth != 0)) || ((this.fCurrentChildDepth > this.fFoundDepth) && (this.fFoundDepth == 0)))
          this.fIsElementFound = false;
        this.fCurrentChildSequence[this.fCurrentChildDepth] = 0;
        this.fCurrentChildDepth -= 1;
        this.fCurrentChildPosition = (this.fCurrentChildSequence[this.fCurrentChildDepth] + 1);
      }
      else if (paramInt == 2)
      {
        this.fCurrentChildSequence[this.fCurrentChildDepth] = this.fCurrentChildPosition;
        this.fCurrentChildPosition += 1;
        if (checkMatch())
        {
          if (!this.fIsElementFound)
            this.fWasOnlyEmptyElementFound = true;
          else
            this.fWasOnlyEmptyElementFound = false;
          this.fIsElementFound = true;
        }
        else
        {
          this.fIsElementFound = false;
          this.fWasOnlyEmptyElementFound = false;
        }
      }
    return this.fIsElementFound;
  }

  protected boolean checkMatch()
  {
    int i;
    if (!this.fIsShortHand)
    {
      if (this.fChildSequence.length <= this.fCurrentChildDepth + 1)
        for (i = 0; i < this.fChildSequence.length; i++)
          if (this.fChildSequence[i] != this.fCurrentChildSequence[i])
            return false;
      else
        return false;
    }
    else if (this.fChildSequence.length <= this.fCurrentChildDepth + 1)
      for (i = 0; i < this.fChildSequence.length; i++)
      {
        if (this.fCurrentChildSequence.length < i + 2)
          return false;
        if (this.fChildSequence[i] != this.fCurrentChildSequence[(i + 1)])
          return false;
      }
    else
      return false;
    return true;
  }

  public boolean isFragmentResolved()
    throws XNIException
  {
    return this.fIsFragmentResolved;
  }

  public boolean isChildFragmentResolved()
  {
    if ((this.fIsShortHand) && (this.fShortHandPointer != null) && (this.fChildSequence.length <= 0))
      return this.fShortHandPointer.isChildFragmentResolved();
    return !this.fWasOnlyEmptyElementFound;
  }

  protected void reportError(String paramString, Object[] paramArrayOfObject)
    throws XNIException
  {
    throw new XNIException(this.fErrorReporter.getMessageFormatter("http://www.w3.org/TR/XPTR").formatMessage(this.fErrorReporter.getLocale(), paramString, paramArrayOfObject));
  }

  protected void initErrorReporter()
  {
    if (this.fErrorReporter == null)
      this.fErrorReporter = new XMLErrorReporter();
    if (this.fErrorHandler == null)
      this.fErrorHandler = new XPointerErrorHandler();
    this.fErrorReporter.putMessageFormatter("http://www.w3.org/TR/XPTR", new XPointerMessageFormatter());
  }

  protected void init()
  {
    this.fSchemeName = null;
    this.fSchemeData = null;
    this.fShortHandPointerName = null;
    this.fIsResolveElement = false;
    this.fIsElementFound = false;
    this.fWasOnlyEmptyElementFound = false;
    this.fFoundDepth = 0;
    this.fCurrentChildPosition = 1;
    this.fCurrentChildDepth = 0;
    this.fIsFragmentResolved = false;
    this.fShortHandPointer = null;
    initErrorReporter();
  }

  private class Scanner
  {
    private static final byte CHARTYPE_INVALID = 0;
    private static final byte CHARTYPE_OTHER = 1;
    private static final byte CHARTYPE_MINUS = 2;
    private static final byte CHARTYPE_PERIOD = 3;
    private static final byte CHARTYPE_SLASH = 4;
    private static final byte CHARTYPE_DIGIT = 5;
    private static final byte CHARTYPE_LETTER = 6;
    private static final byte CHARTYPE_UNDERSCORE = 7;
    private static final byte CHARTYPE_NONASCII = 8;
    private final byte[] fASCIICharMap;
    private SymbolTable fSymbolTable;
    private final ElementSchemePointer this$0;

    private Scanner(SymbolTable arg2)
    {
      this.this$0 = this$1;
      this.fASCIICharMap = new byte[] { 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 4, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 1, 1, 1, 1, 1, 1, 1, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 1, 1, 1, 1, 7, 1, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 1, 1, 1, 1, 1 };
      Object localObject;
      this.fSymbolTable = localObject;
    }

    private boolean scanExpr(SymbolTable paramSymbolTable, ElementSchemePointer.Tokens paramTokens, String paramString, int paramInt1, int paramInt2)
      throws XNIException
    {
      String str = null;
      while (paramInt1 != paramInt2)
      {
        int i = paramString.charAt(paramInt1);
        int k = i >= 128 ? 8 : this.fASCIICharMap[i];
        switch (k)
        {
        case 4:
          paramInt1++;
          if (paramInt1 == paramInt2)
            return false;
          addToken(paramTokens, 1);
          i = paramString.charAt(paramInt1);
          int m = 0;
          while ((i >= 48) && (i <= 57))
          {
            m = m * 10 + (i - 48);
            paramInt1++;
            if (paramInt1 == paramInt2)
              break;
            i = paramString.charAt(paramInt1);
          }
          if (m == 0)
          {
            this.this$0.reportError("InvalidChildSequenceCharacter", new Object[] { new Character((char)i) });
            return false;
          }
          ElementSchemePointer.Tokens.access$700(paramTokens, m);
          break;
        case 1:
        case 2:
        case 3:
        case 5:
        case 6:
        case 7:
        case 8:
          int j = paramInt1;
          paramInt1 = scanNCName(paramString, paramInt2, paramInt1);
          if (paramInt1 == j)
          {
            this.this$0.reportError("InvalidNCNameInElementSchemeData", new Object[] { paramString });
            return false;
          }
          if (paramInt1 < paramInt2)
            i = paramString.charAt(paramInt1);
          else
            i = -1;
          str = paramSymbolTable.addSymbol(paramString.substring(j, paramInt1));
          addToken(paramTokens, 0);
          ElementSchemePointer.Tokens.access$800(paramTokens, str);
        }
      }
      return true;
    }

    private int scanNCName(String paramString, int paramInt1, int paramInt2)
    {
      int i = paramString.charAt(paramInt2);
      int j;
      if (i >= 128)
      {
        if (!XMLChar.isNameStart(i))
          return paramInt2;
      }
      else
      {
        j = this.fASCIICharMap[i];
        if ((j != 6) && (j != 7))
          return paramInt2;
      }
      do
      {
        i = paramString.charAt(paramInt2);
        if (i >= 128)
        {
          if (!XMLChar.isName(i))
            break;
        }
        else
        {
          j = this.fASCIICharMap[i];
          if ((j != 6) && (j != 5) && (j != 3) && (j != 2) && (j != 7))
            break;
        }
        paramInt2++;
      }
      while (paramInt2 < paramInt1);
      return paramInt2;
    }

    protected void addToken(ElementSchemePointer.Tokens paramTokens, int paramInt)
      throws XNIException
    {
      ElementSchemePointer.Tokens.access$700(paramTokens, paramInt);
    }

    Scanner(SymbolTable param1, ElementSchemePointer.1 arg3)
    {
      this(param1);
    }
  }

  private final class Tokens
  {
    private static final int XPTRTOKEN_ELEM_NCNAME = 0;
    private static final int XPTRTOKEN_ELEM_CHILD = 1;
    private final String[] fgTokenNames;
    private static final int INITIAL_TOKEN_COUNT = 256;
    private int[] fTokens;
    private int fTokenCount;
    private int fCurrentTokenIndex;
    private SymbolTable fSymbolTable;
    private Hashtable fTokenNames;
    private final ElementSchemePointer this$0;

    private Tokens(SymbolTable arg2)
    {
      this.this$0 = this$1;
      this.fgTokenNames = new String[] { "XPTRTOKEN_ELEM_NCNAME", "XPTRTOKEN_ELEM_CHILD" };
      this.fTokens = new int[256];
      this.fTokenCount = 0;
      this.fTokenNames = new Hashtable();
      Object localObject;
      this.fSymbolTable = localObject;
      this.fTokenNames.put(new Integer(0), "XPTRTOKEN_ELEM_NCNAME");
      this.fTokenNames.put(new Integer(1), "XPTRTOKEN_ELEM_CHILD");
    }

    private String getTokenString(int paramInt)
    {
      return (String)this.fTokenNames.get(new Integer(paramInt));
    }

    private Integer getToken(int paramInt)
    {
      return (Integer)this.fTokenNames.get(new Integer(paramInt));
    }

    private void addToken(String paramString)
    {
      Integer localInteger = (Integer)this.fTokenNames.get(paramString);
      if (localInteger == null)
      {
        localInteger = new Integer(this.fTokenNames.size());
        this.fTokenNames.put(localInteger, paramString);
      }
      addToken(localInteger.intValue());
    }

    private void addToken(int paramInt)
    {
      try
      {
        this.fTokens[this.fTokenCount] = paramInt;
      }
      catch (ArrayIndexOutOfBoundsException localArrayIndexOutOfBoundsException)
      {
        int[] arrayOfInt = this.fTokens;
        this.fTokens = new int[this.fTokenCount << 1];
        System.arraycopy(arrayOfInt, 0, this.fTokens, 0, this.fTokenCount);
        this.fTokens[this.fTokenCount] = paramInt;
      }
      this.fTokenCount += 1;
    }

    private void rewind()
    {
      this.fCurrentTokenIndex = 0;
    }

    private boolean hasMore()
    {
      return this.fCurrentTokenIndex < this.fTokenCount;
    }

    private int nextToken()
      throws XNIException
    {
      if (this.fCurrentTokenIndex == this.fTokenCount)
        this.this$0.reportError("XPointerElementSchemeProcessingError", null);
      return this.fTokens[(this.fCurrentTokenIndex++)];
    }

    private int peekToken()
      throws XNIException
    {
      if (this.fCurrentTokenIndex == this.fTokenCount)
        this.this$0.reportError("XPointerElementSchemeProcessingError", null);
      return this.fTokens[this.fCurrentTokenIndex];
    }

    private String nextTokenAsString()
      throws XNIException
    {
      String str = getTokenString(nextToken());
      if (str == null)
        this.this$0.reportError("XPointerElementSchemeProcessingError", null);
      return str;
    }

    private int getTokenCount()
    {
      return this.fTokenCount;
    }

    Tokens(SymbolTable param1, ElementSchemePointer.1 arg3)
    {
      this(param1);
    }
  }
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.apache.xerces.xpointer.ElementSchemePointer
 * JD-Core Version:    0.6.0
 */