package org.apache.xerces.impl.dv.xs;

import org.apache.xerces.impl.dv.InvalidDatatypeValueException;
import org.apache.xerces.impl.dv.ValidationContext;
import org.apache.xerces.xs.datatypes.XSFloat;

public class FloatDV extends TypeValidator
{
  public short getAllowedFacets()
  {
    return 2552;
  }

  public Object getActualValue(String paramString, ValidationContext paramValidationContext)
    throws InvalidDatatypeValueException
  {
    // Byte code:
    //   0: new 2	org/apache/xerces/impl/dv/xs/FloatDV$XFloat
    //   3: dup
    //   4: aload_1
    //   5: invokespecial 3	org/apache/xerces/impl/dv/xs/FloatDV$XFloat:<init>	(Ljava/lang/String;)V
    //   8: areturn
    //   9: astore_3
    //   10: new 5	org/apache/xerces/impl/dv/InvalidDatatypeValueException
    //   13: dup
    //   14: ldc 6
    //   16: iconst_2
    //   17: anewarray 7	java/lang/Object
    //   20: dup
    //   21: iconst_0
    //   22: aload_1
    //   23: aastore
    //   24: dup
    //   25: iconst_1
    //   26: ldc 8
    //   28: aastore
    //   29: invokespecial 9	org/apache/xerces/impl/dv/InvalidDatatypeValueException:<init>	(Ljava/lang/String;[Ljava/lang/Object;)V
    //   32: athrow
    //
    // Exception table:
    //   from	to	target	type
    //   0	9	9	java/lang/NumberFormatException
  }

  public int compare(Object paramObject1, Object paramObject2)
  {
    return ((XFloat)paramObject1).compareTo((XFloat)paramObject2);
  }

  public boolean isIdentical(Object paramObject1, Object paramObject2)
  {
    if ((paramObject2 instanceof XFloat))
      return ((XFloat)paramObject1).isIdentical((XFloat)paramObject2);
    return false;
  }

  private static final class XFloat
    implements XSFloat
  {
    private float value;
    private String canonical;

    public XFloat(String paramString)
      throws NumberFormatException
    {
      if (DoubleDV.isPossibleFP(paramString))
        this.value = Float.parseFloat(paramString);
      else if (paramString.equals("INF"))
        this.value = (1.0F / 1.0F);
      else if (paramString.equals("-INF"))
        this.value = (1.0F / -1.0F);
      else if (paramString.equals("NaN"))
        this.value = (0.0F / 0.0F);
      else
        throw new NumberFormatException(paramString);
    }

    public boolean equals(Object paramObject)
    {
      if (paramObject == this)
        return true;
      if (!(paramObject instanceof XFloat))
        return false;
      XFloat localXFloat = (XFloat)paramObject;
      if (this.value == localXFloat.value)
        return true;
      return (this.value != this.value) && (localXFloat.value != localXFloat.value);
    }

    public int hashCode()
    {
      return this.value == 0.0F ? 0 : Float.floatToIntBits(this.value);
    }

    public boolean isIdentical(XFloat paramXFloat)
    {
      if (paramXFloat == this)
        return true;
      if (this.value == paramXFloat.value)
        return (this.value != 0.0F) || (Float.floatToIntBits(this.value) == Float.floatToIntBits(paramXFloat.value));
      return (this.value != this.value) && (paramXFloat.value != paramXFloat.value);
    }

    private int compareTo(XFloat paramXFloat)
    {
      float f = paramXFloat.value;
      if (this.value < f)
        return -1;
      if (this.value > f)
        return 1;
      if (this.value == f)
        return 0;
      if (this.value != this.value)
      {
        if (f != f)
          return 0;
        return 2;
      }
      return 2;
    }

    public synchronized String toString()
    {
      if (this.canonical == null)
        if (this.value == (1.0F / 1.0F))
        {
          this.canonical = "INF";
        }
        else if (this.value == (1.0F / -1.0F))
        {
          this.canonical = "-INF";
        }
        else if (this.value != this.value)
        {
          this.canonical = "NaN";
        }
        else if (this.value == 0.0F)
        {
          this.canonical = "0.0E1";
        }
        else
        {
          this.canonical = Float.toString(this.value);
          if (this.canonical.indexOf('E') == -1)
          {
            int i = this.canonical.length();
            char[] arrayOfChar = new char[i + 3];
            this.canonical.getChars(0, i, arrayOfChar, 0);
            int j = arrayOfChar[0] == '-' ? 2 : 1;
            int k;
            int m;
            int n;
            if ((this.value >= 1.0F) || (this.value <= -1.0F))
            {
              k = this.canonical.indexOf('.');
              for (m = k; m > j; m--)
                arrayOfChar[m] = arrayOfChar[(m - 1)];
              arrayOfChar[j] = '.';
              while (arrayOfChar[(i - 1)] == '0')
                i--;
              if (arrayOfChar[(i - 1)] == '.')
                i++;
              arrayOfChar[(i++)] = 'E';
              n = k - j;
              arrayOfChar[(i++)] = (char)(n + 48);
            }
            else
            {
              for (k = j + 1; arrayOfChar[k] == '0'; k++);
              arrayOfChar[(j - 1)] = arrayOfChar[k];
              arrayOfChar[j] = '.';
              m = k + 1;
              for (n = j + 1; m < i; n++)
              {
                arrayOfChar[n] = arrayOfChar[m];
                m++;
              }
              i -= k - j;
              if (i == j + 1)
                arrayOfChar[(i++)] = '0';
              arrayOfChar[(i++)] = 'E';
              arrayOfChar[(i++)] = '-';
              int i1 = k - j;
              arrayOfChar[(i++)] = (char)(i1 + 48);
            }
            this.canonical = new String(arrayOfChar, 0, i);
          }
        }
      return this.canonical;
    }

    public float getValue()
    {
      return this.value;
    }
  }
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.apache.xerces.impl.dv.xs.FloatDV
 * JD-Core Version:    0.6.0
 */