package org.apache.xerces.impl.dv.xs;

import java.math.BigDecimal;
import java.math.BigInteger;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.Duration;
import org.apache.xerces.impl.dv.InvalidDatatypeValueException;
import org.apache.xerces.impl.dv.ValidationContext;

class DayTimeDurationDV extends DurationDV
{
  public Object getActualValue(String paramString, ValidationContext paramValidationContext)
    throws InvalidDatatypeValueException
  {
    // Byte code:
    //   0: aload_0
    //   1: aload_1
    //   2: iconst_2
    //   3: invokevirtual 2	org/apache/xerces/impl/dv/xs/DurationDV:parse	(Ljava/lang/String;I)Lorg/apache/xerces/impl/dv/xs/AbstractDateTimeDV$DateTimeData;
    //   6: areturn
    //   7: astore_3
    //   8: new 4	org/apache/xerces/impl/dv/InvalidDatatypeValueException
    //   11: dup
    //   12: ldc 5
    //   14: iconst_2
    //   15: anewarray 6	java/lang/Object
    //   18: dup
    //   19: iconst_0
    //   20: aload_1
    //   21: aastore
    //   22: dup
    //   23: iconst_1
    //   24: ldc 7
    //   26: aastore
    //   27: invokespecial 8	org/apache/xerces/impl/dv/InvalidDatatypeValueException:<init>	(Ljava/lang/String;[Ljava/lang/Object;)V
    //   30: athrow
    //
    // Exception table:
    //   from	to	target	type
    //   0	7	7	java/lang/Exception
  }

  protected Duration getDuration(AbstractDateTimeDV.DateTimeData paramDateTimeData)
  {
    int i = 1;
    if ((paramDateTimeData.day < 0) || (paramDateTimeData.hour < 0) || (paramDateTimeData.minute < 0) || (paramDateTimeData.second < 0.0D))
      i = -1;
    return this.factory.newDuration(i == 1, null, null, paramDateTimeData.day != -2147483648 ? BigInteger.valueOf(i * paramDateTimeData.day) : null, paramDateTimeData.hour != -2147483648 ? BigInteger.valueOf(i * paramDateTimeData.hour) : null, paramDateTimeData.minute != -2147483648 ? BigInteger.valueOf(i * paramDateTimeData.minute) : null, paramDateTimeData.second != -2147483648.0D ? new BigDecimal(String.valueOf(i * paramDateTimeData.second)) : null);
  }
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.apache.xerces.impl.dv.xs.DayTimeDurationDV
 * JD-Core Version:    0.6.0
 */