package org.apache.xerces.impl.dv.xs;

import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.xerces.impl.dv.InvalidDatatypeValueException;
import org.apache.xerces.impl.dv.ValidationContext;

public class DateDV extends DateTimeDV
{
  public Object getActualValue(String paramString, ValidationContext paramValidationContext)
    throws InvalidDatatypeValueException
  {
    // Byte code:
    //   0: aload_0
    //   1: aload_1
    //   2: invokevirtual 2	org/apache/xerces/impl/dv/xs/DateDV:parse	(Ljava/lang/String;)Lorg/apache/xerces/impl/dv/xs/AbstractDateTimeDV$DateTimeData;
    //   5: areturn
    //   6: astore_3
    //   7: new 4	org/apache/xerces/impl/dv/InvalidDatatypeValueException
    //   10: dup
    //   11: ldc 5
    //   13: iconst_2
    //   14: anewarray 6	java/lang/Object
    //   17: dup
    //   18: iconst_0
    //   19: aload_1
    //   20: aastore
    //   21: dup
    //   22: iconst_1
    //   23: ldc 7
    //   25: aastore
    //   26: invokespecial 8	org/apache/xerces/impl/dv/InvalidDatatypeValueException:<init>	(Ljava/lang/String;[Ljava/lang/Object;)V
    //   29: athrow
    //
    // Exception table:
    //   from	to	target	type
    //   0	6	6	java/lang/Exception
  }

  protected AbstractDateTimeDV.DateTimeData parse(String paramString)
    throws SchemaDateTimeException
  {
    AbstractDateTimeDV.DateTimeData localDateTimeData = new AbstractDateTimeDV.DateTimeData(paramString, this);
    int i = paramString.length();
    int j = getDate(paramString, 0, i, localDateTimeData);
    parseTimeZone(paramString, j, i, localDateTimeData);
    validateDateTime(localDateTimeData);
    saveUnnormalized(localDateTimeData);
    if ((localDateTimeData.utc != 0) && (localDateTimeData.utc != 90))
      normalize(localDateTimeData);
    return localDateTimeData;
  }

  protected String dateToString(AbstractDateTimeDV.DateTimeData paramDateTimeData)
  {
    StringBuffer localStringBuffer = new StringBuffer(25);
    append(localStringBuffer, paramDateTimeData.year, 4);
    localStringBuffer.append('-');
    append(localStringBuffer, paramDateTimeData.month, 2);
    localStringBuffer.append('-');
    append(localStringBuffer, paramDateTimeData.day, 2);
    append(localStringBuffer, (char)paramDateTimeData.utc, 0);
    return localStringBuffer.toString();
  }

  protected XMLGregorianCalendar getXMLGregorianCalendar(AbstractDateTimeDV.DateTimeData paramDateTimeData)
  {
    return this.factory.newXMLGregorianCalendar(paramDateTimeData.unNormYear, paramDateTimeData.unNormMonth, paramDateTimeData.unNormDay, -2147483648, -2147483648, -2147483648, -2147483648, paramDateTimeData.timezoneHr * 60 + paramDateTimeData.timezoneMin);
  }
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.apache.xerces.impl.dv.xs.DateDV
 * JD-Core Version:    0.6.0
 */