package org.apache.xerces.impl.dv.xs;

import org.apache.xerces.impl.dv.SchemaDVFactory;
import org.apache.xerces.impl.dv.XSFacets;
import org.apache.xerces.impl.dv.XSSimpleType;
import org.apache.xerces.util.SymbolHash;
import org.apache.xerces.xs.XSObjectList;

public class BaseDVFactory extends SchemaDVFactory
{
  static final String URI_SCHEMAFORSCHEMA = "http://www.w3.org/2001/XMLSchema";
  static SymbolHash fBaseTypes = new SymbolHash(53);

  public XSSimpleType getBuiltInType(String paramString)
  {
    return (XSSimpleType)fBaseTypes.get(paramString);
  }

  public SymbolHash getBuiltInTypes()
  {
    return fBaseTypes.makeClone();
  }

  public XSSimpleType createTypeRestriction(String paramString1, String paramString2, short paramShort, XSSimpleType paramXSSimpleType, XSObjectList paramXSObjectList)
  {
    return new XSSimpleTypeDecl((XSSimpleTypeDecl)paramXSSimpleType, paramString1, paramString2, paramShort, false, paramXSObjectList);
  }

  public XSSimpleType createTypeList(String paramString1, String paramString2, short paramShort, XSSimpleType paramXSSimpleType, XSObjectList paramXSObjectList)
  {
    return new XSSimpleTypeDecl(paramString1, paramString2, paramShort, (XSSimpleTypeDecl)paramXSSimpleType, false, paramXSObjectList);
  }

  public XSSimpleType createTypeUnion(String paramString1, String paramString2, short paramShort, XSSimpleType[] paramArrayOfXSSimpleType, XSObjectList paramXSObjectList)
  {
    int i = paramArrayOfXSSimpleType.length;
    XSSimpleTypeDecl[] arrayOfXSSimpleTypeDecl = new XSSimpleTypeDecl[i];
    System.arraycopy(paramArrayOfXSSimpleType, 0, arrayOfXSSimpleTypeDecl, 0, i);
    return new XSSimpleTypeDecl(paramString1, paramString2, paramShort, arrayOfXSSimpleTypeDecl, paramXSObjectList);
  }

  static void createBuiltInTypes(SymbolHash paramSymbolHash)
  {
    XSFacets localXSFacets = new XSFacets();
    XSSimpleTypeDecl localXSSimpleTypeDecl1 = XSSimpleTypeDecl.fAnySimpleType;
    paramSymbolHash.put("anySimpleType", localXSSimpleTypeDecl1);
    XSSimpleTypeDecl localXSSimpleTypeDecl2 = new XSSimpleTypeDecl(localXSSimpleTypeDecl1, "string", 1, 0, false, false, false, true, 2);
    paramSymbolHash.put("string", localXSSimpleTypeDecl2);
    paramSymbolHash.put("boolean", new XSSimpleTypeDecl(localXSSimpleTypeDecl1, "boolean", 2, 0, false, true, false, true, 3));
    XSSimpleTypeDecl localXSSimpleTypeDecl3 = new XSSimpleTypeDecl(localXSSimpleTypeDecl1, "decimal", 3, 2, false, false, true, true, 4);
    paramSymbolHash.put("decimal", localXSSimpleTypeDecl3);
    paramSymbolHash.put("anyURI", new XSSimpleTypeDecl(localXSSimpleTypeDecl1, "anyURI", 17, 0, false, false, false, true, 18));
    paramSymbolHash.put("base64Binary", new XSSimpleTypeDecl(localXSSimpleTypeDecl1, "base64Binary", 16, 0, false, false, false, true, 17));
    paramSymbolHash.put("dateTime", new XSSimpleTypeDecl(localXSSimpleTypeDecl1, "dateTime", 7, 1, false, false, false, true, 8));
    paramSymbolHash.put("time", new XSSimpleTypeDecl(localXSSimpleTypeDecl1, "time", 8, 1, false, false, false, true, 9));
    paramSymbolHash.put("date", new XSSimpleTypeDecl(localXSSimpleTypeDecl1, "date", 9, 1, false, false, false, true, 10));
    paramSymbolHash.put("gYearMonth", new XSSimpleTypeDecl(localXSSimpleTypeDecl1, "gYearMonth", 10, 1, false, false, false, true, 11));
    paramSymbolHash.put("gYear", new XSSimpleTypeDecl(localXSSimpleTypeDecl1, "gYear", 11, 1, false, false, false, true, 12));
    paramSymbolHash.put("gMonthDay", new XSSimpleTypeDecl(localXSSimpleTypeDecl1, "gMonthDay", 12, 1, false, false, false, true, 13));
    paramSymbolHash.put("gDay", new XSSimpleTypeDecl(localXSSimpleTypeDecl1, "gDay", 13, 1, false, false, false, true, 14));
    paramSymbolHash.put("gMonth", new XSSimpleTypeDecl(localXSSimpleTypeDecl1, "gMonth", 14, 1, false, false, false, true, 15));
    XSSimpleTypeDecl localXSSimpleTypeDecl4 = new XSSimpleTypeDecl(localXSSimpleTypeDecl3, "integer", 24, 2, false, false, true, true, 30);
    paramSymbolHash.put("integer", localXSSimpleTypeDecl4);
    localXSFacets.maxInclusive = "0";
    XSSimpleTypeDecl localXSSimpleTypeDecl5 = new XSSimpleTypeDecl(localXSSimpleTypeDecl4, "nonPositiveInteger", "http://www.w3.org/2001/XMLSchema", 0, false, null, 31);
    localXSSimpleTypeDecl5.applyFacets1(localXSFacets, 32, 0);
    paramSymbolHash.put("nonPositiveInteger", localXSSimpleTypeDecl5);
    localXSFacets.maxInclusive = "-1";
    XSSimpleTypeDecl localXSSimpleTypeDecl6 = new XSSimpleTypeDecl(localXSSimpleTypeDecl4, "negativeInteger", "http://www.w3.org/2001/XMLSchema", 0, false, null, 32);
    localXSSimpleTypeDecl6.applyFacets1(localXSFacets, 32, 0);
    paramSymbolHash.put("negativeInteger", localXSSimpleTypeDecl6);
    localXSFacets.maxInclusive = "9223372036854775807";
    localXSFacets.minInclusive = "-9223372036854775808";
    XSSimpleTypeDecl localXSSimpleTypeDecl7 = new XSSimpleTypeDecl(localXSSimpleTypeDecl4, "long", "http://www.w3.org/2001/XMLSchema", 0, false, null, 33);
    localXSSimpleTypeDecl7.applyFacets1(localXSFacets, 288, 0);
    paramSymbolHash.put("long", localXSSimpleTypeDecl7);
    localXSFacets.maxInclusive = "2147483647";
    localXSFacets.minInclusive = "-2147483648";
    XSSimpleTypeDecl localXSSimpleTypeDecl8 = new XSSimpleTypeDecl(localXSSimpleTypeDecl7, "int", "http://www.w3.org/2001/XMLSchema", 0, false, null, 34);
    localXSSimpleTypeDecl8.applyFacets1(localXSFacets, 288, 0);
    paramSymbolHash.put("int", localXSSimpleTypeDecl8);
    localXSFacets.maxInclusive = "32767";
    localXSFacets.minInclusive = "-32768";
    XSSimpleTypeDecl localXSSimpleTypeDecl9 = new XSSimpleTypeDecl(localXSSimpleTypeDecl8, "short", "http://www.w3.org/2001/XMLSchema", 0, false, null, 35);
    localXSSimpleTypeDecl9.applyFacets1(localXSFacets, 288, 0);
    paramSymbolHash.put("short", localXSSimpleTypeDecl9);
    localXSFacets.maxInclusive = "127";
    localXSFacets.minInclusive = "-128";
    XSSimpleTypeDecl localXSSimpleTypeDecl10 = new XSSimpleTypeDecl(localXSSimpleTypeDecl9, "byte", "http://www.w3.org/2001/XMLSchema", 0, false, null, 36);
    localXSSimpleTypeDecl10.applyFacets1(localXSFacets, 288, 0);
    paramSymbolHash.put("byte", localXSSimpleTypeDecl10);
    localXSFacets.minInclusive = "0";
    XSSimpleTypeDecl localXSSimpleTypeDecl11 = new XSSimpleTypeDecl(localXSSimpleTypeDecl4, "nonNegativeInteger", "http://www.w3.org/2001/XMLSchema", 0, false, null, 37);
    localXSSimpleTypeDecl11.applyFacets1(localXSFacets, 256, 0);
    paramSymbolHash.put("nonNegativeInteger", localXSSimpleTypeDecl11);
    localXSFacets.maxInclusive = "18446744073709551615";
    XSSimpleTypeDecl localXSSimpleTypeDecl12 = new XSSimpleTypeDecl(localXSSimpleTypeDecl11, "unsignedLong", "http://www.w3.org/2001/XMLSchema", 0, false, null, 38);
    localXSSimpleTypeDecl12.applyFacets1(localXSFacets, 32, 0);
    paramSymbolHash.put("unsignedLong", localXSSimpleTypeDecl12);
    localXSFacets.maxInclusive = "4294967295";
    XSSimpleTypeDecl localXSSimpleTypeDecl13 = new XSSimpleTypeDecl(localXSSimpleTypeDecl12, "unsignedInt", "http://www.w3.org/2001/XMLSchema", 0, false, null, 39);
    localXSSimpleTypeDecl13.applyFacets1(localXSFacets, 32, 0);
    paramSymbolHash.put("unsignedInt", localXSSimpleTypeDecl13);
    localXSFacets.maxInclusive = "65535";
    XSSimpleTypeDecl localXSSimpleTypeDecl14 = new XSSimpleTypeDecl(localXSSimpleTypeDecl13, "unsignedShort", "http://www.w3.org/2001/XMLSchema", 0, false, null, 40);
    localXSSimpleTypeDecl14.applyFacets1(localXSFacets, 32, 0);
    paramSymbolHash.put("unsignedShort", localXSSimpleTypeDecl14);
    localXSFacets.maxInclusive = "255";
    XSSimpleTypeDecl localXSSimpleTypeDecl15 = new XSSimpleTypeDecl(localXSSimpleTypeDecl14, "unsignedByte", "http://www.w3.org/2001/XMLSchema", 0, false, null, 41);
    localXSSimpleTypeDecl15.applyFacets1(localXSFacets, 32, 0);
    paramSymbolHash.put("unsignedByte", localXSSimpleTypeDecl15);
    localXSFacets.minInclusive = "1";
    XSSimpleTypeDecl localXSSimpleTypeDecl16 = new XSSimpleTypeDecl(localXSSimpleTypeDecl11, "positiveInteger", "http://www.w3.org/2001/XMLSchema", 0, false, null, 42);
    localXSSimpleTypeDecl16.applyFacets1(localXSFacets, 256, 0);
    paramSymbolHash.put("positiveInteger", localXSSimpleTypeDecl16);
  }

  static
  {
    createBuiltInTypes(fBaseTypes);
  }
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.apache.xerces.impl.dv.xs.BaseDVFactory
 * JD-Core Version:    0.6.0
 */