package org.apache.xerces.impl.dtd.models;

public abstract class CMNode
{
  private int fType;
  private CMStateSet fFirstPos = null;
  private CMStateSet fFollowPos = null;
  private CMStateSet fLastPos = null;
  private int fMaxStates = -1;

  public CMNode(int paramInt)
  {
    this.fType = paramInt;
  }

  public abstract boolean isNullable();

  public final int type()
  {
    return this.fType;
  }

  public final CMStateSet firstPos()
  {
    if (this.fFirstPos == null)
    {
      this.fFirstPos = new CMStateSet(this.fMaxStates);
      calcFirstPos(this.fFirstPos);
    }
    return this.fFirstPos;
  }

  public final CMStateSet lastPos()
  {
    if (this.fLastPos == null)
    {
      this.fLastPos = new CMStateSet(this.fMaxStates);
      calcLastPos(this.fLastPos);
    }
    return this.fLastPos;
  }

  final void setFollowPos(CMStateSet paramCMStateSet)
  {
    this.fFollowPos = paramCMStateSet;
  }

  public final void setMaxStates(int paramInt)
  {
    this.fMaxStates = paramInt;
  }

  protected abstract void calcFirstPos(CMStateSet paramCMStateSet);

  protected abstract void calcLastPos(CMStateSet paramCMStateSet);
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.apache.xerces.impl.dtd.models.CMNode
 * JD-Core Version:    0.6.0
 */