package org.apache.xerces.impl;

import java.io.IOException;
import org.apache.xerces.util.SymbolTable;
import org.apache.xerces.util.XML11Char;
import org.apache.xerces.util.XMLChar;
import org.apache.xerces.util.XMLStringBuffer;
import org.apache.xerces.xni.XMLString;
import org.apache.xerces.xni.XNIException;

public class XML11DTDScannerImpl extends XMLDTDScannerImpl
{
  private XMLStringBuffer fStringBuffer = new XMLStringBuffer();

  public XML11DTDScannerImpl()
  {
  }

  public XML11DTDScannerImpl(SymbolTable paramSymbolTable, XMLErrorReporter paramXMLErrorReporter, XMLEntityManager paramXMLEntityManager)
  {
    super(paramSymbolTable, paramXMLErrorReporter, paramXMLEntityManager);
  }

  protected boolean scanPubidLiteral(XMLString paramXMLString)
    throws IOException, XNIException
  {
    int i = this.fEntityScanner.scanChar();
    if ((i != 39) && (i != 34))
    {
      reportFatalError("QuoteRequiredInPublicID", null);
      return false;
    }
    this.fStringBuffer.clear();
    int j = 1;
    int k = 1;
    while (true)
    {
      int m = this.fEntityScanner.scanChar();
      if ((m == 32) || (m == 10) || (m == 13) || (m == 133) || (m == 8232))
      {
        if (j != 0)
          continue;
        this.fStringBuffer.append(' ');
        j = 1;
        continue;
      }
      if (m == i)
      {
        if (j != 0)
          this.fStringBuffer.length -= 1;
        paramXMLString.setValues(this.fStringBuffer);
        break;
      }
      if (XMLChar.isPubid(m))
      {
        this.fStringBuffer.append((char)m);
        j = 0;
        continue;
      }
      if (m == -1)
      {
        reportFatalError("PublicIDUnterminated", null);
        return false;
      }
      k = 0;
      reportFatalError("InvalidCharInPublicID", new Object[] { Integer.toHexString(m) });
    }
    return k;
  }

  protected void normalizeWhitespace(XMLString paramXMLString)
  {
    int i = paramXMLString.offset + paramXMLString.length;
    for (int j = paramXMLString.offset; j < i; j++)
    {
      int k = paramXMLString.ch[j];
      if (!XMLChar.isSpace(k))
        continue;
      paramXMLString.ch[j] = ' ';
    }
  }

  protected void normalizeWhitespace(XMLString paramXMLString, int paramInt)
  {
    int i = paramXMLString.offset + paramXMLString.length;
    for (int j = paramXMLString.offset + paramInt; j < i; j++)
    {
      int k = paramXMLString.ch[j];
      if (!XMLChar.isSpace(k))
        continue;
      paramXMLString.ch[j] = ' ';
    }
  }

  protected int isUnchangedByNormalization(XMLString paramXMLString)
  {
    int i = paramXMLString.offset + paramXMLString.length;
    for (int j = paramXMLString.offset; j < i; j++)
    {
      int k = paramXMLString.ch[j];
      if (XMLChar.isSpace(k))
        return j - paramXMLString.offset;
    }
    return -1;
  }

  protected boolean isInvalid(int paramInt)
  {
    return !XML11Char.isXML11Valid(paramInt);
  }

  protected boolean isInvalidLiteral(int paramInt)
  {
    return !XML11Char.isXML11ValidLiteral(paramInt);
  }

  protected boolean isValidNameChar(int paramInt)
  {
    return XML11Char.isXML11Name(paramInt);
  }

  protected boolean isValidNameStartChar(int paramInt)
  {
    return XML11Char.isXML11NameStart(paramInt);
  }

  protected boolean isValidNCName(int paramInt)
  {
    return XML11Char.isXML11NCName(paramInt);
  }

  protected boolean isValidNameStartHighSurrogate(int paramInt)
  {
    return XML11Char.isXML11NameHighSurrogate(paramInt);
  }

  protected boolean versionSupported(String paramString)
  {
    return (paramString.equals("1.1")) || (paramString.equals("1.0"));
  }

  protected String getVersionNotSupportedKey()
  {
    return "VersionNotSupported11";
  }
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.apache.xerces.impl.XML11DTDScannerImpl
 * JD-Core Version:    0.6.0
 */