/*     */ package org.apache.commons.collections.map;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.ObjectInputStream;
/*     */ import java.io.ObjectOutputStream;
/*     */ import java.io.Serializable;
/*     */ import java.util.Map;
/*     */ 
/*     */ public class CaseInsensitiveMap extends AbstractHashedMap
/*     */   implements Serializable, Cloneable
/*     */ {
/*     */   private static final long serialVersionUID = -7074655917369299456L;
/*     */ 
/*     */   public CaseInsensitiveMap()
/*     */   {
/*  62 */     super(16, 0.75F, 12);
/*     */   }
/*     */ 
/*     */   public CaseInsensitiveMap(int initialCapacity)
/*     */   {
/*  72 */     super(initialCapacity);
/*     */   }
/*     */ 
/*     */   public CaseInsensitiveMap(int initialCapacity, float loadFactor)
/*     */   {
/*  85 */     super(initialCapacity, loadFactor);
/*     */   }
/*     */ 
/*     */   public CaseInsensitiveMap(Map map)
/*     */   {
/*  99 */     super(map);
/*     */   }
/*     */ 
/*     */   protected Object convertKey(Object key)
/*     */   {
/* 113 */     if (key != null) {
/* 114 */       return key.toString().toLowerCase();
/*     */     }
/* 116 */     return AbstractHashedMap.NULL;
/*     */   }
/*     */ 
/*     */   public Object clone()
/*     */   {
/* 127 */     return super.clone();
/*     */   }
/*     */ 
/*     */   private void writeObject(ObjectOutputStream out)
/*     */     throws IOException
/*     */   {
/* 134 */     out.defaultWriteObject();
/* 135 */     doWriteObject(out);
/*     */   }
/*     */ 
/*     */   private void readObject(ObjectInputStream in)
/*     */     throws IOException, ClassNotFoundException
/*     */   {
/* 142 */     in.defaultReadObject();
/* 143 */     doReadObject(in);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.apache.commons.collections.map.CaseInsensitiveMap
 * JD-Core Version:    0.6.0
 */