/*     */ package org.apache.commons.collections.iterators;
/*     */ 
/*     */ import java.lang.reflect.Array;
/*     */ import java.util.ListIterator;
/*     */ import java.util.NoSuchElementException;
/*     */ import org.apache.commons.collections.ResettableListIterator;
/*     */ 
/*     */ public class ArrayListIterator extends ArrayIterator
/*     */   implements ListIterator, ResettableListIterator
/*     */ {
/*  56 */   protected int lastItemIndex = -1;
/*     */ 
/*     */   public ArrayListIterator()
/*     */   {
/*     */   }
/*     */ 
/*     */   public ArrayListIterator(Object array)
/*     */   {
/*  79 */     super(array);
/*     */   }
/*     */ 
/*     */   public ArrayListIterator(Object array, int startIndex)
/*     */   {
/*  93 */     super(array, startIndex);
/*  94 */     this.startIndex = startIndex;
/*     */   }
/*     */ 
/*     */   public ArrayListIterator(Object array, int startIndex, int endIndex)
/*     */   {
/* 110 */     super(array, startIndex, endIndex);
/* 111 */     this.startIndex = startIndex;
/*     */   }
/*     */ 
/*     */   public boolean hasPrevious()
/*     */   {
/* 122 */     return this.index > this.startIndex;
/*     */   }
/*     */ 
/*     */   public Object previous()
/*     */   {
/* 132 */     if (!hasPrevious()) {
/* 133 */       throw new NoSuchElementException();
/*     */     }
/* 135 */     this.lastItemIndex = (--this.index);
/* 136 */     return Array.get(this.array, this.index);
/*     */   }
/*     */ 
/*     */   public Object next()
/*     */   {
/* 146 */     if (!hasNext()) {
/* 147 */       throw new NoSuchElementException();
/*     */     }
/* 149 */     this.lastItemIndex = this.index;
/* 150 */     return Array.get(this.array, this.index++);
/*     */   }
/*     */ 
/*     */   public int nextIndex()
/*     */   {
/* 159 */     return this.index - this.startIndex;
/*     */   }
/*     */ 
/*     */   public int previousIndex()
/*     */   {
/* 168 */     return this.index - this.startIndex - 1;
/*     */   }
/*     */ 
/*     */   public void add(Object o)
/*     */   {
/* 179 */     throw new UnsupportedOperationException("add() method is not supported");
/*     */   }
/*     */ 
/*     */   public void set(Object o)
/*     */   {
/* 198 */     if (this.lastItemIndex == -1) {
/* 199 */       throw new IllegalStateException("must call next() or previous() before a call to set()");
/*     */     }
/*     */ 
/* 202 */     Array.set(this.array, this.lastItemIndex, o);
/*     */   }
/*     */ 
/*     */   public void reset()
/*     */   {
/* 209 */     super.reset();
/* 210 */     this.lastItemIndex = -1;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.apache.commons.collections.iterators.ArrayListIterator
 * JD-Core Version:    0.6.0
 */