/*     */ package org.apache.commons.collections.functors;
/*     */ 
/*     */ import java.io.Serializable;
/*     */ import java.util.Collection;
/*     */ import org.apache.commons.collections.Predicate;
/*     */ 
/*     */ public final class OnePredicate
/*     */   implements Predicate, PredicateDecorator, Serializable
/*     */ {
/*     */   static final long serialVersionUID = -8125389089924745785L;
/*     */   private final Predicate[] iPredicates;
/*     */ 
/*     */   public static Predicate getInstance(Predicate[] predicates)
/*     */   {
/*  49 */     FunctorUtils.validateMin2(predicates);
/*  50 */     predicates = FunctorUtils.copy(predicates);
/*  51 */     return new OnePredicate(predicates);
/*     */   }
/*     */ 
/*     */   public static Predicate getInstance(Collection predicates)
/*     */   {
/*  64 */     Predicate[] preds = FunctorUtils.validate(predicates);
/*  65 */     return new OnePredicate(preds);
/*     */   }
/*     */ 
/*     */   public OnePredicate(Predicate[] predicates)
/*     */   {
/*  76 */     this.iPredicates = predicates;
/*     */   }
/*     */ 
/*     */   public boolean evaluate(Object object)
/*     */   {
/*  87 */     boolean match = false;
/*  88 */     for (int i = 0; i < this.iPredicates.length; i++) {
/*  89 */       if (this.iPredicates[i].evaluate(object)) {
/*  90 */         if (match) {
/*  91 */           return false;
/*     */         }
/*  93 */         match = true;
/*     */       }
/*     */     }
/*  96 */     return match;
/*     */   }
/*     */ 
/*     */   public Predicate[] getPredicates()
/*     */   {
/* 106 */     return this.iPredicates;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.apache.commons.collections.functors.OnePredicate
 * JD-Core Version:    0.6.0
 */