/*    */ package org.apache.commons.collections.functors;
/*    */ 
/*    */ import java.io.Serializable;
/*    */ import org.apache.commons.collections.Predicate;
/*    */ 
/*    */ public final class NotPredicate
/*    */   implements Predicate, PredicateDecorator, Serializable
/*    */ {
/*    */   static final long serialVersionUID = -2654603322338049674L;
/*    */   private final Predicate iPredicate;
/*    */ 
/*    */   public static Predicate getInstance(Predicate predicate)
/*    */   {
/* 46 */     if (predicate == null) {
/* 47 */       throw new IllegalArgumentException("Predicate must not be null");
/*    */     }
/* 49 */     return new NotPredicate(predicate);
/*    */   }
/*    */ 
/*    */   public NotPredicate(Predicate predicate)
/*    */   {
/* 60 */     this.iPredicate = predicate;
/*    */   }
/*    */ 
/*    */   public boolean evaluate(Object object)
/*    */   {
/* 70 */     return !this.iPredicate.evaluate(object);
/*    */   }
/*    */ 
/*    */   public Predicate[] getPredicates()
/*    */   {
/* 80 */     return new Serializable[] { this.iPredicate };
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.apache.commons.collections.functors.NotPredicate
 * JD-Core Version:    0.6.0
 */