/*    */ package org.apache.commons.collections.functors;
/*    */ 
/*    */ import java.io.Serializable;
/*    */ import org.apache.commons.collections.Factory;
/*    */ import org.apache.commons.collections.Transformer;
/*    */ 
/*    */ public class FactoryTransformer
/*    */   implements Transformer, Serializable
/*    */ {
/*    */   static final long serialVersionUID = -6817674502475353160L;
/*    */   private final Factory iFactory;
/*    */ 
/*    */   public static Transformer getInstance(Factory factory)
/*    */   {
/* 47 */     if (factory == null) {
/* 48 */       throw new IllegalArgumentException("Factory must not be null");
/*    */     }
/* 50 */     return new FactoryTransformer(factory);
/*    */   }
/*    */ 
/*    */   public FactoryTransformer(Factory factory)
/*    */   {
/* 61 */     this.iFactory = factory;
/*    */   }
/*    */ 
/*    */   public Object transform(Object input)
/*    */   {
/* 72 */     return this.iFactory.create();
/*    */   }
/*    */ 
/*    */   public Factory getFactory()
/*    */   {
/* 82 */     return this.iFactory;
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.apache.commons.collections.functors.FactoryTransformer
 * JD-Core Version:    0.6.0
 */