/*    */ package org.apache.commons.collections.functors;
/*    */ 
/*    */ import java.io.Serializable;
/*    */ import org.apache.commons.collections.Transformer;
/*    */ 
/*    */ public class ConstantTransformer
/*    */   implements Transformer, Serializable
/*    */ {
/*    */   static final long serialVersionUID = 6374440726369055124L;
/* 40 */   public static final Transformer NULL_INSTANCE = new ConstantTransformer(null);
/*    */   private final Object iConstant;
/*    */ 
/*    */   public static Transformer getInstance(Object constantToReturn)
/*    */   {
/* 52 */     if (constantToReturn == null) {
/* 53 */       return NULL_INSTANCE;
/*    */     }
/* 55 */     return new ConstantTransformer(constantToReturn);
/*    */   }
/*    */ 
/*    */   public ConstantTransformer(Object constantToReturn)
/*    */   {
/* 66 */     this.iConstant = constantToReturn;
/*    */   }
/*    */ 
/*    */   public Object transform(Object input)
/*    */   {
/* 76 */     return this.iConstant;
/*    */   }
/*    */ 
/*    */   public Object getConstant()
/*    */   {
/* 86 */     return this.iConstant;
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.apache.commons.collections.functors.ConstantTransformer
 * JD-Core Version:    0.6.0
 */