/*    */ package org.apache.commons.collections.functors;
/*    */ 
/*    */ import java.io.Serializable;
/*    */ import org.apache.commons.collections.Closure;
/*    */ import org.apache.commons.collections.Transformer;
/*    */ 
/*    */ public class ClosureTransformer
/*    */   implements Transformer, Serializable
/*    */ {
/*    */   static final long serialVersionUID = 478466901448617286L;
/*    */   private final Closure iClosure;
/*    */ 
/*    */   public static Transformer getInstance(Closure closure)
/*    */   {
/* 48 */     if (closure == null) {
/* 49 */       throw new IllegalArgumentException("Closure must not be null");
/*    */     }
/* 51 */     return new ClosureTransformer(closure);
/*    */   }
/*    */ 
/*    */   public ClosureTransformer(Closure closure)
/*    */   {
/* 62 */     this.iClosure = closure;
/*    */   }
/*    */ 
/*    */   public Object transform(Object input)
/*    */   {
/* 72 */     this.iClosure.execute(input);
/* 73 */     return input;
/*    */   }
/*    */ 
/*    */   public Closure getClosure()
/*    */   {
/* 83 */     return this.iClosure;
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.apache.commons.collections.functors.ClosureTransformer
 * JD-Core Version:    0.6.0
 */