/*     */ package org.apache.commons.collections.comparators;
/*     */ 
/*     */ import java.io.Serializable;
/*     */ import java.util.Comparator;
/*     */ 
/*     */ public final class BooleanComparator
/*     */   implements Comparator, Serializable
/*     */ {
/*     */   private static final long serialVersionUID = 1830042991606340609L;
/*  40 */   private static final BooleanComparator TRUE_FIRST = new BooleanComparator(true);
/*     */ 
/*  43 */   private static final BooleanComparator FALSE_FIRST = new BooleanComparator(false);
/*     */ 
/*  46 */   private boolean trueFirst = false;
/*     */ 
/*     */   public static BooleanComparator getTrueFirstComparator()
/*     */   {
/*  62 */     return TRUE_FIRST;
/*     */   }
/*     */ 
/*     */   public static BooleanComparator getFalseFirstComparator()
/*     */   {
/*  78 */     return FALSE_FIRST;
/*     */   }
/*     */ 
/*     */   public static BooleanComparator getBooleanComparator(boolean trueFirst)
/*     */   {
/*  97 */     return trueFirst ? TRUE_FIRST : FALSE_FIRST;
/*     */   }
/*     */ 
/*     */   public BooleanComparator()
/*     */   {
/* 110 */     this(false);
/*     */   }
/*     */ 
/*     */   public BooleanComparator(boolean trueFirst)
/*     */   {
/* 124 */     this.trueFirst = trueFirst;
/*     */   }
/*     */ 
/*     */   public int compare(Object obj1, Object obj2)
/*     */   {
/* 141 */     return compare((Boolean)obj1, (Boolean)obj2);
/*     */   }
/*     */ 
/*     */   public int compare(Boolean b1, Boolean b2)
/*     */   {
/* 154 */     boolean v1 = b1.booleanValue();
/* 155 */     boolean v2 = b2.booleanValue();
/*     */ 
/* 157 */     return (v1 ^ v2) ? -1 : (v1 ^ this.trueFirst) ? 1 : 0;
/*     */   }
/*     */ 
/*     */   public int hashCode()
/*     */   {
/* 168 */     int hash = "BooleanComparator".hashCode();
/* 169 */     return this.trueFirst ? -1 * hash : hash;
/*     */   }
/*     */ 
/*     */   public boolean equals(Object object)
/*     */   {
/* 185 */     return (this == object) || (((object instanceof BooleanComparator)) && (this.trueFirst == ((BooleanComparator)object).trueFirst));
/*     */   }
/*     */ 
/*     */   public boolean sortsTrueFirst()
/*     */   {
/* 202 */     return this.trueFirst;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.apache.commons.collections.comparators.BooleanComparator
 * JD-Core Version:    0.6.0
 */