/*     */ package org.apache.commons.collections.buffer;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.ObjectInputStream;
/*     */ import java.io.ObjectOutputStream;
/*     */ import java.io.Serializable;
/*     */ import java.util.Collection;
/*     */ import java.util.Iterator;
/*     */ import org.apache.commons.collections.Buffer;
/*     */ import org.apache.commons.collections.Unmodifiable;
/*     */ import org.apache.commons.collections.iterators.UnmodifiableIterator;
/*     */ 
/*     */ public final class UnmodifiableBuffer extends AbstractBufferDecorator
/*     */   implements Unmodifiable, Serializable
/*     */ {
/*     */   private static final long serialVersionUID = 1832948656215393357L;
/*     */ 
/*     */   public static Buffer decorate(Buffer buffer)
/*     */   {
/*  56 */     if ((buffer instanceof Serializable)) {
/*  57 */       return buffer;
/*     */     }
/*  59 */     return new UnmodifiableBuffer(buffer);
/*     */   }
/*     */ 
/*     */   private UnmodifiableBuffer(Buffer buffer)
/*     */   {
/*  70 */     super(buffer);
/*     */   }
/*     */ 
/*     */   private void writeObject(ObjectOutputStream out)
/*     */     throws IOException
/*     */   {
/*  81 */     out.defaultWriteObject();
/*  82 */     out.writeObject(this.collection);
/*     */   }
/*     */ 
/*     */   private void readObject(ObjectInputStream in)
/*     */     throws IOException, ClassNotFoundException
/*     */   {
/*  93 */     in.defaultReadObject();
/*  94 */     this.collection = ((Collection)in.readObject());
/*     */   }
/*     */ 
/*     */   public Iterator iterator()
/*     */   {
/*  99 */     return UnmodifiableIterator.decorate(getCollection().iterator());
/*     */   }
/*     */ 
/*     */   public boolean add(Object object) {
/* 103 */     throw new UnsupportedOperationException();
/*     */   }
/*     */ 
/*     */   public boolean addAll(Collection coll) {
/* 107 */     throw new UnsupportedOperationException();
/*     */   }
/*     */ 
/*     */   public void clear() {
/* 111 */     throw new UnsupportedOperationException();
/*     */   }
/*     */ 
/*     */   public boolean remove(Object object) {
/* 115 */     throw new UnsupportedOperationException();
/*     */   }
/*     */ 
/*     */   public boolean removeAll(Collection coll) {
/* 119 */     throw new UnsupportedOperationException();
/*     */   }
/*     */ 
/*     */   public boolean retainAll(Collection coll) {
/* 123 */     throw new UnsupportedOperationException();
/*     */   }
/*     */ 
/*     */   public Object remove()
/*     */   {
/* 128 */     throw new UnsupportedOperationException();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.apache.commons.collections.buffer.UnmodifiableBuffer
 * JD-Core Version:    0.6.0
 */