/*    */ package net.sf.cglib.transform.hook;
/*    */ 
/*    */ import java.util.Hashtable;
/*    */ import net.sf.cglib.asm.ClassReader;
/*    */ import net.sf.cglib.asm.ClassWriter;
/*    */ import net.sf.cglib.core.ClassGenerator;
/*    */ import net.sf.cglib.core.CodeGenerationException;
/*    */ import net.sf.cglib.core.DebuggingClassWriter;
/*    */ import net.sf.cglib.transform.ClassReaderGenerator;
/*    */ import net.sf.cglib.transform.ClassTransformer;
/*    */ import net.sf.cglib.transform.TransformingClassGenerator;
/*    */ import org.codehaus.aspectwerkz.hook.ClassPreProcessor;
/*    */ 
/*    */ public abstract class AbstractPreProcessor
/*    */   implements ClassPreProcessor
/*    */ {
/*    */   public void initialize(Hashtable hashtable)
/*    */   {
/*    */   }
/*    */ 
/*    */   public byte[] preProcess(String name, byte[] abyte, ClassLoader caller)
/*    */   {
/*    */     try
/*    */     {
/* 31 */       ClassTransformer t = getClassTransformer(name);
/* 32 */       if (t == null)
/* 33 */         return abyte;
/* 34 */       ClassWriter w = new DebuggingClassWriter(true);
/* 35 */       ClassGenerator gen = new ClassReaderGenerator(new ClassReader(abyte), false);
/* 36 */       gen = new TransformingClassGenerator(gen, t);
/* 37 */       gen.generateClass(w);
/* 38 */       return w.toByteArray(); } catch (Exception e) {
/*    */     }
/* 40 */     throw new CodeGenerationException(e);
/*    */   }
/*    */ 
/*    */   protected abstract ClassTransformer getClassTransformer(String paramString);
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     net.sf.cglib.transform.hook.AbstractPreProcessor
 * JD-Core Version:    0.6.0
 */