package javax.xml.xpath;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Properties;

final class XPathFactoryFinder
{
  private static boolean debug = false;
  private static final int DEFAULT_LINE_LENGTH = 80;
  private static Properties cacheProps;
  private static boolean firstTime;
  private final ClassLoader classLoader;
  private static final Class SERVICE_CLASS;
  private static final String SERVICE_ID;

  private static void debugPrintln(String paramString)
  {
    if (debug)
      System.err.println("JAXP: " + paramString);
  }

  public XPathFactoryFinder(ClassLoader paramClassLoader)
  {
    this.classLoader = paramClassLoader;
    if (debug)
      debugDisplayClassLoader();
  }

  private void debugDisplayClassLoader()
  {
    try
    {
      if (this.classLoader == SecuritySupport.getContextClassLoader())
      {
        debugPrintln("using thread context class loader (" + this.classLoader + ") for search");
        return;
      }
    }
    catch (Throwable localThrowable)
    {
    }
    if (this.classLoader == ClassLoader.getSystemClassLoader())
    {
      debugPrintln("using system class loader (" + this.classLoader + ") for search");
      return;
    }
    debugPrintln("using class loader (" + this.classLoader + ") for search");
  }

  public XPathFactory newFactory(String paramString)
  {
    if (paramString == null)
      throw new NullPointerException();
    XPathFactory localXPathFactory = _newFactory(paramString);
    if (debug)
      if (localXPathFactory != null)
        debugPrintln("factory '" + localXPathFactory.getClass().getName() + "' was found for " + paramString);
      else
        debugPrintln("unable to find a factory for " + paramString);
    return localXPathFactory;
  }

  private XPathFactory _newFactory(String paramString)
  {
    String str1 = SERVICE_CLASS.getName() + ":" + paramString;
    XPathFactory localXPathFactory;
    try
    {
      if (debug)
        debugPrintln("Looking up system property '" + str1 + "'");
      String str2 = SecuritySupport.getSystemProperty(str1);
      if (str2 != null)
      {
        if (debug)
          debugPrintln("The value is '" + str2 + "'");
        localXPathFactory = createInstance(str2);
        if (localXPathFactory != null)
          return localXPathFactory;
      }
      else if (debug)
      {
        debugPrintln("The property is undefined.");
      }
    }
    catch (Throwable localThrowable)
    {
      if (debug)
      {
        debugPrintln("failed to look up system property '" + str1 + "'");
        localThrowable.printStackTrace();
      }
    }
    String str3 = SecuritySupport.getSystemProperty("java.home");
    String str4 = str3 + File.separator + "lib" + File.separator + "jaxp.properties";
    String str5 = null;
    Object localObject1;
    try
    {
      if (firstTime)
        synchronized (cacheProps)
        {
          if (firstTime)
          {
            localObject1 = new File(str4);
            firstTime = false;
            if (SecuritySupport.doesFileExist((File)localObject1))
            {
              if (debug)
                debugPrintln("Read properties file " + localObject1);
              cacheProps.load(SecuritySupport.getFileInputStream((File)localObject1));
            }
          }
        }
      str5 = cacheProps.getProperty(str1);
      if (debug)
        debugPrintln("found " + str5 + " in $java.home/jaxp.properties");
      if (str5 != null)
      {
        localXPathFactory = createInstance(str5);
        if (localXPathFactory != null)
          return localXPathFactory;
      }
    }
    catch (Exception localException)
    {
      if (debug)
        localException.printStackTrace();
    }
    Iterator localIterator = createServiceFileIterator();
    while (localIterator.hasNext())
    {
      localObject1 = (URL)localIterator.next();
      if (debug)
        debugPrintln("looking into " + localObject1);
      try
      {
        localXPathFactory = loadFromServicesFile(paramString, ((URL)localObject1).toExternalForm(), SecuritySupport.getURLInputStream((URL)localObject1));
        if (localXPathFactory != null)
          return localXPathFactory;
      }
      catch (IOException localIOException)
      {
        if (!debug)
          continue;
        debugPrintln("failed to read " + localObject1);
        localIOException.printStackTrace();
      }
    }
    if (paramString.equals("http://java.sun.com/jaxp/xpath/dom"))
    {
      if (debug)
        debugPrintln("attempting to use the platform default W3C DOM XPath lib");
      return createInstance("org.apache.xpath.jaxp.XPathFactoryImpl");
    }
    if (debug)
      debugPrintln("all things were tried, but none was found. bailing out.");
    return (XPathFactory)null;
  }

  private XPathFactory createInstance(String paramString)
  {
    try
    {
      if (debug)
        debugPrintln("instanciating " + paramString);
      Class localClass;
      if (this.classLoader != null)
        localClass = this.classLoader.loadClass(paramString);
      else
        localClass = Class.forName(paramString);
      if (debug)
        debugPrintln("loaded it from " + which(localClass));
      Object localObject = localClass.newInstance();
      if ((localObject instanceof XPathFactory))
        return (XPathFactory)localObject;
      if (debug)
        debugPrintln(paramString + " is not assignable to " + SERVICE_CLASS.getName());
    }
    catch (Throwable localThrowable)
    {
      if (debug)
      {
        debugPrintln("failed to instanciate " + paramString);
        localThrowable.printStackTrace();
      }
    }
    return null;
  }

  private XPathFactory loadFromServicesFile(String paramString1, String paramString2, InputStream paramInputStream)
  {
    if (debug)
      debugPrintln("Reading " + paramString2);
    BufferedReader localBufferedReader;
    try
    {
      localBufferedReader = new BufferedReader(new InputStreamReader(paramInputStream, "UTF-8"), 80);
    }
    catch (UnsupportedEncodingException localUnsupportedEncodingException)
    {
      localBufferedReader = new BufferedReader(new InputStreamReader(paramInputStream), 80);
    }
    String str = null;
    Object localObject = null;
    while (true)
    {
      try
      {
        str = localBufferedReader.readLine();
      }
      catch (IOException localIOException1)
      {
        break;
      }
      if (str == null)
        break;
      int i = str.indexOf('#');
      if (i != -1)
        str = str.substring(0, i);
      str = str.trim();
      if (str.length() == 0)
        continue;
      try
      {
        XPathFactory localXPathFactory = createInstance(str);
        if (localXPathFactory.isObjectModelSupported(paramString1))
        {
          localObject = localXPathFactory;
          break;
        }
      }
      catch (Exception localException)
      {
      }
    }
    try
    {
      localBufferedReader.close();
    }
    catch (IOException localIOException2)
    {
    }
    return localObject;
  }

  private Iterator createServiceFileIterator()
  {
    if (this.classLoader == null)
      return new SingleIterator()
      {
        protected Object value()
        {
          ClassLoader localClassLoader = XPathFactoryFinder.class.getClassLoader();
          return SecuritySupport.getResourceAsURL(localClassLoader, XPathFactoryFinder.SERVICE_ID);
        }
      };
    try
    {
      Enumeration localEnumeration = SecuritySupport.getResources(this.classLoader, SERVICE_ID);
      if ((debug) && (!localEnumeration.hasMoreElements()))
        debugPrintln("no " + SERVICE_ID + " file was found");
      return new Iterator(localEnumeration)
      {
        private final Enumeration val$e;

        public void remove()
        {
          throw new UnsupportedOperationException();
        }

        public boolean hasNext()
        {
          return this.val$e.hasMoreElements();
        }

        public Object next()
        {
          return this.val$e.nextElement();
        }
      };
    }
    catch (IOException localIOException)
    {
      if (debug)
      {
        debugPrintln("failed to enumerate resources " + SERVICE_ID);
        localIOException.printStackTrace();
      }
    }
    return new ArrayList().iterator();
  }

  private static String which(Class paramClass)
  {
    return which(paramClass.getName(), paramClass.getClassLoader());
  }

  private static String which(String paramString, ClassLoader paramClassLoader)
  {
    String str = paramString.replace('.', '/') + ".class";
    if (paramClassLoader == null)
      paramClassLoader = ClassLoader.getSystemClassLoader();
    URL localURL = SecuritySupport.getResourceAsURL(paramClassLoader, str);
    if (localURL != null)
      return localURL.toString();
    return null;
  }

  static
  {
    try
    {
      String str = SecuritySupport.getSystemProperty("jaxp.debug");
      debug = (str != null) && (!"false".equals(str));
    }
    catch (Exception localException)
    {
      debug = false;
    }
    cacheProps = new Properties();
    firstTime = true;
    SERVICE_CLASS = XPathFactory.class;
    SERVICE_ID = "META-INF/services/" + SERVICE_CLASS.getName();
  }

  private static abstract class SingleIterator
    implements Iterator
  {
    private boolean seen = false;

    private SingleIterator()
    {
    }

    public final void remove()
    {
      throw new UnsupportedOperationException();
    }

    public final boolean hasNext()
    {
      return !this.seen;
    }

    public final Object next()
    {
      if (this.seen)
        throw new NoSuchElementException();
      this.seen = true;
      return value();
    }

    protected abstract Object value();

    SingleIterator(XPathFactoryFinder.1 param1)
    {
      this();
    }
  }
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     javax.xml.xpath.XPathFactoryFinder
 * JD-Core Version:    0.6.0
 */