package javax.xml.parsers;

import javax.xml.validation.Schema;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;

public abstract class SAXParserFactory
{
  private boolean validating = false;
  private boolean namespaceAware = false;

  public static SAXParserFactory newInstance()
  {
    try
    {
      return (SAXParserFactory)FactoryFinder.find("javax.xml.parsers.SAXParserFactory", "org.apache.xerces.jaxp.SAXParserFactoryImpl");
    }
    catch (FactoryFinder.ConfigurationError localConfigurationError)
    {
    }
    throw new FactoryConfigurationError(localConfigurationError.getException(), localConfigurationError.getMessage());
  }

  public abstract SAXParser newSAXParser()
    throws ParserConfigurationException, SAXException;

  public void setNamespaceAware(boolean paramBoolean)
  {
    this.namespaceAware = paramBoolean;
  }

  public void setValidating(boolean paramBoolean)
  {
    this.validating = paramBoolean;
  }

  public boolean isNamespaceAware()
  {
    return this.namespaceAware;
  }

  public boolean isValidating()
  {
    return this.validating;
  }

  public abstract void setFeature(String paramString, boolean paramBoolean)
    throws ParserConfigurationException, SAXNotRecognizedException, SAXNotSupportedException;

  public abstract boolean getFeature(String paramString)
    throws ParserConfigurationException, SAXNotRecognizedException, SAXNotSupportedException;

  public Schema getSchema()
  {
    throw new UnsupportedOperationException("This parser does not support specification \"" + getClass().getPackage().getSpecificationTitle() + "\" version \"" + getClass().getPackage().getSpecificationVersion() + "\"");
  }

  public void setSchema(Schema paramSchema)
  {
    throw new UnsupportedOperationException("This parser does not support specification \"" + getClass().getPackage().getSpecificationTitle() + "\" version \"" + getClass().getPackage().getSpecificationVersion() + "\"");
  }

  public void setXIncludeAware(boolean paramBoolean)
  {
    throw new UnsupportedOperationException("This parser does not support specification \"" + getClass().getPackage().getSpecificationTitle() + "\" version \"" + getClass().getPackage().getSpecificationVersion() + "\"");
  }

  public boolean isXIncludeAware()
  {
    throw new UnsupportedOperationException("This parser does not support specification \"" + getClass().getPackage().getSpecificationTitle() + "\" version \"" + getClass().getPackage().getSpecificationVersion() + "\"");
  }
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     javax.xml.parsers.SAXParserFactory
 * JD-Core Version:    0.6.0
 */