/*     */ package javax.xml.bind.helpers;
/*     */ 
/*     */ import java.io.PrintStream;
/*     */ import java.net.URL;
/*     */ import javax.xml.bind.ValidationEvent;
/*     */ import javax.xml.bind.ValidationEventHandler;
/*     */ import javax.xml.bind.ValidationEventLocator;
/*     */ import org.w3c.dom.Node;
/*     */ 
/*     */ public class DefaultValidationEventHandler
/*     */   implements ValidationEventHandler
/*     */ {
/*     */   public boolean handleEvent(ValidationEvent event)
/*     */   {
/*  41 */     if (event == null) {
/*  42 */       throw new IllegalArgumentException();
/*     */     }
/*     */ 
/*  46 */     String severity = null;
/*  47 */     boolean retVal = false;
/*  48 */     switch (event.getSeverity()) {
/*     */     case 0:
/*  50 */       severity = Messages.format("DefaultValidationEventHandler.Warning");
/*  51 */       retVal = true;
/*  52 */       break;
/*     */     case 1:
/*  54 */       severity = Messages.format("DefaultValidationEventHandler.Error");
/*  55 */       retVal = false;
/*  56 */       break;
/*     */     case 2:
/*  58 */       severity = Messages.format("DefaultValidationEventHandler.FatalError");
/*  59 */       retVal = false;
/*  60 */       break;
/*     */     default:
/*  63 */       if ($assertionsDisabled) break; throw new AssertionError(Messages.format("DefaultValidationEventHandler.UnrecognizedSeverity", Integer.valueOf(event.getSeverity())));
/*     */     }
/*     */ 
/*  68 */     String location = getLocation(event);
/*     */ 
/*  70 */     System.out.println(Messages.format("DefaultValidationEventHandler.SeverityMessage", severity, event.getMessage(), location));
/*     */ 
/*  77 */     return retVal;
/*     */   }
/*     */ 
/*     */   private String getLocation(ValidationEvent event)
/*     */   {
/*  85 */     StringBuffer msg = new StringBuffer();
/*     */ 
/*  87 */     ValidationEventLocator locator = event.getLocator();
/*     */ 
/*  89 */     if (locator != null)
/*     */     {
/*  91 */       URL url = locator.getURL();
/*  92 */       Object obj = locator.getObject();
/*  93 */       Node node = locator.getNode();
/*  94 */       int line = locator.getLineNumber();
/*     */ 
/*  96 */       if ((url != null) || (line != -1)) {
/*  97 */         msg.append("line " + line);
/*  98 */         if (url != null)
/*  99 */           msg.append(" of " + url);
/* 100 */       } else if (obj != null) {
/* 101 */         msg.append(" obj: " + obj.toString());
/* 102 */       } else if (node != null) {
/* 103 */         msg.append(" node: " + node.toString());
/*     */       }
/*     */     } else {
/* 106 */       msg.append(Messages.format("DefaultValidationEventHandler.LocationUnavailable"));
/*     */     }
/*     */ 
/* 109 */     return msg.toString();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     javax.xml.bind.helpers.DefaultValidationEventHandler
 * JD-Core Version:    0.6.0
 */