/*     */ package javax.xml.bind;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.util.Collections;
/*     */ import java.util.Map;
/*     */ import org.w3c.dom.Node;
/*     */ 
/*     */ public abstract class JAXBContext
/*     */ {
/*     */   public static final String JAXB_CONTEXT_FACTORY = "javax.xml.bind.context.factory";
/*     */ 
/*     */   public static JAXBContext newInstance(String contextPath)
/*     */     throws JAXBException
/*     */   {
/* 244 */     return newInstance(contextPath, Thread.currentThread().getContextClassLoader());
/*     */   }
/*     */ 
/*     */   public static JAXBContext newInstance(String contextPath, ClassLoader classLoader)
/*     */     throws JAXBException
/*     */   {
/* 337 */     return newInstance(contextPath, classLoader, Collections.emptyMap());
/*     */   }
/*     */ 
/*     */   public static JAXBContext newInstance(String contextPath, ClassLoader classLoader, Map<String, ?> properties)
/*     */     throws JAXBException
/*     */   {
/* 372 */     return ContextFinder.find("javax.xml.bind.context.factory", contextPath, classLoader, properties);
/*     */   }
/*     */ 
/*     */   public static JAXBContext newInstance(Class[] classesToBeBound)
/*     */     throws JAXBException
/*     */   {
/* 522 */     return newInstance(classesToBeBound, Collections.emptyMap());
/*     */   }
/*     */ 
/*     */   public static JAXBContext newInstance(Class[] classesToBeBound, Map<String, ?> properties)
/*     */     throws JAXBException
/*     */   {
/* 570 */     for (int i = classesToBeBound.length - 1; i >= 0; i--) {
/* 571 */       if (classesToBeBound[i] == null)
/* 572 */         throw new IllegalArgumentException();
/*     */     }
/* 574 */     return ContextFinder.find(classesToBeBound, properties);
/*     */   }
/*     */ 
/*     */   public abstract Unmarshaller createUnmarshaller()
/*     */     throws JAXBException;
/*     */ 
/*     */   public abstract Marshaller createMarshaller()
/*     */     throws JAXBException;
/*     */ 
/*     */   /** @deprecated */
/*     */   public abstract Validator createValidator()
/*     */     throws JAXBException;
/*     */ 
/*     */   public <T> Binder<T> createBinder(Class<T> domType)
/*     */   {
/* 633 */     throw new UnsupportedOperationException();
/*     */   }
/*     */ 
/*     */   public Binder<Node> createBinder()
/*     */   {
/* 644 */     return createBinder(Node.class);
/*     */   }
/*     */ 
/*     */   public JAXBIntrospector createJAXBIntrospector()
/*     */   {
/* 663 */     throw new UnsupportedOperationException();
/*     */   }
/*     */ 
/*     */   public void generateSchema(SchemaOutputResolver outputResolver)
/*     */     throws IOException
/*     */   {
/* 685 */     throw new UnsupportedOperationException();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     javax.xml.bind.JAXBContext
 * JD-Core Version:    0.6.0
 */