/*      */ package javassist.bytecode;
/*      */ 
/*      */ import java.io.DataInputStream;
/*      */ import java.io.DataOutputStream;
/*      */ import java.io.IOException;
/*      */ import java.io.PrintWriter;
/*      */ import java.util.Map;
/*      */ 
/*      */ class Utf8Info extends ConstInfo
/*      */ {
/*      */   static final int tag = 1;
/*      */   String string;
/*      */   int index;
/*      */ 
/*      */   public Utf8Info(String utf8, int i)
/*      */   {
/* 1478 */     this.string = utf8;
/* 1479 */     this.index = i;
/*      */   }
/*      */ 
/*      */   public Utf8Info(DataInputStream in, int i) throws IOException {
/* 1483 */     this.string = in.readUTF();
/* 1484 */     this.index = i;
/*      */   }
/*      */   public int getTag() {
/* 1487 */     return 1;
/*      */   }
/*      */   public int copy(ConstPool src, ConstPool dest, Map map) {
/* 1490 */     return dest.addUtf8Info(this.string);
/*      */   }
/*      */ 
/*      */   public void write(DataOutputStream out) throws IOException {
/* 1494 */     out.writeByte(1);
/* 1495 */     out.writeUTF(this.string);
/*      */   }
/*      */ 
/*      */   public void print(PrintWriter out) {
/* 1499 */     out.print("UTF8 \"");
/* 1500 */     out.print(this.string);
/* 1501 */     out.println("\"");
/*      */   }
/*      */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     javassist.bytecode.Utf8Info
 * JD-Core Version:    0.6.0
 */