/*      */ package javassist.bytecode;
/*      */ 
/*      */ import java.io.DataInputStream;
/*      */ import java.io.DataOutputStream;
/*      */ import java.io.IOException;
/*      */ import java.io.PrintWriter;
/*      */ import java.util.Map;
/*      */ 
/*      */ class LongInfo extends ConstInfo
/*      */ {
/*      */   static final int tag = 5;
/*      */   long value;
/*      */ 
/*      */   public LongInfo(long l)
/*      */   {
/* 1419 */     this.value = l;
/*      */   }
/*      */ 
/*      */   public LongInfo(DataInputStream in) throws IOException {
/* 1423 */     this.value = in.readLong();
/*      */   }
/*      */   public int getTag() {
/* 1426 */     return 5;
/*      */   }
/*      */   public int copy(ConstPool src, ConstPool dest, Map map) {
/* 1429 */     return dest.addLongInfo(this.value);
/*      */   }
/*      */ 
/*      */   public void write(DataOutputStream out) throws IOException {
/* 1433 */     out.writeByte(5);
/* 1434 */     out.writeLong(this.value);
/*      */   }
/*      */ 
/*      */   public void print(PrintWriter out) {
/* 1438 */     out.print("Long ");
/* 1439 */     out.println(this.value);
/*      */   }
/*      */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     javassist.bytecode.LongInfo
 * JD-Core Version:    0.6.0
 */