/*      */ package javassist;
/*      */ 
/*      */ import java.io.BufferedInputStream;
/*      */ import java.io.File;
/*      */ import java.io.IOException;
/*      */ import java.io.InputStream;
/*      */ import java.io.OutputStream;
/*      */ import java.lang.reflect.InvocationTargetException;
/*      */ import java.lang.reflect.Method;
/*      */ import java.net.URL;
/*      */ import java.security.AccessController;
/*      */ import java.security.PrivilegedActionException;
/*      */ import java.security.PrivilegedExceptionAction;
/*      */ import java.security.ProtectionDomain;
/*      */ import java.util.ArrayList;
/*      */ import java.util.Enumeration;
/*      */ import java.util.Hashtable;
/*      */ import java.util.Iterator;
/*      */ import javassist.bytecode.Descriptor;
/*      */ 
/*      */ public class ClassPool
/*      */ {
/*      */   private static Method defineClass1;
/*      */   private static Method defineClass2;
/*  105 */   public boolean childFirstLookup = false;
/*      */   public static boolean doPruning;
/*      */   private int compressCount;
/*      */   private static final int COMPRESS_THRESHOLD = 100;
/*      */   public static boolean releaseUnmodifiedClassFile;
/*      */   protected ClassPoolTail source;
/*      */   protected ClassPool parent;
/*      */   protected Hashtable classes;
/*  145 */   private Hashtable cflow = null;
/*      */   private static final int INIT_HASH_SIZE = 191;
/*      */   private ArrayList importedPackages;
/*      */   private static ClassPool defaultPool;
/*      */ 
/*      */   public ClassPool()
/*      */   {
/*  155 */     this(null);
/*      */   }
/*      */ 
/*      */   public ClassPool(boolean useDefaultPath)
/*      */   {
/*  168 */     this(null);
/*  169 */     if (useDefaultPath)
/*  170 */       appendSystemPath();
/*      */   }
/*      */ 
/*      */   public ClassPool(ClassPool parent)
/*      */   {
/*  181 */     this.classes = new Hashtable(191);
/*  182 */     this.source = new ClassPoolTail();
/*  183 */     this.parent = parent;
/*  184 */     if (parent == null) {
/*  185 */       CtClass[] pt = CtClass.primitiveTypes;
/*  186 */       for (int i = 0; i < pt.length; i++) {
/*  187 */         this.classes.put(pt[i].getName(), pt[i]);
/*      */       }
/*      */     }
/*  190 */     this.cflow = null;
/*  191 */     this.compressCount = 0;
/*  192 */     clearImportedPackages();
/*      */   }
/*      */ 
/*      */   public static synchronized ClassPool getDefault()
/*      */   {
/*  220 */     if (defaultPool == null) {
/*  221 */       defaultPool = new ClassPool(null);
/*  222 */       defaultPool.appendSystemPath();
/*      */     }
/*      */ 
/*  225 */     return defaultPool;
/*      */   }
/*      */ 
/*      */   protected CtClass getCached(String classname)
/*      */   {
/*  238 */     return (CtClass)this.classes.get(classname);
/*      */   }
/*      */ 
/*      */   protected void cacheCtClass(String classname, CtClass c, boolean dynamic)
/*      */   {
/*  249 */     this.classes.put(classname, c);
/*      */   }
/*      */ 
/*      */   protected CtClass removeCached(String classname)
/*      */   {
/*  260 */     return (CtClass)this.classes.remove(classname);
/*      */   }
/*      */ 
/*      */   public String toString()
/*      */   {
/*  267 */     return this.source.toString();
/*      */   }
/*      */ 
/*      */   void compress()
/*      */   {
/*  275 */     if (this.compressCount++ > 100) {
/*  276 */       this.compressCount = 0;
/*  277 */       Enumeration e = this.classes.elements();
/*  278 */       while (e.hasMoreElements())
/*  279 */         ((CtClass)e.nextElement()).compress();
/*      */     }
/*      */   }
/*      */ 
/*      */   public void importPackage(String packageName)
/*      */   {
/*  298 */     this.importedPackages.add(packageName);
/*      */   }
/*      */ 
/*      */   public void clearImportedPackages()
/*      */   {
/*  309 */     this.importedPackages = new ArrayList();
/*  310 */     this.importedPackages.add("java.lang");
/*      */   }
/*      */ 
/*      */   public Iterator getImportedPackages()
/*      */   {
/*  320 */     return this.importedPackages.iterator();
/*      */   }
/*      */ 
/*      */   public void recordInvalidClassName(String name)
/*      */   {
/*  334 */     this.source.recordInvalidClassName(name);
/*      */   }
/*      */ 
/*      */   void recordCflow(String name, String cname, String fname)
/*      */   {
/*  346 */     if (this.cflow == null) {
/*  347 */       this.cflow = new Hashtable();
/*      */     }
/*  349 */     this.cflow.put(name, new Object[] { cname, fname });
/*      */   }
/*      */ 
/*      */   public Object[] lookupCflow(String name)
/*      */   {
/*  358 */     if (this.cflow == null) {
/*  359 */       this.cflow = new Hashtable();
/*      */     }
/*  361 */     return (Object[])(Object[])this.cflow.get(name);
/*      */   }
/*      */ 
/*      */   public CtClass getAndRename(String orgName, String newName)
/*      */     throws NotFoundException
/*      */   {
/*  385 */     CtClass clazz = get0(orgName, false);
/*  386 */     if (clazz == null) {
/*  387 */       throw new NotFoundException(orgName);
/*      */     }
/*  389 */     if ((clazz instanceof CtClassType)) {
/*  390 */       ((CtClassType)clazz).setClassPool(this);
/*      */     }
/*  392 */     clazz.setName(newName);
/*      */ 
/*  394 */     return clazz;
/*      */   }
/*      */ 
/*      */   synchronized void classNameChanged(String oldname, CtClass clazz)
/*      */   {
/*  403 */     CtClass c = getCached(oldname);
/*  404 */     if (c == clazz) {
/*  405 */       removeCached(oldname);
/*      */     }
/*  407 */     String newName = clazz.getName();
/*  408 */     checkNotFrozen(newName);
/*  409 */     cacheCtClass(newName, clazz, false);
/*      */   }
/*      */ 
/*      */   public CtClass get(String classname)
/*      */     throws NotFoundException
/*      */   {
/*      */     CtClass clazz;
/*      */     CtClass clazz;
/*  430 */     if (classname == null)
/*  431 */       clazz = null;
/*      */     else {
/*  433 */       clazz = get0(classname, true);
/*      */     }
/*  435 */     if (clazz == null) {
/*  436 */       throw new NotFoundException(classname);
/*      */     }
/*  438 */     clazz.incGetCounter();
/*  439 */     return clazz;
/*      */   }
/*      */ 
/*      */   public CtClass getCtClass(String classname)
/*      */     throws NotFoundException
/*      */   {
/*  464 */     if (classname.charAt(0) == '[') {
/*  465 */       return Descriptor.toCtClass(classname, this);
/*      */     }
/*  467 */     return get(classname);
/*      */   }
/*      */ 
/*      */   protected synchronized CtClass get0(String classname, boolean useCache)
/*      */     throws NotFoundException
/*      */   {
/*  478 */     CtClass clazz = null;
/*  479 */     if (useCache) {
/*  480 */       clazz = getCached(classname);
/*  481 */       if (clazz != null) {
/*  482 */         return clazz;
/*      */       }
/*      */     }
/*  485 */     if ((!this.childFirstLookup) && (this.parent != null)) {
/*  486 */       clazz = this.parent.get0(classname, useCache);
/*  487 */       if (clazz != null) {
/*  488 */         return clazz;
/*      */       }
/*      */     }
/*  491 */     clazz = createCtClass(classname, useCache);
/*  492 */     if (clazz != null)
/*      */     {
/*  494 */       if (useCache) {
/*  495 */         cacheCtClass(clazz.getName(), clazz, false);
/*      */       }
/*  497 */       return clazz;
/*      */     }
/*      */ 
/*  500 */     if ((this.childFirstLookup) && (this.parent != null)) {
/*  501 */       clazz = this.parent.get0(classname, useCache);
/*      */     }
/*  503 */     return clazz;
/*      */   }
/*      */ 
/*      */   protected CtClass createCtClass(String classname, boolean useCache)
/*      */   {
/*  515 */     if (classname.charAt(0) == '[') {
/*  516 */       classname = Descriptor.toClassName(classname);
/*      */     }
/*  518 */     if (classname.endsWith("[]")) {
/*  519 */       String base = classname.substring(0, classname.indexOf('['));
/*  520 */       if (((!useCache) || (getCached(base) == null)) && (find(base) == null)) {
/*  521 */         return null;
/*      */       }
/*  523 */       return new CtArray(classname, this);
/*      */     }
/*      */ 
/*  526 */     if (find(classname) == null) {
/*  527 */       return null;
/*      */     }
/*  529 */     return new CtClassType(classname, this);
/*      */   }
/*      */ 
/*      */   public URL find(String classname)
/*      */   {
/*  542 */     return this.source.find(classname);
/*      */   }
/*      */ 
/*      */   void checkNotFrozen(String classname)
/*      */     throws RuntimeException
/*      */   {
/*  554 */     CtClass clazz = getCached(classname);
/*  555 */     if (clazz == null) {
/*  556 */       if ((!this.childFirstLookup) && (this.parent != null)) {
/*      */         try {
/*  558 */           clazz = this.parent.get0(classname, true);
/*      */         } catch (NotFoundException e) {
/*      */         }
/*  561 */         if (clazz != null) {
/*  562 */           throw new RuntimeException(classname + " is in a parent ClassPool.  Use the parent.");
/*      */         }
/*      */       }
/*      */ 
/*      */     }
/*  567 */     else if (clazz.isFrozen())
/*  568 */       throw new RuntimeException(classname + ": frozen class (cannot edit)");
/*      */   }
/*      */ 
/*      */   CtClass checkNotExists(String classname)
/*      */   {
/*  579 */     CtClass clazz = getCached(classname);
/*  580 */     if ((clazz == null) && 
/*  581 */       (!this.childFirstLookup) && (this.parent != null))
/*      */       try {
/*  583 */         clazz = this.parent.get0(classname, true);
/*      */       }
/*      */       catch (NotFoundException e)
/*      */       {
/*      */       }
/*  588 */     return clazz;
/*      */   }
/*      */ 
/*      */   InputStream openClassfile(String classname)
/*      */     throws NotFoundException
/*      */   {
/*  594 */     return this.source.openClassfile(classname);
/*      */   }
/*      */ 
/*      */   void writeClassfile(String classname, OutputStream out)
/*      */     throws NotFoundException, IOException, CannotCompileException
/*      */   {
/*  600 */     this.source.writeClassfile(classname, out);
/*      */   }
/*      */ 
/*      */   public CtClass[] get(String[] classnames)
/*      */     throws NotFoundException
/*      */   {
/*  615 */     if (classnames == null) {
/*  616 */       return new CtClass[0];
/*      */     }
/*  618 */     int num = classnames.length;
/*  619 */     CtClass[] result = new CtClass[num];
/*  620 */     for (int i = 0; i < num; i++) {
/*  621 */       result[i] = get(classnames[i]);
/*      */     }
/*  623 */     return result;
/*      */   }
/*      */ 
/*      */   public CtMethod getMethod(String classname, String methodname)
/*      */     throws NotFoundException
/*      */   {
/*  636 */     CtClass c = get(classname);
/*  637 */     return c.getDeclaredMethod(methodname);
/*      */   }
/*      */ 
/*      */   public CtClass makeClass(InputStream classfile)
/*      */     throws IOException, RuntimeException
/*      */   {
/*  658 */     return makeClass(classfile, true);
/*      */   }
/*      */ 
/*      */   public CtClass makeClass(InputStream classfile, boolean ifNotFrozen)
/*      */     throws IOException, RuntimeException
/*      */   {
/*  678 */     compress();
/*  679 */     classfile = new BufferedInputStream(classfile);
/*  680 */     CtClass clazz = new CtClassType(classfile, this);
/*  681 */     clazz.checkModify();
/*  682 */     String classname = clazz.getName();
/*  683 */     if (ifNotFrozen) {
/*  684 */       checkNotFrozen(classname);
/*      */     }
/*  686 */     cacheCtClass(classname, clazz, true);
/*  687 */     return clazz;
/*      */   }
/*      */ 
/*      */   public CtClass makeClassIfNew(InputStream classfile)
/*      */     throws IOException, RuntimeException
/*      */   {
/*  708 */     compress();
/*  709 */     classfile = new BufferedInputStream(classfile);
/*  710 */     CtClass clazz = new CtClassType(classfile, this);
/*  711 */     clazz.checkModify();
/*  712 */     String classname = clazz.getName();
/*  713 */     CtClass found = checkNotExists(classname);
/*  714 */     if (found != null) {
/*  715 */       return found;
/*      */     }
/*  717 */     cacheCtClass(classname, clazz, true);
/*  718 */     return clazz;
/*      */   }
/*      */ 
/*      */   public CtClass makeClass(String classname)
/*      */     throws RuntimeException
/*      */   {
/*  739 */     return makeClass(classname, null);
/*      */   }
/*      */ 
/*      */   public synchronized CtClass makeClass(String classname, CtClass superclass)
/*      */     throws RuntimeException
/*      */   {
/*  762 */     checkNotFrozen(classname);
/*  763 */     CtClass clazz = new CtNewClass(classname, this, false, superclass);
/*  764 */     cacheCtClass(classname, clazz, true);
/*  765 */     return clazz;
/*      */   }
/*      */ 
/*      */   synchronized CtClass makeNestedClass(String classname)
/*      */   {
/*  776 */     checkNotFrozen(classname);
/*  777 */     CtClass clazz = new CtNewNestedClass(classname, this, false, null);
/*  778 */     cacheCtClass(classname, clazz, true);
/*  779 */     return clazz;
/*      */   }
/*      */ 
/*      */   public CtClass makeInterface(String name)
/*      */     throws RuntimeException
/*      */   {
/*  791 */     return makeInterface(name, null);
/*      */   }
/*      */ 
/*      */   public synchronized CtClass makeInterface(String name, CtClass superclass)
/*      */     throws RuntimeException
/*      */   {
/*  806 */     checkNotFrozen(name);
/*  807 */     CtClass clazz = new CtNewClass(name, this, true, superclass);
/*  808 */     cacheCtClass(name, clazz, true);
/*  809 */     return clazz;
/*      */   }
/*      */ 
/*      */   public ClassPath appendSystemPath()
/*      */   {
/*  823 */     return this.source.appendSystemPath();
/*      */   }
/*      */ 
/*      */   public ClassPath insertClassPath(ClassPath cp)
/*      */   {
/*  836 */     return this.source.insertClassPath(cp);
/*      */   }
/*      */ 
/*      */   public ClassPath appendClassPath(ClassPath cp)
/*      */   {
/*  849 */     return this.source.appendClassPath(cp);
/*      */   }
/*      */ 
/*      */   public ClassPath insertClassPath(String pathname)
/*      */     throws NotFoundException
/*      */   {
/*  867 */     return this.source.insertClassPath(pathname);
/*      */   }
/*      */ 
/*      */   public ClassPath appendClassPath(String pathname)
/*      */     throws NotFoundException
/*      */   {
/*  885 */     return this.source.appendClassPath(pathname);
/*      */   }
/*      */ 
/*      */   public void removeClassPath(ClassPath cp)
/*      */   {
/*  894 */     this.source.removeClassPath(cp);
/*      */   }
/*      */ 
/*      */   public void appendPathList(String pathlist)
/*      */     throws NotFoundException
/*      */   {
/*  910 */     char sep = File.pathSeparatorChar;
/*  911 */     int i = 0;
/*      */     while (true) {
/*  913 */       int j = pathlist.indexOf(sep, i);
/*  914 */       if (j < 0) {
/*  915 */         appendClassPath(pathlist.substring(i));
/*  916 */         break;
/*      */       }
/*      */ 
/*  919 */       appendClassPath(pathlist.substring(i, j));
/*  920 */       i = j + 1;
/*      */     }
/*      */   }
/*      */ 
/*      */   public Class toClass(CtClass clazz)
/*      */     throws CannotCompileException
/*      */   {
/*  952 */     return toClass(clazz, getClassLoader());
/*      */   }
/*      */ 
/*      */   public ClassLoader getClassLoader()
/*      */   {
/*  966 */     return getContextClassLoader();
/*      */   }
/*      */ 
/*      */   static ClassLoader getContextClassLoader()
/*      */   {
/*  974 */     return Thread.currentThread().getContextClassLoader();
/*      */   }
/*      */ 
/*      */   /** @deprecated */
/*      */   public Class toClass(CtClass ct, ClassLoader loader)
/*      */     throws CannotCompileException
/*      */   {
/*  994 */     return toClass(ct, loader, null);
/*      */   }
/*      */ 
/*      */   public Class toClass(CtClass ct, ClassLoader loader, ProtectionDomain domain)
/*      */     throws CannotCompileException
/*      */   {
/*      */     try
/*      */     {
/* 1031 */       byte[] b = ct.toBytecode();
/*      */       Object[] args;
/*      */       Method method;
/*      */       Object[] args;
/* 1034 */       if (domain == null) {
/* 1035 */         Method method = defineClass1;
/* 1036 */         args = new Object[] { ct.getName(), b, new Integer(0), new Integer(b.length) };
/*      */       }
/*      */       else
/*      */       {
/* 1040 */         method = defineClass2;
/* 1041 */         args = new Object[] { ct.getName(), b, new Integer(0), new Integer(b.length), domain };
/*      */       }
/*      */ 
/* 1045 */       return toClass2(method, loader, args);
/*      */     }
/*      */     catch (RuntimeException e) {
/* 1048 */       throw e;
/*      */     }
/*      */     catch (InvocationTargetException e) {
/* 1051 */       throw new CannotCompileException(e.getTargetException());
/*      */     } catch (Exception e) {
/*      */     }
/* 1054 */     throw new CannotCompileException(e);
/*      */   }
/*      */ 
/*      */   private static synchronized Class toClass2(Method method, ClassLoader loader, Object[] args)
/*      */     throws Exception
/*      */   {
/* 1062 */     method.setAccessible(true);
/* 1063 */     Class clazz = (Class)method.invoke(loader, args);
/* 1064 */     method.setAccessible(false);
/* 1065 */     return clazz;
/*      */   }
/*      */ 
/*      */   static
/*      */   {
/*      */     try
/*      */     {
/*   75 */       AccessController.doPrivileged(new PrivilegedExceptionAction() {
/*      */         public Object run() throws Exception {
/*   77 */           Class cl = Class.forName("java.lang.ClassLoader");
/*   78 */           ClassPool.access$002(cl.getDeclaredMethod("defineClass", new Class[] { String.class, new byte[0].getClass(), Integer.TYPE, Integer.TYPE }));
/*      */ 
/*   82 */           ClassPool.access$102(cl.getDeclaredMethod("defineClass", new Class[] { String.class, new byte[0].getClass(), Integer.TYPE, Integer.TYPE, ProtectionDomain.class }));
/*      */ 
/*   85 */           return null;
/*      */         } } );
/*      */     }
/*      */     catch (PrivilegedActionException pae) {
/*   90 */       throw new RuntimeException("cannot initialize ClassPool", pae.getException());
/*      */     }
/*      */ 
/*  121 */     doPruning = false;
/*      */ 
/*  136 */     releaseUnmodifiedClassFile = true;
/*      */ 
/*  228 */     defaultPool = null;
/*      */   }
/*      */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     javassist.ClassPool
 * JD-Core Version:    0.6.0
 */