/*     */ package gnu.trove.decorator;
/*     */ 
/*     */ import gnu.trove.TLongFloatHashMap;
/*     */ import java.util.AbstractMap;
/*     */ import java.util.AbstractSet;
/*     */ import java.util.Collection;
/*     */ import java.util.Iterator;
/*     */ import java.util.Map;
/*     */ import java.util.Map.Entry;
/*     */ import java.util.Set;
/*     */ 
/*     */ public class TLongFloatHashMapDecorator extends AbstractMap
/*     */   implements Map
/*     */ {
/*     */   protected final TLongFloatHashMap _map;
/*     */ 
/*     */   public TLongFloatHashMapDecorator(TLongFloatHashMap map)
/*     */   {
/*  57 */     this._map = map;
/*     */   }
/*     */ 
/*     */   public Object put(Object key, Object value)
/*     */   {
/*  69 */     return wrapValue(this._map.put(unwrapKey(key), unwrapValue(value)));
/*     */   }
/*     */ 
/*     */   public boolean equals(Object other)
/*     */   {
/*  80 */     if (this._map.equals(other))
/*  81 */       return true;
/*  82 */     if ((other instanceof Map)) {
/*  83 */       Map that = (Map)other;
/*  84 */       if (that.size() != this._map.size()) {
/*  85 */         return false;
/*     */       }
/*  87 */       Iterator it = that.entrySet().iterator();
/*  88 */       for (int i = that.size(); i-- > 0; ) {
/*  89 */         Map.Entry e = (Map.Entry)it.next();
/*  90 */         Object key = e.getKey();
/*  91 */         Object val = e.getValue();
/*  92 */         if (((key instanceof Integer)) && ((val instanceof Integer))) {
/*  93 */           long k = unwrapKey(key);
/*  94 */           float v = unwrapValue(val);
/*  95 */           if ((!this._map.containsKey(k)) || (v != this._map.get(k)))
/*     */           {
/*  98 */             return false;
/*     */           }
/*     */         } else {
/* 101 */           return false;
/*     */         }
/*     */       }
/* 104 */       return true;
/*     */     }
/*     */ 
/* 107 */     return false;
/*     */   }
/*     */ 
/*     */   public Object get(Object key)
/*     */   {
/* 118 */     long k = unwrapKey(key);
/* 119 */     float v = this._map.get(k);
/*     */ 
/* 123 */     if (v == 0.0F) {
/* 124 */       return this._map.containsKey(k) ? wrapValue(v) : null;
/*     */     }
/* 126 */     return wrapValue(v);
/*     */   }
/*     */ 
/*     */   public void clear()
/*     */   {
/* 135 */     this._map.clear();
/*     */   }
/*     */ 
/*     */   public Object remove(Object key)
/*     */   {
/* 145 */     return wrapValue(this._map.remove(unwrapKey(key)));
/*     */   }
/*     */ 
/*     */   public Set entrySet()
/*     */   {
/* 154 */     return new AbstractSet() {
/*     */       public int size() {
/* 156 */         return TLongFloatHashMapDecorator.this._map.size();
/*     */       }
/*     */       public boolean isEmpty() {
/* 159 */         return TLongFloatHashMapDecorator.this.isEmpty();
/*     */       }
/*     */       public boolean contains(Object o) {
/* 162 */         if ((o instanceof Map.Entry)) {
/* 163 */           Object k = ((Map.Entry)o).getKey();
/* 164 */           Object v = ((Map.Entry)o).getValue();
/* 165 */           return (TLongFloatHashMapDecorator.this.containsKey(k)) && (TLongFloatHashMapDecorator.this.get(k).equals(v));
/*     */         }
/*     */ 
/* 168 */         return false;
/*     */       }
/*     */ 
/*     */       public Iterator iterator() {
/* 172 */         return new TLongFloatHashMapDecorator.2(this);
/*     */       }
/*     */ 
/*     */       public boolean add(Object o)
/*     */       {
/* 212 */         throw new UnsupportedOperationException();
/*     */       }
/*     */       public boolean remove(Object o) {
/* 215 */         throw new UnsupportedOperationException();
/*     */       }
/*     */       public boolean addAll(Collection c) {
/* 218 */         throw new UnsupportedOperationException();
/*     */       }
/*     */       public boolean retainAll(Collection c) {
/* 221 */         throw new UnsupportedOperationException();
/*     */       }
/*     */       public boolean removeAll(Collection c) {
/* 224 */         throw new UnsupportedOperationException();
/*     */       }
/*     */       public void clear() {
/* 227 */         TLongFloatHashMapDecorator.this.clear();
/*     */       }
/*     */     };
/*     */   }
/*     */ 
/*     */   public boolean containsValue(Object val)
/*     */   {
/* 239 */     return this._map.containsValue(unwrapValue(val));
/*     */   }
/*     */ 
/*     */   public boolean containsKey(Object key)
/*     */   {
/* 249 */     return this._map.containsKey(unwrapKey(key));
/*     */   }
/*     */ 
/*     */   public int size()
/*     */   {
/* 257 */     return this._map.size();
/*     */   }
/*     */ 
/*     */   public boolean isEmpty()
/*     */   {
/* 265 */     return size() == 0;
/*     */   }
/*     */ 
/*     */   public void putAll(Map map)
/*     */   {
/* 276 */     Iterator it = map.entrySet().iterator();
/* 277 */     for (int i = map.size(); i-- > 0; ) {
/* 278 */       Map.Entry e = (Map.Entry)it.next();
/* 279 */       put(e.getKey(), e.getValue());
/*     */     }
/*     */   }
/*     */ 
/*     */   protected Long wrapKey(long k)
/*     */   {
/* 290 */     return new Long(k);
/*     */   }
/*     */ 
/*     */   protected long unwrapKey(Object key)
/*     */   {
/* 300 */     return ((Long)key).longValue();
/*     */   }
/*     */ 
/*     */   protected Float wrapValue(float k)
/*     */   {
/* 309 */     return new Float(k);
/*     */   }
/*     */ 
/*     */   protected float unwrapValue(Object value)
/*     */   {
/* 319 */     return ((Float)value).floatValue();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     gnu.trove.decorator.TLongFloatHashMapDecorator
 * JD-Core Version:    0.6.0
 */