/*    */ package gnu.trove.benchmark;
/*    */ 
/*    */ class Repeater
/*    */   implements Timer
/*    */ {
/*    */   int _count;
/*    */   Operation _operation;
/*    */ 
/*    */   Repeater(Operation o)
/*    */   {
/* 26 */     this._count = o.getIterationCount();
/* 27 */     this._operation = o;
/*    */   }
/*    */ 
/*    */   public Result run() {
/* 31 */     long theirs = theirs();
/* 32 */     long ours = ours();
/* 33 */     Result r = new Result();
/* 34 */     r.setTheirs(theirs);
/* 35 */     r.setOurs(ours);
/* 36 */     r.setIterations(this._count);
/* 37 */     r.setDescription(this._operation.toString());
/* 38 */     return r;
/*    */   }
/*    */ 
/*    */   public long theirs() {
/* 42 */     long then = System.currentTimeMillis();
/* 43 */     for (int i = 0; i < this._count; i++) {
/* 44 */       this._operation.theirs();
/*    */     }
/* 46 */     long now = System.currentTimeMillis();
/* 47 */     return now - then;
/*    */   }
/*    */ 
/*    */   public long ours() {
/* 51 */     long then = System.currentTimeMillis();
/* 52 */     for (int i = 0; i < this._count; i++) {
/* 53 */       this._operation.ours();
/*    */     }
/* 55 */     long now = System.currentTimeMillis();
/* 56 */     return now - then;
/*    */   }
/*    */ 
/*    */   public Operation getOperation() {
/* 60 */     return this._operation;
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     gnu.trove.benchmark.Repeater
 * JD-Core Version:    0.6.0
 */