/*     */ package gnu.trove.benchmark;
/*     */ 
/*     */ import gnu.trove.THashMap;
/*     */ import gnu.trove.THashSet;
/*     */ import gnu.trove.TIntIntHashMap;
/*     */ import gnu.trove.TLinkableAdaptor;
/*     */ import gnu.trove.TLinkedList;
/*     */ import gnu.trove.TObjectProcedure;
/*     */ import java.util.ArrayList;
/*     */ import java.util.HashMap;
/*     */ import java.util.HashSet;
/*     */ import java.util.Iterator;
/*     */ import java.util.LinkedList;
/*     */ import java.util.List;
/*     */ import java.util.Map;
/*     */ import java.util.Random;
/*     */ import java.util.Set;
/*     */ 
/*     */ public class Main
/*     */ {
/*     */   static final int SET_SIZE = 100000;
/*  35 */   static final List dataset = new ArrayList(100000);
/*     */ 
/*     */   public static Operation getSetOperation()
/*     */   {
/*  44 */     return new Operation() {
/*     */       public void theirs() {
/*  46 */         Set s = new HashSet(100000);
/*  47 */         for (Iterator i = Main.dataset.iterator(); i.hasNext(); )
/*  48 */           s.add(i.next());
/*     */       }
/*     */ 
/*     */       public void ours()
/*     */       {
/*  53 */         Set s = new THashSet(100000);
/*  54 */         for (Iterator i = Main.dataset.iterator(); i.hasNext(); )
/*  55 */           s.add(i.next());
/*     */       }
/*     */ 
/*     */       public String toString()
/*     */       {
/*  60 */         return "compares " + Main.dataset.size() + " Set.add() operations";
/*     */       }
/*     */ 
/*     */       public int getIterationCount() {
/*  64 */         return 10;
/*     */       }
/*     */     };
/*     */   }
/*     */ 
/*     */   public static Operation getLinkedListAddOp() {
/*  71 */     List data = new ArrayList(100000);
/*  72 */     for (int i = 0; i < 100000; i++) {
/*  73 */       data.add(new TLinkableAdaptor());
/*     */     }
/*     */ 
/*  77 */     return new Operation(data) { private final List val$data;
/*     */ 
/*  80 */       public void theirs() { List l = new LinkedList();
/*  81 */         for (Iterator i = this.val$data.iterator(); i.hasNext(); )
/*  82 */           l.add(i.next());
/*     */       }
/*     */ 
/*     */       public void ours()
/*     */       {
/*  87 */         List l = new TLinkedList();
/*  88 */         for (Iterator i = this.val$data.iterator(); i.hasNext(); )
/*  89 */           l.add(i.next());
/*     */       }
/*     */ 
/*     */       public String toString()
/*     */       {
/*  94 */         return "compares " + Main.dataset.size() + " LinkedList.add() operations";
/*     */       }
/*     */ 
/*     */       public int getIterationCount() {
/*  98 */         return 10;
/*     */       } } ;
/*     */   }
/*     */ 
/*     */   static Operation getContainsOp() {
/* 104 */     Set theirs = new HashSet(dataset.size());
/* 105 */     theirs.addAll(dataset);
/* 106 */     Set ours = new THashSet(dataset.size());
/* 107 */     ours.addAll(dataset);
/*     */ 
/* 109 */     return new Operation(theirs, ours) { private final Set val$theirs;
/*     */       private final Set val$ours;
/*     */ 
/* 111 */       public void theirs() { for (int i = 0; i < Main.dataset.size(); i += 5)
/* 112 */           this.val$theirs.contains(Main.dataset.get(i));
/*     */       }
/*     */ 
/*     */       public void ours()
/*     */       {
/* 117 */         for (int i = 0; i < Main.dataset.size(); i += 5)
/* 118 */           this.val$ours.contains(Main.dataset.get(i));
/*     */       }
/*     */ 
/*     */       public String toString()
/*     */       {
/* 123 */         return "compares " + Main.dataset.size() / 5 + " Set.contains() operations";
/*     */       }
/*     */ 
/*     */       public int getIterationCount() {
/* 127 */         return 10;
/*     */       } } ;
/*     */   }
/*     */ 
/*     */   static Operation getRandomSetContainsOp() {
/* 133 */     Set theirs = new HashSet(100000);
/* 134 */     Set ours = new THashSet(100000);
/* 135 */     Random rand = new Random(9999L);
/*     */ 
/* 137 */     for (int i = 0; i < 100000; i++) {
/* 138 */       Integer x = new Integer(rand.nextInt());
/* 139 */       theirs.add(x);
/* 140 */       ours.add(x);
/*     */     }
/*     */ 
/* 143 */     Random rand2 = new Random(9998L);
/* 144 */     List query = new ArrayList(100000);
/* 145 */     int match = 0;
/* 146 */     for (int i = 0; i < 100000; i++) {
/* 147 */       Integer x = new Integer(rand.nextInt());
/* 148 */       query.add(x);
/* 149 */       if (theirs.contains(x)) {
/* 150 */         match++;
/*     */       }
/*     */     }
/*     */ 
/* 154 */     int success = match;
/*     */ 
/* 156 */     return new Operation(query, theirs, ours, success) { private final List val$query;
/*     */       private final Set val$theirs;
/*     */       private final Set val$ours;
/*     */       private final int val$success;
/*     */ 
/* 158 */       public void theirs() { for (Iterator i = this.val$query.iterator(); i.hasNext(); )
/* 159 */           this.val$theirs.contains(i.next());
/*     */       }
/*     */ 
/*     */       public void ours()
/*     */       {
/* 164 */         for (Iterator i = this.val$query.iterator(); i.hasNext(); )
/* 165 */           this.val$ours.contains(i.next());
/*     */       }
/*     */ 
/*     */       public String toString()
/*     */       {
/* 170 */         return "compares 100000 Set.contains() operations. " + this.val$success + " are actually present in set";
/*     */       }
/*     */ 
/*     */       public int getIterationCount()
/*     */       {
/* 175 */         return 10;
/*     */       } } ;
/*     */   }
/*     */ 
/*     */   static Operation getMapPutOp() {
/* 181 */     return new Operation() {
/*     */       public void theirs() {
/* 183 */         Map theirs = new HashMap(Main.dataset.size());
/* 184 */         for (Iterator i = Main.dataset.iterator(); i.hasNext(); ) {
/* 185 */           Object o = i.next();
/* 186 */           theirs.put(o, o);
/*     */         }
/*     */       }
/*     */ 
/*     */       public void ours() {
/* 191 */         Map ours = new THashMap(Main.dataset.size());
/* 192 */         for (Iterator i = Main.dataset.iterator(); i.hasNext(); ) {
/* 193 */           Object o = i.next();
/* 194 */           ours.put(o, o);
/*     */         }
/*     */       }
/*     */ 
/*     */       public String toString() {
/* 199 */         return "compares " + Main.dataset.size() + " Map.put() operations";
/*     */       }
/*     */ 
/*     */       public int getIterationCount() {
/* 203 */         return 10;
/*     */       } } ;
/*     */   }
/*     */ 
/*     */   static Operation getIterationOp() {
/* 209 */     Map theirMap = new HashMap(dataset.size());
/* 210 */     Map ourMap = new THashMap(dataset.size());
/* 211 */     for (Iterator i = dataset.iterator(); i.hasNext(); ) {
/* 212 */       Object o = i.next();
/* 213 */       theirMap.put(o, o);
/* 214 */       ourMap.put(o, o);
/*     */     }
/*     */ 
/* 217 */     return new Operation(theirMap, ourMap) { private final Map val$theirMap;
/*     */       private final Map val$ourMap;
/*     */ 
/* 219 */       public void theirs() { Map m = this.val$theirMap;
/* 220 */         Iterator i = m.keySet().iterator();
/* 221 */         for (int size = m.size(); size-- > 0; )
/* 222 */           o = i.next();
/*     */         Object o; }
/*     */ 
/*     */       public void ours() {
/* 227 */         Map m = this.val$ourMap;
/* 228 */         Iterator i = m.keySet().iterator();
/* 229 */         for (int size = m.size(); size-- > 0; )
/* 230 */           o = i.next(); Object o;
/*     */       }
/*     */ 
/*     */       public String toString() {
/* 235 */         return "compares Iterator.next() over " + Main.dataset.size() + " map keys";
/*     */       }
/*     */ 
/*     */       public int getIterationCount() {
/* 239 */         return 10;
/*     */       } } ;
/*     */   }
/*     */ 
/*     */   static Operation getIterationWithHasNextOp() {
/* 245 */     Map theirMap = new HashMap(dataset.size());
/* 246 */     Map ourMap = new THashMap(dataset.size());
/* 247 */     for (Iterator i = dataset.iterator(); i.hasNext(); ) {
/* 248 */       Object o = i.next();
/* 249 */       theirMap.put(o, o);
/* 250 */       ourMap.put(o, o);
/*     */     }
/*     */ 
/* 253 */     return new Operation(theirMap, ourMap) { private final Map val$theirMap;
/*     */       private final Map val$ourMap;
/*     */ 
/* 255 */       public void theirs() { Map m = this.val$theirMap;
/* 256 */         Iterator i = m.keySet().iterator();
/*     */         Object o;
/* 257 */         while (i.hasNext())
/* 258 */           o = i.next();
/*     */       }
/*     */ 
/*     */       public void ours()
/*     */       {
/* 263 */         Map m = this.val$ourMap;
/* 264 */         Iterator i = m.keySet().iterator();
/*     */         Object o;
/* 265 */         while (i.hasNext())
/* 266 */           o = i.next();
/*     */       }
/*     */ 
/*     */       public String toString()
/*     */       {
/* 271 */         return "compares Iterator.hasNext()/ Iterator.next() over " + this.val$theirMap.size() + " keys";
/*     */       }
/*     */ 
/*     */       public int getIterationCount() {
/* 275 */         return 10;
/*     */       } } ;
/*     */   }
/*     */ 
/*     */   static Operation getIntMapPut() {
/* 281 */     return new Operation() {
/*     */       public void theirs() {
/*     */       }
/*     */ 
/*     */       public void ours() {
/* 286 */         TIntIntHashMap ours = new TIntIntHashMap(100000);
/* 287 */         for (int i = Main.dataset.size(); i-- > 0; )
/* 288 */           ours.put(i, i);
/*     */       }
/*     */ 
/*     */       public String toString()
/*     */       {
/* 293 */         return Main.dataset.size() + " entry primitive int map.put timing run; no basis for comparison";
/*     */       }
/*     */ 
/*     */       public int getIterationCount() {
/* 297 */         return 10;
/*     */       } } ;
/*     */   }
/*     */ 
/*     */   static Operation getSumSetOperation() {
/* 303 */     Set theirSet = new HashSet(dataset.size());
/* 304 */     THashSet ourSet = new THashSet(dataset.size());
/* 305 */     theirSet.addAll(dataset);
/* 306 */     ourSet.addAll(dataset);
/* 307 */     TObjectProcedure proc = new TObjectProcedure() {
/* 308 */       int sum = 0;
/*     */ 
/* 310 */       public boolean execute(Object o) { this.sum += ((Integer)o).intValue();
/* 311 */         return true;
/*     */       }
/*     */     };
/* 314 */     return new Operation(theirSet, ourSet, proc) { private final Set val$theirSet;
/*     */       private final THashSet val$ourSet;
/*     */       private final TObjectProcedure val$proc;
/*     */ 
/* 316 */       public void theirs() { int sum = 0;
/* 317 */         for (Iterator i = this.val$theirSet.iterator(); i.hasNext(); )
/* 318 */           sum += ((Integer)i.next()).intValue();
/*     */       }
/*     */ 
/*     */       public void ours()
/*     */       {
/* 323 */         this.val$ourSet.forEach(this.val$proc);
/*     */       }
/*     */ 
/*     */       public String toString() {
/* 327 */         return "sums a " + this.val$theirSet.size() + " element Set of Integer objects.  Their approach uses Iterator.hasNext()/next(); ours uses THashSet.forEach(TObjectProcedure)";
/*     */       }
/*     */ 
/*     */       public int getIterationCount() {
/* 331 */         return 10;
/*     */       }
/*     */     };
/*     */   }
/*     */ 
/*     */   public static void main(String[] args)
/*     */   {
/* 342 */     Reporter reporter = new TextReporter();
/* 343 */     reporter.start();
/*     */ 
/* 345 */     Operation op = getRandomSetContainsOp();
/* 346 */     Timer t = new Repeater(op);
/* 347 */     reporter.report(t.run());
/*     */ 
/* 349 */     op = getSumSetOperation();
/* 350 */     t = new Repeater(op);
/* 351 */     reporter.report(t.run());
/*     */ 
/* 353 */     op = getIterationWithHasNextOp();
/* 354 */     t = new Repeater(op);
/* 355 */     reporter.report(t.run());
/*     */ 
/* 357 */     op = getIterationOp();
/* 358 */     t = new Repeater(op);
/* 359 */     reporter.report(t.run());
/*     */ 
/* 361 */     op = getLinkedListAddOp();
/* 362 */     t = new Repeater(op);
/* 363 */     reporter.report(t.run());
/*     */ 
/* 365 */     op = getIntMapPut();
/* 366 */     t = new Repeater(op);
/* 367 */     reporter.report(t.run());
/*     */ 
/* 369 */     op = getMapPutOp();
/* 370 */     t = new Repeater(op);
/* 371 */     reporter.report(t.run());
/*     */ 
/* 373 */     op = getContainsOp();
/* 374 */     t = new Repeater(op);
/* 375 */     reporter.report(t.run());
/*     */ 
/* 377 */     op = getSetOperation();
/* 378 */     t = new Repeater(op);
/* 379 */     reporter.report(t.run());
/*     */ 
/* 381 */     reporter.finish();
/*     */   }
/*     */ 
/*     */   static
/*     */   {
/*  37 */     for (int i = 0; i < 100000; i++)
/*  38 */       dataset.add(new Integer(i));
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     gnu.trove.benchmark.Main
 * JD-Core Version:    0.6.0
 */