/*     */ package gnu.trove;
/*     */ 
/*     */ import java.util.ConcurrentModificationException;
/*     */ 
/*     */ public class TObjectIntIterator extends TIterator
/*     */ {
/*     */   private final TObjectIntHashMap _map;
/*     */ 
/*     */   public TObjectIntIterator(TObjectIntHashMap map)
/*     */   {
/*  95 */     super(map);
/*  96 */     this._map = map;
/*     */   }
/*     */ 
/*     */   protected final int nextIndex()
/*     */   {
/* 106 */     if (this._expectedSize != this._hash.size()) {
/* 107 */       throw new ConcurrentModificationException();
/*     */     }
/*     */ 
/* 110 */     Object[] set = this._map._set;
/* 111 */     int i = this._index;
/* 112 */     while ((i-- > 0) && ((set[i] == null) || (set[i] == TObjectHash.REMOVED)));
/* 113 */     return i;
/*     */   }
/*     */ 
/*     */   public void advance()
/*     */   {
/* 122 */     moveToNextIndex();
/*     */   }
/*     */ 
/*     */   public Object key()
/*     */   {
/* 133 */     return this._map._set[this._index];
/*     */   }
/*     */ 
/*     */   public int value()
/*     */   {
/* 144 */     return this._map._values[this._index];
/*     */   }
/*     */ 
/*     */   public int setValue(int val)
/*     */   {
/* 156 */     int old = value();
/* 157 */     this._map._values[this._index] = val;
/* 158 */     return old;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     gnu.trove.TObjectIntIterator
 * JD-Core Version:    0.6.0
 */