/*     */ package gnu.trove;
/*     */ 
/*     */ import java.util.ConcurrentModificationException;
/*     */ 
/*     */ public class TObjectFloatIterator extends TIterator
/*     */ {
/*     */   private final TObjectFloatHashMap _map;
/*     */ 
/*     */   public TObjectFloatIterator(TObjectFloatHashMap map)
/*     */   {
/*  95 */     super(map);
/*  96 */     this._map = map;
/*     */   }
/*     */ 
/*     */   protected final int nextIndex()
/*     */   {
/* 106 */     if (this._expectedSize != this._hash.size()) {
/* 107 */       throw new ConcurrentModificationException();
/*     */     }
/*     */ 
/* 110 */     Object[] set = this._map._set;
/* 111 */     int i = this._index;
/* 112 */     while ((i-- > 0) && ((set[i] == null) || (set[i] == TObjectHash.REMOVED)));
/* 113 */     return i;
/*     */   }
/*     */ 
/*     */   public void advance()
/*     */   {
/* 122 */     moveToNextIndex();
/*     */   }
/*     */ 
/*     */   public Object key()
/*     */   {
/* 133 */     return this._map._set[this._index];
/*     */   }
/*     */ 
/*     */   public float value()
/*     */   {
/* 144 */     return this._map._values[this._index];
/*     */   }
/*     */ 
/*     */   public float setValue(float val)
/*     */   {
/* 156 */     float old = value();
/* 157 */     this._map._values[this._index] = val;
/* 158 */     return old;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     gnu.trove.TObjectFloatIterator
 * JD-Core Version:    0.6.0
 */