/*     */ package gnu.trove;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.ObjectInputStream;
/*     */ import java.io.ObjectOutputStream;
/*     */ import java.io.Serializable;
/*     */ 
/*     */ public class TObjectFloatHashMap extends TObjectHash
/*     */   implements Serializable
/*     */ {
/*     */   protected transient float[] _values;
/*     */ 
/*     */   public TObjectFloatHashMap()
/*     */   {
/*     */   }
/*     */ 
/*     */   public TObjectFloatHashMap(int initialCapacity)
/*     */   {
/*  55 */     super(initialCapacity);
/*     */   }
/*     */ 
/*     */   public TObjectFloatHashMap(int initialCapacity, float loadFactor)
/*     */   {
/*  67 */     super(initialCapacity, loadFactor);
/*     */   }
/*     */ 
/*     */   public TObjectFloatHashMap(TObjectHashingStrategy strategy)
/*     */   {
/*  76 */     super(strategy);
/*     */   }
/*     */ 
/*     */   public TObjectFloatHashMap(int initialCapacity, TObjectHashingStrategy strategy)
/*     */   {
/*  88 */     super(initialCapacity, strategy);
/*     */   }
/*     */ 
/*     */   public TObjectFloatHashMap(int initialCapacity, float loadFactor, TObjectHashingStrategy strategy)
/*     */   {
/* 101 */     super(initialCapacity, loadFactor, strategy);
/*     */   }
/*     */ 
/*     */   public TObjectFloatIterator iterator()
/*     */   {
/* 108 */     return new TObjectFloatIterator(this);
/*     */   }
/*     */ 
/*     */   protected int setUp(int initialCapacity)
/*     */   {
/* 121 */     int capacity = super.setUp(initialCapacity);
/* 122 */     this._values = new float[capacity];
/* 123 */     return capacity;
/*     */   }
/*     */ 
/*     */   public float put(Object key, float value)
/*     */   {
/* 135 */     float previous = 0.0F;
/* 136 */     int index = insertionIndex(key);
/* 137 */     boolean isNewMapping = true;
/* 138 */     if (index < 0) {
/* 139 */       index = -index - 1;
/* 140 */       previous = this._values[index];
/* 141 */       isNewMapping = false;
/*     */     }
/* 143 */     Object oldKey = this._set[index];
/* 144 */     this._set[index] = key;
/* 145 */     this._values[index] = value;
/*     */ 
/* 147 */     if (isNewMapping) {
/* 148 */       postInsertHook(oldKey == null);
/*     */     }
/* 150 */     return previous;
/*     */   }
/*     */ 
/*     */   protected void rehash(int newCapacity)
/*     */   {
/* 159 */     int oldCapacity = this._set.length;
/* 160 */     Object[] oldKeys = this._set;
/* 161 */     float[] oldVals = this._values;
/*     */ 
/* 163 */     this._set = new Object[newCapacity];
/* 164 */     this._values = new float[newCapacity];
/*     */ 
/* 166 */     for (int i = oldCapacity; i-- > 0; )
/* 167 */       if ((oldKeys[i] != null) && (oldKeys[i] != REMOVED)) {
/* 168 */         Object o = oldKeys[i];
/* 169 */         int index = insertionIndex(o);
/* 170 */         if (index < 0) {
/* 171 */           throwObjectContractViolation(this._set[(-index - 1)], o);
/*     */         }
/* 173 */         this._set[index] = o;
/* 174 */         this._values[index] = oldVals[i];
/*     */       }
/*     */   }
/*     */ 
/*     */   public float get(Object key)
/*     */   {
/* 186 */     int index = index(key);
/* 187 */     return index < 0 ? 0.0F : this._values[index];
/*     */   }
/*     */ 
/*     */   public void clear()
/*     */   {
/* 195 */     super.clear();
/* 196 */     Object[] keys = this._set;
/* 197 */     float[] vals = this._values;
/*     */ 
/* 199 */     for (int i = keys.length; i-- > 0; ) {
/* 200 */       keys[i] = null;
/* 201 */       vals[i] = 0.0F;
/*     */     }
/*     */   }
/*     */ 
/*     */   public float remove(Object key)
/*     */   {
/* 212 */     float prev = 0.0F;
/* 213 */     int index = index(key);
/* 214 */     if (index >= 0) {
/* 215 */       prev = this._values[index];
/* 216 */       removeAt(index);
/*     */     }
/* 218 */     return prev;
/*     */   }
/*     */ 
/*     */   public boolean equals(Object other)
/*     */   {
/* 229 */     if (!(other instanceof TObjectFloatHashMap)) {
/* 230 */       return false;
/*     */     }
/* 232 */     TObjectFloatHashMap that = (TObjectFloatHashMap)other;
/* 233 */     if (that.size() != size()) {
/* 234 */       return false;
/*     */     }
/* 236 */     return forEachEntry(new EqProcedure(that));
/*     */   }
/*     */ 
/*     */   protected void removeAt(int index)
/*     */   {
/* 269 */     super.removeAt(index);
/* 270 */     this._values[index] = 0.0F;
/*     */   }
/*     */ 
/*     */   public float[] getValues()
/*     */   {
/* 279 */     float[] vals = new float[size()];
/* 280 */     float[] v = this._values;
/* 281 */     Object[] keys = this._set;
/*     */ 
/* 283 */     int i = v.length; for (int j = 0; i-- > 0; ) {
/* 284 */       if ((keys[i] != null) && (keys[i] != REMOVED)) {
/* 285 */         vals[(j++)] = v[i];
/*     */       }
/*     */     }
/* 288 */     return vals;
/*     */   }
/*     */ 
/*     */   public Object[] keys()
/*     */   {
/* 297 */     Object[] keys = new Object[size()];
/* 298 */     Object[] k = this._set;
/*     */ 
/* 300 */     int i = k.length; for (int j = 0; i-- > 0; ) {
/* 301 */       if ((k[i] != null) && (k[i] != REMOVED)) {
/* 302 */         keys[(j++)] = k[i];
/*     */       }
/*     */     }
/* 305 */     return keys;
/*     */   }
/*     */ 
/*     */   public boolean containsValue(float val)
/*     */   {
/* 315 */     Object[] keys = this._set;
/* 316 */     float[] vals = this._values;
/*     */ 
/* 318 */     for (int i = vals.length; i-- > 0; ) {
/* 319 */       if ((keys[i] != null) && (keys[i] != REMOVED) && (val == vals[i])) {
/* 320 */         return true;
/*     */       }
/*     */     }
/* 323 */     return false;
/*     */   }
/*     */ 
/*     */   public boolean containsKey(Object key)
/*     */   {
/* 334 */     return contains(key);
/*     */   }
/*     */ 
/*     */   public boolean forEachKey(TObjectProcedure procedure)
/*     */   {
/* 345 */     return forEach(procedure);
/*     */   }
/*     */ 
/*     */   public boolean forEachValue(TFloatProcedure procedure)
/*     */   {
/* 356 */     Object[] keys = this._set;
/* 357 */     float[] values = this._values;
/* 358 */     for (int i = values.length; i-- > 0; ) {
/* 359 */       if ((keys[i] != null) && (keys[i] != REMOVED) && (!procedure.execute(values[i])))
/*     */       {
/* 361 */         return false;
/*     */       }
/*     */     }
/* 364 */     return true;
/*     */   }
/*     */ 
/*     */   public boolean forEachEntry(TObjectFloatProcedure procedure)
/*     */   {
/* 376 */     Object[] keys = this._set;
/* 377 */     float[] values = this._values;
/* 378 */     for (int i = keys.length; i-- > 0; ) {
/* 379 */       if ((keys[i] != null) && (keys[i] != REMOVED) && (!procedure.execute(keys[i], values[i])))
/*     */       {
/* 382 */         return false;
/*     */       }
/*     */     }
/* 385 */     return true;
/*     */   }
/*     */ 
/*     */   public boolean retainEntries(TObjectFloatProcedure procedure)
/*     */   {
/* 396 */     boolean modified = false;
/* 397 */     Object[] keys = this._set;
/* 398 */     float[] values = this._values;
/* 399 */     for (int i = keys.length; i-- > 0; ) {
/* 400 */       if ((keys[i] == null) || (keys[i] == REMOVED) || (procedure.execute(keys[i], values[i]))) {
/*     */         continue;
/*     */       }
/* 403 */       removeAt(i);
/* 404 */       modified = true;
/*     */     }
/*     */ 
/* 407 */     return modified;
/*     */   }
/*     */ 
/*     */   public void transformValues(TFloatFunction function)
/*     */   {
/* 416 */     Object[] keys = this._set;
/* 417 */     float[] values = this._values;
/* 418 */     for (int i = values.length; i-- > 0; )
/* 419 */       if ((keys[i] != null) && (keys[i] != REMOVED))
/* 420 */         values[i] = function.execute(values[i]);
/*     */   }
/*     */ 
/*     */   public boolean increment(Object key)
/*     */   {
/* 432 */     return adjustValue(key, 1.0F);
/*     */   }
/*     */ 
/*     */   public boolean adjustValue(Object key, float amount)
/*     */   {
/* 443 */     int index = index(key);
/* 444 */     if (index < 0) {
/* 445 */       return false;
/*     */     }
/* 447 */     this._values[index] += amount;
/* 448 */     return true;
/*     */   }
/*     */ 
/*     */   private void writeObject(ObjectOutputStream stream)
/*     */     throws IOException
/*     */   {
/* 455 */     stream.defaultWriteObject();
/*     */ 
/* 458 */     stream.writeInt(this._size);
/*     */ 
/* 460 */     SerializationProcedure writeProcedure = new SerializationProcedure(stream);
/* 461 */     if (!forEachEntry(writeProcedure))
/* 462 */       throw writeProcedure.exception;
/*     */   }
/*     */ 
/*     */   private void readObject(ObjectInputStream stream)
/*     */     throws IOException, ClassNotFoundException
/*     */   {
/* 468 */     stream.defaultReadObject();
/*     */ 
/* 470 */     int size = stream.readInt();
/* 471 */     setUp(size);
/* 472 */     while (size-- > 0) {
/* 473 */       Object key = stream.readObject();
/* 474 */       float val = stream.readFloat();
/* 475 */       put(key, val);
/*     */     }
/*     */   }
/*     */ 
/*     */   private static final class EqProcedure
/*     */     implements TObjectFloatProcedure
/*     */   {
/*     */     private final TObjectFloatHashMap _otherMap;
/*     */ 
/*     */     EqProcedure(TObjectFloatHashMap otherMap)
/*     */     {
/* 243 */       this._otherMap = otherMap;
/*     */     }
/*     */ 
/*     */     public final boolean execute(Object key, float value) {
/* 247 */       int index = this._otherMap.index(key);
/*     */ 
/* 249 */       return (index >= 0) && (eq(value, this._otherMap.get(key)));
/*     */     }
/*     */ 
/*     */     private final boolean eq(float v1, float v2)
/*     */     {
/* 258 */       return v1 == v2;
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     gnu.trove.TObjectFloatHashMap
 * JD-Core Version:    0.6.0
 */