/*     */ package gnu.trove;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.ObjectInputStream;
/*     */ import java.io.ObjectOutputStream;
/*     */ import java.io.Serializable;
/*     */ import java.util.Arrays;
/*     */ 
/*     */ public class TLongHashSet extends TLongHash
/*     */   implements Serializable
/*     */ {
/*     */   public TLongHashSet()
/*     */   {
/*     */   }
/*     */ 
/*     */   public TLongHashSet(int initialCapacity)
/*     */   {
/*  55 */     super(initialCapacity);
/*     */   }
/*     */ 
/*     */   public TLongHashSet(int initialCapacity, float loadFactor)
/*     */   {
/*  67 */     super(initialCapacity, loadFactor);
/*     */   }
/*     */ 
/*     */   public TLongHashSet(long[] array)
/*     */   {
/*  77 */     this(array.length);
/*  78 */     addAll(array);
/*     */   }
/*     */ 
/*     */   public TLongHashSet(TLongHashingStrategy strategy)
/*     */   {
/*  87 */     super(strategy);
/*     */   }
/*     */ 
/*     */   public TLongHashSet(int initialCapacity, TLongHashingStrategy strategy)
/*     */   {
/*  99 */     super(initialCapacity, strategy);
/*     */   }
/*     */ 
/*     */   public TLongHashSet(int initialCapacity, float loadFactor, TLongHashingStrategy strategy)
/*     */   {
/* 112 */     super(initialCapacity, loadFactor, strategy);
/*     */   }
/*     */ 
/*     */   public TLongHashSet(long[] array, TLongHashingStrategy strategy)
/*     */   {
/* 123 */     this(array.length, strategy);
/* 124 */     addAll(array);
/*     */   }
/*     */ 
/*     */   public TLongIterator iterator()
/*     */   {
/* 131 */     return new TLongIterator(this);
/*     */   }
/*     */ 
/*     */   public boolean add(long val)
/*     */   {
/* 141 */     int index = insertionIndex(val);
/*     */ 
/* 143 */     if (index < 0) {
/* 144 */       return false;
/*     */     }
/*     */ 
/* 147 */     byte previousState = this._states[index];
/* 148 */     this._set[index] = val;
/* 149 */     this._states[index] = 1;
/* 150 */     postInsertHook(previousState == 0);
/*     */ 
/* 152 */     return true;
/*     */   }
/*     */ 
/*     */   protected void rehash(int newCapacity)
/*     */   {
/* 161 */     int oldCapacity = this._set.length;
/* 162 */     long[] oldSet = this._set;
/* 163 */     byte[] oldStates = this._states;
/*     */ 
/* 165 */     this._set = new long[newCapacity];
/* 166 */     this._states = new byte[newCapacity];
/*     */ 
/* 168 */     for (int i = oldCapacity; i-- > 0; )
/* 169 */       if (oldStates[i] == 1) {
/* 170 */         long o = oldSet[i];
/* 171 */         int index = insertionIndex(o);
/* 172 */         this._set[index] = o;
/* 173 */         this._states[index] = 1;
/*     */       }
/*     */   }
/*     */ 
/*     */   public long[] toArray()
/*     */   {
/* 184 */     long[] result = new long[size()];
/* 185 */     long[] set = this._set;
/* 186 */     byte[] states = this._states;
/*     */ 
/* 188 */     int i = states.length; for (int j = 0; i-- > 0; ) {
/* 189 */       if (states[i] == 1) {
/* 190 */         result[(j++)] = set[i];
/*     */       }
/*     */     }
/* 193 */     return result;
/*     */   }
/*     */ 
/*     */   public void clear()
/*     */   {
/* 200 */     super.clear();
/* 201 */     long[] set = this._set;
/* 202 */     byte[] states = this._states;
/*     */ 
/* 204 */     for (int i = set.length; i-- > 0; ) {
/* 205 */       set[i] = 0L;
/* 206 */       states[i] = 0;
/*     */     }
/*     */   }
/*     */ 
/*     */   public boolean equals(Object other)
/*     */   {
/* 218 */     if (!(other instanceof TLongHashSet)) {
/* 219 */       return false;
/*     */     }
/* 221 */     TLongHashSet that = (TLongHashSet)other;
/* 222 */     if (that.size() != size()) {
/* 223 */       return false;
/*     */     }
/* 225 */     return forEach(new TLongProcedure(that) { private final TLongHashSet val$that;
/*     */ 
/* 227 */       public final boolean execute(long value) { return this.val$that.contains(value); } } );
/*     */   }
/*     */ 
/*     */   public int hashCode()
/*     */   {
/* 233 */     HashProcedure p = new HashProcedure(null);
/* 234 */     forEach(p);
/* 235 */     return p.getHashCode();
/*     */   }
/*     */ 
/*     */   public boolean remove(long val)
/*     */   {
/* 258 */     int index = index(val);
/* 259 */     if (index >= 0) {
/* 260 */       removeAt(index);
/* 261 */       return true;
/*     */     }
/* 263 */     return false;
/*     */   }
/*     */ 
/*     */   public boolean containsAll(long[] array)
/*     */   {
/* 274 */     for (int i = array.length; i-- > 0; ) {
/* 275 */       if (!contains(array[i])) {
/* 276 */         return false;
/*     */       }
/*     */     }
/* 279 */     return true;
/*     */   }
/*     */ 
/*     */   public boolean addAll(long[] array)
/*     */   {
/* 289 */     boolean changed = false;
/* 290 */     for (int i = array.length; i-- > 0; ) {
/* 291 */       if (add(array[i])) {
/* 292 */         changed = true;
/*     */       }
/*     */     }
/* 295 */     return changed;
/*     */   }
/*     */ 
/*     */   public boolean removeAll(long[] array)
/*     */   {
/* 305 */     boolean changed = false;
/* 306 */     for (int i = array.length; i-- > 0; ) {
/* 307 */       if (remove(array[i])) {
/* 308 */         changed = true;
/*     */       }
/*     */     }
/* 311 */     return changed;
/*     */   }
/*     */ 
/*     */   public boolean retainAll(long[] array)
/*     */   {
/* 322 */     boolean changed = false;
/* 323 */     Arrays.sort(array);
/* 324 */     long[] set = this._set;
/* 325 */     byte[] states = this._states;
/*     */ 
/* 327 */     for (int i = set.length; i-- > 0; ) {
/* 328 */       if ((states[i] == 1) && (Arrays.binarySearch(array, set[i]) < 0)) {
/* 329 */         remove(set[i]);
/* 330 */         changed = true;
/*     */       }
/*     */     }
/* 333 */     return changed;
/*     */   }
/*     */ 
/*     */   private void writeObject(ObjectOutputStream stream) throws IOException
/*     */   {
/* 338 */     stream.defaultWriteObject();
/*     */ 
/* 341 */     stream.writeInt(this._size);
/*     */ 
/* 343 */     SerializationProcedure writeProcedure = new SerializationProcedure(stream);
/* 344 */     if (!forEach(writeProcedure))
/* 345 */       throw writeProcedure.exception;
/*     */   }
/*     */ 
/*     */   private void readObject(ObjectInputStream stream)
/*     */     throws IOException, ClassNotFoundException
/*     */   {
/* 351 */     stream.defaultReadObject();
/*     */ 
/* 353 */     int size = stream.readInt();
/* 354 */     setUp(size);
/* 355 */     while (size-- > 0) {
/* 356 */       long val = stream.readLong();
/* 357 */       add(val);
/*     */     }
/*     */   }
/*     */ 
/*     */   private final class HashProcedure
/*     */     implements TLongProcedure
/*     */   {
/*     */     private int h;
/*     */     private final TLongHashSet this$0;
/*     */ 
/*     */     private HashProcedure()
/*     */     {
/* 238 */       this.this$0 = this$0;
/* 239 */       this.h = 0;
/*     */     }
/*     */     public int getHashCode() {
/* 242 */       return this.h;
/*     */     }
/*     */ 
/*     */     public final boolean execute(long key) {
/* 246 */       this.h += this.this$0._hashingStrategy.computeHashCode(key);
/* 247 */       return true;
/*     */     }
/*     */ 
/*     */     HashProcedure(TLongHashSet.1 x1)
/*     */     {
/* 238 */       this();
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     gnu.trove.TLongHashSet
 * JD-Core Version:    0.6.0
 */