/*     */ package gnu.trove;
/*     */ 
/*     */ import java.io.Serializable;
/*     */ import java.util.AbstractSequentialList;
/*     */ import java.util.ListIterator;
/*     */ import java.util.NoSuchElementException;
/*     */ 
/*     */ public class TLinkedList extends AbstractSequentialList
/*     */   implements Serializable
/*     */ {
/*     */   protected TLinkable _head;
/*     */   protected TLinkable _tail;
/*  67 */   protected int _size = 0;
/*     */ 
/*     */   public ListIterator listIterator(int index)
/*     */   {
/*  90 */     return new IteratorImpl(index);
/*     */   }
/*     */ 
/*     */   public int size()
/*     */   {
/*  99 */     return this._size;
/*     */   }
/*     */ 
/*     */   public void add(int index, Object linkable)
/*     */   {
/* 111 */     if ((index < 0) || (index > size())) {
/* 112 */       throw new IndexOutOfBoundsException("index:" + index);
/*     */     }
/* 114 */     insert(index, linkable);
/*     */   }
/*     */ 
/*     */   public boolean add(Object linkable)
/*     */   {
/* 124 */     insert(this._size, linkable);
/* 125 */     return true;
/*     */   }
/*     */ 
/*     */   public void addFirst(Object linkable)
/*     */   {
/* 134 */     insert(0, linkable);
/*     */   }
/*     */ 
/*     */   public void addLast(Object linkable)
/*     */   {
/* 143 */     insert(size(), linkable);
/*     */   }
/*     */ 
/*     */   public void clear()
/*     */   {
/* 151 */     if (null != this._head) {
/* 152 */       TLinkable link = this._head.getNext();
/* 153 */       while (link != null)
/*     */       {
/* 155 */         TLinkable prev = link.getPrevious();
/* 156 */         prev.setNext(null);
/* 157 */         link.setPrevious(null);
/*     */ 
/* 154 */         link = link.getNext();
/*     */       }
/*     */ 
/* 159 */       this._head = (this._tail = null);
/*     */     }
/* 161 */     this._size = 0;
/*     */   }
/*     */ 
/*     */   public Object[] toArray()
/*     */   {
/* 176 */     Object[] o = new Object[this._size];
/* 177 */     int i = 0;
/* 178 */     for (TLinkable link = this._head; link != null; link = link.getNext()) {
/* 179 */       o[(i++)] = link;
/*     */     }
/* 181 */     return o;
/*     */   }
/*     */ 
/*     */   public Object[] toUnlinkedArray()
/*     */   {
/* 195 */     Object[] o = new Object[this._size];
/* 196 */     int i = 0;
/* 197 */     TLinkable link = this._head; for (TLinkable tmp = null; link != null; i++) {
/* 198 */       o[i] = link;
/* 199 */       tmp = link;
/* 200 */       link = link.getNext();
/* 201 */       tmp.setNext(null);
/* 202 */       tmp.setPrevious(null);
/*     */     }
/* 204 */     this._size = 0;
/* 205 */     this._head = (this._tail = null);
/* 206 */     return o;
/*     */   }
/*     */ 
/*     */   public boolean contains(Object o)
/*     */   {
/* 216 */     for (TLinkable link = this._head; link != null; link = link.getNext()) {
/* 217 */       if (o.equals(link)) {
/* 218 */         return true;
/*     */       }
/*     */     }
/* 221 */     return false;
/*     */   }
/*     */ 
/*     */   public Object getFirst()
/*     */   {
/* 230 */     return this._head;
/*     */   }
/*     */ 
/*     */   public Object getLast()
/*     */   {
/* 239 */     return this._tail;
/*     */   }
/*     */ 
/*     */   public Object removeFirst()
/*     */   {
/* 248 */     TLinkable o = this._head;
/* 249 */     TLinkable n = o.getNext();
/* 250 */     o.setNext(null);
/*     */ 
/* 252 */     if (null != n) {
/* 253 */       n.setPrevious(null);
/*     */     }
/*     */ 
/* 256 */     this._head = n;
/* 257 */     if (--this._size == 0) {
/* 258 */       this._tail = null;
/*     */     }
/* 260 */     return o;
/*     */   }
/*     */ 
/*     */   public Object removeLast()
/*     */   {
/* 269 */     TLinkable o = this._tail;
/* 270 */     TLinkable prev = o.getPrevious();
/* 271 */     o.setPrevious(null);
/*     */ 
/* 273 */     if (null != prev) {
/* 274 */       prev.setNext(null);
/*     */     }
/* 276 */     this._tail = prev;
/* 277 */     if (--this._size == 0) {
/* 278 */       this._head = null;
/*     */     }
/* 280 */     return o;
/*     */   }
/*     */ 
/*     */   protected void insert(int index, Object linkable)
/*     */   {
/* 290 */     TLinkable newLink = (TLinkable)linkable;
/*     */ 
/* 292 */     if (this._size == 0) {
/* 293 */       this._head = (this._tail = newLink);
/* 294 */     } else if (index == 0) {
/* 295 */       newLink.setNext(this._head);
/* 296 */       this._head.setPrevious(newLink);
/* 297 */       this._head = newLink;
/* 298 */     } else if (index == this._size) {
/* 299 */       this._tail.setNext(newLink);
/* 300 */       newLink.setPrevious(this._tail);
/* 301 */       this._tail = newLink;
/*     */     } else {
/* 303 */       TLinkable prior = null; TLinkable post = null;
/*     */ 
/* 308 */       if (index > this._size >> 1)
/*     */       {
/* 310 */         int pos = this._size - 1;
/* 311 */         for (prior = this._tail; pos > index; pos--)
/* 312 */           prior = prior.getPrevious();
/*     */       }
/*     */       else
/*     */       {
/* 316 */         int pos = 0;
/* 317 */         for (prior = this._head; pos < index; pos++) {
/* 318 */           prior = prior.getNext();
/*     */         }
/*     */       }
/* 321 */       post = prior.getNext();
/*     */ 
/* 323 */       newLink.setNext(post);
/* 324 */       newLink.setPrevious(prior);
/*     */ 
/* 326 */       post.setPrevious(newLink);
/* 327 */       prior.setNext(newLink);
/*     */     }
/* 329 */     this._size += 1;
/*     */   }
/*     */ 
/*     */   public boolean remove(Object o)
/*     */   {
/* 342 */     if ((o instanceof TLinkable))
/*     */     {
/* 344 */       TLinkable link = (TLinkable)o;
/*     */ 
/* 346 */       TLinkable p = link.getPrevious();
/* 347 */       TLinkable n = link.getNext();
/*     */ 
/* 349 */       if ((n == null) && (p == null)) {
/* 350 */         this._head = (this._tail = null);
/* 351 */       } else if (n == null)
/*     */       {
/* 353 */         link.setPrevious(null);
/* 354 */         p.setNext(null);
/* 355 */         this._tail = p;
/* 356 */       } else if (p == null)
/*     */       {
/* 358 */         link.setNext(null);
/* 359 */         n.setPrevious(null);
/* 360 */         this._head = n;
/*     */       } else {
/* 362 */         p.setNext(n);
/* 363 */         n.setPrevious(p);
/* 364 */         link.setNext(null);
/* 365 */         link.setPrevious(null);
/*     */       }
/*     */ 
/* 368 */       this._size -= 1;
/* 369 */       return true;
/*     */     }
/* 371 */     return false;
/*     */   }
/*     */ 
/*     */   public void addBefore(TLinkable current, TLinkable newElement)
/*     */   {
/* 385 */     if (current == this._head) {
/* 386 */       addFirst(newElement);
/* 387 */     } else if (current == null) {
/* 388 */       addLast(newElement);
/*     */     } else {
/* 390 */       TLinkable p = current.getPrevious();
/* 391 */       newElement.setNext(current);
/* 392 */       p.setNext(newElement);
/* 393 */       newElement.setPrevious(p);
/* 394 */       current.setPrevious(newElement);
/* 395 */       this._size += 1;
/*     */     }
/*     */   }
/*     */ 
/*     */   protected final class IteratorImpl
/*     */     implements ListIterator
/*     */   {
/* 404 */     private int _nextIndex = 0;
/*     */     private TLinkable _next;
/*     */     private TLinkable _lastReturned;
/*     */ 
/*     */     IteratorImpl(int position)
/*     */     {
/* 415 */       if ((position < 0) || (position > TLinkedList.this._size)) {
/* 416 */         throw new IndexOutOfBoundsException();
/*     */       }
/*     */ 
/* 419 */       this._nextIndex = position;
/* 420 */       if (position == 0) {
/* 421 */         this._next = TLinkedList.this._head;
/* 422 */       } else if (position == TLinkedList.this._size) {
/* 423 */         this._next = null;
/* 424 */       } else if (position < TLinkedList.this._size >> 1) {
/* 425 */         int pos = 0;
/* 426 */         for (this._next = TLinkedList.this._head; pos < position; pos++)
/* 427 */           this._next = this._next.getNext();
/*     */       }
/*     */       else {
/* 430 */         int pos = TLinkedList.this._size - 1;
/* 431 */         for (this._next = TLinkedList.this._tail; pos > position; pos--)
/* 432 */           this._next = this._next.getPrevious();
/*     */       }
/*     */     }
/*     */ 
/*     */     public final void add(Object linkable)
/*     */     {
/* 444 */       this._lastReturned = null;
/* 445 */       this._nextIndex += 1;
/*     */ 
/* 447 */       if (TLinkedList.this._size == 0)
/* 448 */         TLinkedList.this.add(linkable);
/*     */       else
/* 450 */         TLinkedList.this.addBefore(this._next, (TLinkable)linkable);
/*     */     }
/*     */ 
/*     */     public final boolean hasNext()
/*     */     {
/* 460 */       return this._nextIndex != TLinkedList.this._size;
/*     */     }
/*     */ 
/*     */     public final boolean hasPrevious()
/*     */     {
/* 469 */       return this._nextIndex != 0;
/*     */     }
/*     */ 
/*     */     public final Object next()
/*     */     {
/* 480 */       if (this._nextIndex == TLinkedList.this._size) {
/* 481 */         throw new NoSuchElementException();
/*     */       }
/*     */ 
/* 484 */       this._lastReturned = this._next;
/* 485 */       this._next = this._next.getNext();
/* 486 */       this._nextIndex += 1;
/* 487 */       return this._lastReturned;
/*     */     }
/*     */ 
/*     */     public final int nextIndex()
/*     */     {
/* 497 */       return this._nextIndex;
/*     */     }
/*     */ 
/*     */     public final Object previous()
/*     */     {
/* 508 */       if (this._nextIndex == 0) {
/* 509 */         throw new NoSuchElementException();
/*     */       }
/*     */ 
/* 512 */       if (this._nextIndex == TLinkedList.this._size)
/* 513 */         this._lastReturned = (this._next = TLinkedList.this._tail);
/*     */       else {
/* 515 */         this._lastReturned = (this._next = this._next.getPrevious());
/*     */       }
/*     */ 
/* 518 */       this._nextIndex -= 1;
/* 519 */       return this._lastReturned;
/*     */     }
/*     */ 
/*     */     public final int previousIndex()
/*     */     {
/* 528 */       return this._nextIndex - 1;
/*     */     }
/*     */ 
/*     */     public final void remove()
/*     */     {
/* 540 */       if (this._lastReturned == null) {
/* 541 */         throw new IllegalStateException("must invoke next or previous before invoking remove");
/*     */       }
/*     */ 
/* 544 */       if (this._lastReturned != this._next) {
/* 545 */         this._nextIndex -= 1;
/*     */       }
/* 547 */       this._next = this._lastReturned.getNext();
/* 548 */       TLinkedList.this.remove(this._lastReturned);
/* 549 */       this._lastReturned = null;
/*     */     }
/*     */ 
/*     */     public final void set(Object linkable)
/*     */     {
/* 559 */       if (this._lastReturned == null) {
/* 560 */         throw new IllegalStateException();
/*     */       }
/* 562 */       TLinkable l = (TLinkable)linkable;
/*     */ 
/* 566 */       if (this._lastReturned == TLinkedList.this._head) {
/* 567 */         TLinkedList.this._head = l;
/*     */       }
/*     */ 
/* 570 */       if (this._lastReturned == TLinkedList.this._tail) {
/* 571 */         TLinkedList.this._tail = l;
/*     */       }
/*     */ 
/* 574 */       swap(this._lastReturned, l);
/* 575 */       this._lastReturned = l;
/*     */     }
/*     */ 
/*     */     private void swap(TLinkable from, TLinkable to)
/*     */     {
/* 585 */       TLinkable p = from.getPrevious();
/* 586 */       TLinkable n = from.getNext();
/*     */ 
/* 588 */       if (null != p) {
/* 589 */         to.setPrevious(p);
/* 590 */         p.setNext(to);
/*     */       }
/* 592 */       if (null != n) {
/* 593 */         to.setNext(n);
/* 594 */         n.setPrevious(to);
/*     */       }
/* 596 */       from.setNext(null);
/* 597 */       from.setPrevious(null);
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     gnu.trove.TLinkedList
 * JD-Core Version:    0.6.0
 */