/*    */ package gnu.trove;
/*    */ 
/*    */ import java.util.ConcurrentModificationException;
/*    */ import java.util.NoSuchElementException;
/*    */ 
/*    */ abstract class TIterator
/*    */ {
/*    */   protected final THash _hash;
/*    */   protected int _expectedSize;
/*    */   protected int _index;
/*    */ 
/*    */   public TIterator(THash hash)
/*    */   {
/* 45 */     this._hash = hash;
/* 46 */     this._expectedSize = this._hash.size();
/* 47 */     this._index = this._hash.capacity();
/*    */   }
/*    */ 
/*    */   public boolean hasNext()
/*    */   {
/* 57 */     return nextIndex() >= 0;
/*    */   }
/*    */ 
/*    */   public void remove()
/*    */   {
/* 67 */     if (this._expectedSize != this._hash.size()) {
/* 68 */       throw new ConcurrentModificationException();
/*    */     }
/* 70 */     this._hash.removeAt(this._index);
/* 71 */     this._expectedSize -= 1;
/*    */   }
/*    */ 
/*    */   protected final void moveToNextIndex()
/*    */   {
/* 81 */     if ((this._index = nextIndex()) < 0)
/* 82 */       throw new NoSuchElementException();
/*    */   }
/*    */ 
/*    */   protected abstract int nextIndex();
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     gnu.trove.TIterator
 * JD-Core Version:    0.6.0
 */