/*      */ package com.sun.xml.txw2.output;
/*      */ 
/*      */ import java.io.IOException;
/*      */ import java.io.OutputStreamWriter;
/*      */ import java.io.Writer;
/*      */ import java.util.HashMap;
/*      */ import java.util.Iterator;
/*      */ import java.util.Map.Entry;
/*      */ import java.util.Set;
/*      */ import org.xml.sax.Attributes;
/*      */ import org.xml.sax.SAXException;
/*      */ import org.xml.sax.ext.LexicalHandler;
/*      */ import org.xml.sax.helpers.AttributesImpl;
/*      */ import org.xml.sax.helpers.XMLFilterImpl;
/*      */ 
/*      */ public class XMLWriter extends XMLFilterImpl
/*      */   implements LexicalHandler
/*      */ {
/*  409 */   private final HashMap locallyDeclaredPrefix = new HashMap();
/*      */ 
/* 1045 */   private final Attributes EMPTY_ATTS = new AttributesImpl();
/*      */ 
/* 1053 */   private boolean inCDATA = false;
/* 1054 */   private int elementLevel = 0;
/*      */   private Writer output;
/*      */   private String encoding;
/* 1057 */   private boolean writeXmlDecl = true;
/*      */ 
/* 1063 */   private String header = null;
/*      */   private final CharacterEscapeHandler escapeHandler;
/* 1067 */   private boolean startTagIsClosed = true;
/*      */ 
/*      */   public XMLWriter(Writer writer, String encoding, CharacterEscapeHandler _escapeHandler)
/*      */   {
/*  286 */     init(writer, encoding);
/*  287 */     this.escapeHandler = _escapeHandler;
/*      */   }
/*      */ 
/*      */   public XMLWriter(Writer writer, String encoding) {
/*  291 */     this(writer, encoding, DumbEscapeHandler.theInstance);
/*      */   }
/*      */ 
/*      */   private void init(Writer writer, String encoding)
/*      */   {
/*  306 */     setOutput(writer, encoding);
/*      */   }
/*      */ 
/*      */   public void reset()
/*      */   {
/*  337 */     this.elementLevel = 0;
/*  338 */     this.startTagIsClosed = true;
/*      */   }
/*      */ 
/*      */   public void flush()
/*      */     throws IOException
/*      */   {
/*  359 */     this.output.flush();
/*      */   }
/*      */ 
/*      */   public void setOutput(Writer writer, String _encoding)
/*      */   {
/*  372 */     if (writer == null)
/*  373 */       this.output = new OutputStreamWriter(System.out);
/*      */     else {
/*  375 */       this.output = writer;
/*      */     }
/*  377 */     this.encoding = _encoding;
/*      */   }
/*      */ 
/*      */   public void setEncoding(String encoding) {
/*  381 */     this.encoding = encoding;
/*      */   }
/*      */ 
/*      */   public void setXmlDecl(boolean _writeXmlDecl)
/*      */   {
/*  391 */     this.writeXmlDecl = _writeXmlDecl;
/*      */   }
/*      */ 
/*      */   public void setHeader(String _header)
/*      */   {
/*  405 */     this.header = _header;
/*      */   }
/*      */ 
/*      */   public void startPrefixMapping(String prefix, String uri)
/*      */     throws SAXException
/*      */   {
/*  411 */     this.locallyDeclaredPrefix.put(prefix, uri);
/*      */   }
/*      */ 
/*      */   public void startDocument()
/*      */     throws SAXException
/*      */   {
/*      */     try
/*      */     {
/*  433 */       reset();
/*      */ 
/*  435 */       if (this.writeXmlDecl) {
/*  436 */         String e = "";
/*  437 */         if (this.encoding != null) {
/*  438 */           e = " encoding=\"" + this.encoding + "\"";
/*      */         }
/*  440 */         write("<?xml version=\"1.0\"" + e + " standalone=\"yes\"?>\n");
/*      */       }
/*      */ 
/*  443 */       if (this.header != null) {
/*  444 */         write(this.header);
/*      */       }
/*  446 */       super.startDocument();
/*      */     } catch (IOException e) {
/*  448 */       throw new SAXException(e);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void endDocument()
/*      */     throws SAXException
/*      */   {
/*      */     try
/*      */     {
/*  467 */       if (!this.startTagIsClosed) {
/*  468 */         write("/>");
/*  469 */         this.startTagIsClosed = true;
/*      */       }
/*  471 */       write('\n');
/*  472 */       super.endDocument();
/*      */       try {
/*  474 */         flush();
/*      */       } catch (IOException e) {
/*  476 */         throw new SAXException(e);
/*      */       }
/*      */     } catch (IOException e) {
/*  479 */       throw new SAXException(e);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void startElement(String uri, String localName, String qName, Attributes atts)
/*      */     throws SAXException
/*      */   {
/*      */     try
/*      */     {
/*  508 */       if (!this.startTagIsClosed) {
/*  509 */         write(">");
/*      */       }
/*  511 */       this.elementLevel += 1;
/*      */ 
/*  514 */       write('<');
/*  515 */       writeName(uri, localName, qName, true);
/*  516 */       writeAttributes(atts);
/*      */ 
/*  519 */       if (!this.locallyDeclaredPrefix.isEmpty()) {
/*  520 */         Iterator itr = this.locallyDeclaredPrefix.entrySet().iterator();
/*  521 */         while (itr.hasNext()) {
/*  522 */           Map.Entry e = (Map.Entry)itr.next();
/*  523 */           String p = (String)e.getKey();
/*  524 */           String u = (String)e.getValue();
/*  525 */           if (u == null) {
/*  526 */             u = "";
/*      */           }
/*  528 */           write(' ');
/*  529 */           if ("".equals(p)) {
/*  530 */             write("xmlns=\"");
/*      */           } else {
/*  532 */             write("xmlns:");
/*  533 */             write(p);
/*  534 */             write("=\"");
/*      */           }
/*  536 */           char[] ch = u.toCharArray();
/*  537 */           writeEsc(ch, 0, ch.length, true);
/*  538 */           write('"');
/*      */         }
/*  540 */         this.locallyDeclaredPrefix.clear();
/*      */       }
/*      */ 
/*  547 */       super.startElement(uri, localName, qName, atts);
/*  548 */       this.startTagIsClosed = false;
/*      */     } catch (IOException e) {
/*  550 */       throw new SAXException(e);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void endElement(String uri, String localName, String qName)
/*      */     throws SAXException
/*      */   {
/*      */     try
/*      */     {
/*  577 */       if (this.startTagIsClosed) {
/*  578 */         write("</");
/*  579 */         writeName(uri, localName, qName, true);
/*  580 */         write('>');
/*      */       } else {
/*  582 */         write("/>");
/*  583 */         this.startTagIsClosed = true;
/*      */       }
/*  585 */       if (this.elementLevel == 1) {
/*  586 */         write('\n');
/*      */       }
/*  588 */       super.endElement(uri, localName, qName);
/*      */ 
/*  590 */       this.elementLevel -= 1;
/*      */     } catch (IOException e) {
/*  592 */       throw new SAXException(e);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void characters(char[] ch, int start, int len)
/*      */     throws SAXException
/*      */   {
/*      */     try
/*      */     {
/*  614 */       if (!this.startTagIsClosed) {
/*  615 */         write('>');
/*  616 */         this.startTagIsClosed = true;
/*      */       }
/*  618 */       if (this.inCDATA)
/*  619 */         this.output.write(ch, start, len);
/*      */       else
/*  621 */         writeEsc(ch, start, len, false);
/*  622 */       super.characters(ch, start, len);
/*      */     } catch (IOException e) {
/*  624 */       throw new SAXException(e);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void ignorableWhitespace(char[] ch, int start, int length)
/*      */     throws SAXException
/*      */   {
/*      */     try
/*      */     {
/*  646 */       writeEsc(ch, start, length, false);
/*  647 */       super.ignorableWhitespace(ch, start, length);
/*      */     } catch (IOException e) {
/*  649 */       throw new SAXException(e);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void processingInstruction(String target, String data)
/*      */     throws SAXException
/*      */   {
/*      */     try
/*      */     {
/*  671 */       if (!this.startTagIsClosed) {
/*  672 */         write('>');
/*  673 */         this.startTagIsClosed = true;
/*      */       }
/*  675 */       write("<?");
/*  676 */       write(target);
/*  677 */       write(' ');
/*  678 */       write(data);
/*  679 */       write("?>");
/*  680 */       if (this.elementLevel < 1) {
/*  681 */         write('\n');
/*      */       }
/*  683 */       super.processingInstruction(target, data);
/*      */     } catch (IOException e) {
/*  685 */       throw new SAXException(e);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void startElement(String uri, String localName)
/*      */     throws SAXException
/*      */   {
/*  716 */     startElement(uri, localName, "", this.EMPTY_ATTS);
/*      */   }
/*      */ 
/*      */   public void startElement(String localName)
/*      */     throws SAXException
/*      */   {
/*  738 */     startElement("", localName, "", this.EMPTY_ATTS);
/*      */   }
/*      */ 
/*      */   public void endElement(String uri, String localName)
/*      */     throws SAXException
/*      */   {
/*  759 */     endElement(uri, localName, "");
/*      */   }
/*      */ 
/*      */   public void endElement(String localName)
/*      */     throws SAXException
/*      */   {
/*  780 */     endElement("", localName, "");
/*      */   }
/*      */ 
/*      */   public void dataElement(String uri, String localName, String qName, Attributes atts, String content)
/*      */     throws SAXException
/*      */   {
/*  814 */     startElement(uri, localName, qName, atts);
/*  815 */     characters(content);
/*  816 */     endElement(uri, localName, qName);
/*      */   }
/*      */ 
/*      */   public void dataElement(String uri, String localName, String content)
/*      */     throws SAXException
/*      */   {
/*  847 */     dataElement(uri, localName, "", this.EMPTY_ATTS, content);
/*      */   }
/*      */ 
/*      */   public void dataElement(String localName, String content)
/*      */     throws SAXException
/*      */   {
/*  878 */     dataElement("", localName, "", this.EMPTY_ATTS, content);
/*      */   }
/*      */ 
/*      */   public void characters(String data)
/*      */     throws SAXException
/*      */   {
/*      */     try
/*      */     {
/*  897 */       if (!this.startTagIsClosed) {
/*  898 */         write('>');
/*  899 */         this.startTagIsClosed = true;
/*      */       }
/*  901 */       char[] ch = data.toCharArray();
/*  902 */       characters(ch, 0, ch.length);
/*      */     } catch (IOException e) {
/*  904 */       throw new SAXException(e);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void startDTD(String name, String publicId, String systemId) throws SAXException
/*      */   {
/*      */   }
/*      */ 
/*      */   public void endDTD() throws SAXException {
/*      */   }
/*      */ 
/*      */   public void startEntity(String name) throws SAXException {
/*      */   }
/*      */ 
/*      */   public void endEntity(String name) throws SAXException {
/*      */   }
/*      */ 
/*      */   public void startCDATA() throws SAXException {
/*      */     try {
/*  923 */       if (!this.startTagIsClosed) {
/*  924 */         write('>');
/*  925 */         this.startTagIsClosed = true;
/*      */       }
/*  927 */       write("<![CDATA[");
/*  928 */       this.inCDATA = true;
/*      */     } catch (IOException e) {
/*  930 */       new SAXException(e);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void endCDATA() throws SAXException {
/*      */     try {
/*  936 */       this.inCDATA = false;
/*  937 */       write("]]>");
/*      */     } catch (IOException e) {
/*  939 */       throw new SAXException(e);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void comment(char[] ch, int start, int length) throws SAXException {
/*      */     try {
/*  945 */       this.output.write("<!--");
/*  946 */       this.output.write(ch, start, length);
/*  947 */       this.output.write("-->");
/*      */     } catch (IOException e) {
/*  949 */       throw new SAXException(e);
/*      */     }
/*      */   }
/*      */ 
/*      */   private void write(char c)
/*      */     throws IOException
/*      */   {
/*  968 */     this.output.write(c);
/*      */   }
/*      */ 
/*      */   private void write(String s)
/*      */     throws IOException
/*      */   {
/*  976 */     this.output.write(s);
/*      */   }
/*      */ 
/*      */   private void writeAttributes(Attributes atts)
/*      */     throws IOException, SAXException
/*      */   {
/*  991 */     int len = atts.getLength();
/*  992 */     for (int i = 0; i < len; i++) {
/*  993 */       char[] ch = atts.getValue(i).toCharArray();
/*  994 */       write(' ');
/*  995 */       writeName(atts.getURI(i), atts.getLocalName(i), atts.getQName(i), false);
/*      */ 
/*  997 */       write("=\"");
/*  998 */       writeEsc(ch, 0, ch.length, true);
/*  999 */       write('"');
/*      */     }
/*      */   }
/*      */ 
/*      */   private void writeEsc(char[] ch, int start, int length, boolean isAttVal)
/*      */     throws SAXException, IOException
/*      */   {
/* 1019 */     this.escapeHandler.escape(ch, start, length, isAttVal, this.output);
/*      */   }
/*      */ 
/*      */   private void writeName(String uri, String localName, String qName, boolean isElement)
/*      */     throws IOException
/*      */   {
/* 1036 */     write(qName);
/*      */   }
/*      */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     com.sun.xml.txw2.output.XMLWriter
 * JD-Core Version:    0.6.0
 */