/*     */ package com.sun.xml.txw2.output;
/*     */ 
/*     */ import com.sun.xml.txw2.TxwException;
/*     */ import javax.xml.stream.XMLStreamException;
/*     */ import javax.xml.stream.XMLStreamWriter;
/*     */ 
/*     */ public class StaxSerializer
/*     */   implements XmlSerializer
/*     */ {
/*     */   private final XMLStreamWriter out;
/*     */ 
/*     */   public StaxSerializer(XMLStreamWriter writer)
/*     */   {
/*  40 */     this(writer, true);
/*     */   }
/*     */ 
/*     */   public StaxSerializer(XMLStreamWriter writer, boolean indenting) {
/*  44 */     if (indenting)
/*  45 */       writer = new IndentingXMLStreamWriter(writer);
/*  46 */     this.out = writer;
/*     */   }
/*     */ 
/*     */   public void startDocument() {
/*     */     try {
/*  51 */       this.out.writeStartDocument();
/*     */     } catch (XMLStreamException e) {
/*  53 */       throw new TxwException(e);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void beginStartTag(String uri, String localName, String prefix) {
/*     */     try {
/*  59 */       this.out.writeStartElement(prefix, localName, uri);
/*     */     } catch (XMLStreamException e) {
/*  61 */       throw new TxwException(e);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void writeAttribute(String uri, String localName, String prefix, StringBuilder value) {
/*     */     try {
/*  67 */       this.out.writeAttribute(prefix, uri, localName, value.toString());
/*     */     } catch (XMLStreamException e) {
/*  69 */       throw new TxwException(e);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void writeXmlns(String prefix, String uri) {
/*     */     try {
/*  75 */       if (prefix.length() == 0)
/*  76 */         this.out.setDefaultNamespace(uri);
/*     */       else {
/*  78 */         this.out.setPrefix(prefix, uri);
/*     */       }
/*     */ 
/*  82 */       this.out.writeNamespace(prefix, uri);
/*     */     } catch (XMLStreamException e) {
/*  84 */       throw new TxwException(e);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void endStartTag(String uri, String localName, String prefix)
/*     */   {
/*     */   }
/*     */ 
/*     */   public void endTag() {
/*     */     try {
/*  94 */       this.out.writeEndElement();
/*     */     } catch (XMLStreamException e) {
/*  96 */       throw new TxwException(e);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void text(StringBuilder text) {
/*     */     try {
/* 102 */       this.out.writeCharacters(text.toString());
/*     */     } catch (XMLStreamException e) {
/* 104 */       throw new TxwException(e);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void cdata(StringBuilder text) {
/*     */     try {
/* 110 */       this.out.writeCData(text.toString());
/*     */     } catch (XMLStreamException e) {
/* 112 */       throw new TxwException(e);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void comment(StringBuilder comment) {
/*     */     try {
/* 118 */       this.out.writeComment(comment.toString());
/*     */     } catch (XMLStreamException e) {
/* 120 */       throw new TxwException(e);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void endDocument() {
/*     */     try {
/* 126 */       this.out.writeEndDocument();
/* 127 */       this.out.flush();
/*     */     } catch (XMLStreamException e) {
/* 129 */       throw new TxwException(e);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void flush() {
/*     */     try {
/* 135 */       this.out.flush();
/*     */     } catch (XMLStreamException e) {
/* 137 */       throw new TxwException(e);
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     com.sun.xml.txw2.output.StaxSerializer
 * JD-Core Version:    0.6.0
 */