/*      */ package com.sun.xml.bind.v2.runtime.unmarshaller;
/*      */ 
/*      */ import com.sun.istack.NotNull;
/*      */ import com.sun.istack.Nullable;
/*      */ import com.sun.istack.SAXParseException2;
/*      */ import com.sun.xml.bind.IDResolver;
/*      */ import com.sun.xml.bind.api.AccessorException;
/*      */ import com.sun.xml.bind.api.ClassResolver;
/*      */ import com.sun.xml.bind.unmarshaller.InfosetScanner;
/*      */ import com.sun.xml.bind.v2.ClassFactory;
/*      */ import com.sun.xml.bind.v2.runtime.AssociationMap;
/*      */ import com.sun.xml.bind.v2.runtime.Coordinator;
/*      */ import com.sun.xml.bind.v2.runtime.JAXBContextImpl;
/*      */ import com.sun.xml.bind.v2.runtime.JaxBeanInfo;
/*      */ import java.lang.reflect.InvocationTargetException;
/*      */ import java.lang.reflect.Method;
/*      */ import java.util.ArrayList;
/*      */ import java.util.Collection;
/*      */ import java.util.Collections;
/*      */ import java.util.HashMap;
/*      */ import java.util.Iterator;
/*      */ import java.util.List;
/*      */ import java.util.Map;
/*      */ import java.util.concurrent.Callable;
/*      */ import javax.xml.bind.JAXBElement;
/*      */ import javax.xml.bind.UnmarshalException;
/*      */ import javax.xml.bind.ValidationEvent;
/*      */ import javax.xml.bind.ValidationEventHandler;
/*      */ import javax.xml.bind.ValidationEventLocator;
/*      */ import javax.xml.bind.helpers.ValidationEventImpl;
/*      */ import javax.xml.namespace.NamespaceContext;
/*      */ import javax.xml.namespace.QName;
/*      */ import org.xml.sax.ErrorHandler;
/*      */ import org.xml.sax.SAXException;
/*      */ import org.xml.sax.helpers.LocatorImpl;
/*      */ 
/*      */ public final class UnmarshallingContext extends Coordinator
/*      */   implements NamespaceContext, ValidationEventHandler, ErrorHandler, XmlVisitor, XmlVisitor.TextPredictor
/*      */ {
/*      */   private final State root;
/*      */   private State current;
/*      */   private static final LocatorEx DUMMY_INSTANCE;
/*      */ 
/*      */   @NotNull
/*  112 */   private LocatorEx locator = DUMMY_INSTANCE;
/*      */   private Object result;
/*      */   private JaxBeanInfo expectedType;
/*      */   private IDResolver idResolver;
/*  141 */   private boolean isUnmarshalInProgress = true;
/*  142 */   private boolean aborted = false;
/*      */   public final UnmarshallerImpl parent;
/*      */   private final AssociationMap assoc;
/*      */   private boolean isInplaceMode;
/*      */   private InfosetScanner scanner;
/*      */   private Object currentElement;
/*      */   private NamespaceContext environmentNamespaceContext;
/*      */ 
/*      */   @Nullable
/*      */   public ClassResolver classResolver;
/*      */   private final Map<Class, Factory> factories;
/*      */   private Patcher[] patchers;
/*      */   private int patchersLen;
/*      */   private String[] nsBind;
/*      */   private int nsLen;
/*      */   private Scope[] scopes;
/*      */   private int scopeTop;
/*      */   private static final Loader DEFAULT_ROOT_LOADER;
/*      */   private static final Loader EXPECTED_TYPE_ROOT_LOADER;
/*      */ 
/*      */   public UnmarshallingContext(UnmarshallerImpl _parent, AssociationMap assoc)
/*      */   {
/*  370 */     this.factories = new HashMap();
/*      */ 
/*  672 */     this.patchers = null;
/*  673 */     this.patchersLen = 0;
/*      */ 
/*  757 */     this.nsBind = new String[16];
/*  758 */     this.nsLen = 0;
/*      */ 
/*  898 */     this.scopes = new Scope[16];
/*      */ 
/*  902 */     this.scopeTop = 0;
/*      */ 
/*  905 */     for (int i = 0; i < this.scopes.length; i++)
/*  906 */       this.scopes[i] = new Scope(this);
/*  301 */     this.parent = _parent;
/*  302 */     this.assoc = assoc;
/*  303 */     this.root = (this.current = new State(null, null));
/*  304 */     allocateMoreStates();
/*      */   }
/*      */ 
/*      */   public void reset(InfosetScanner scanner, boolean isInplaceMode, JaxBeanInfo expectedType, IDResolver idResolver) {
/*  308 */     this.scanner = scanner;
/*  309 */     this.isInplaceMode = isInplaceMode;
/*  310 */     this.expectedType = expectedType;
/*  311 */     this.idResolver = idResolver;
/*      */   }
/*      */ 
/*      */   public JAXBContextImpl getJAXBContext() {
/*  315 */     return this.parent.context;
/*      */   }
/*      */ 
/*      */   public State getCurrentState() {
/*  319 */     return this.current;
/*      */   }
/*      */ 
/*      */   public Loader selectRootLoader(State state, TagName tag)
/*      */     throws SAXException
/*      */   {
/*      */     try
/*      */     {
/*  331 */       Loader l = getJAXBContext().selectRootLoader(state, tag);
/*  332 */       if (l != null) return l;
/*      */ 
/*  334 */       if (this.classResolver != null) {
/*  335 */         Class clazz = this.classResolver.resolveElementName(tag.uri, tag.local);
/*  336 */         if (clazz != null) {
/*  337 */           JAXBContextImpl enhanced = getJAXBContext().createAugmented(clazz);
/*  338 */           JaxBeanInfo bi = enhanced.getBeanInfo(clazz);
/*  339 */           return bi.getLoader(enhanced, true);
/*      */         }
/*      */       }
/*      */     } catch (RuntimeException e) {
/*  343 */       throw e;
/*      */     } catch (Exception e) {
/*  345 */       handleError(e);
/*      */     }
/*      */ 
/*  348 */     return null;
/*      */   }
/*      */ 
/*      */   private void allocateMoreStates()
/*      */   {
/*  360 */     assert (this.current.next == null);
/*      */ 
/*  362 */     State s = this.current;
/*  363 */     for (int i = 0; i < 8; i++)
/*  364 */       s = new State(s, null);
/*      */   }
/*      */ 
/*      */   public void setFactories(Object factoryInstances)
/*      */   {
/*  373 */     this.factories.clear();
/*  374 */     if (factoryInstances == null) {
/*  375 */       return;
/*      */     }
/*  377 */     if ((factoryInstances instanceof Object[]))
/*  378 */       for (Object factory : (Object[])(Object[])factoryInstances)
/*      */       {
/*  380 */         addFactory(factory);
/*      */       }
/*      */     else
/*  383 */       addFactory(factoryInstances);
/*      */   }
/*      */ 
/*      */   private void addFactory(Object factory)
/*      */   {
/*  388 */     for (Method m : factory.getClass().getMethods())
/*      */     {
/*  390 */       if (!m.getName().startsWith("create"))
/*      */         continue;
/*  392 */       if (m.getParameterTypes().length > 0) {
/*      */         continue;
/*      */       }
/*  395 */       Class type = m.getReturnType();
/*      */ 
/*  397 */       this.factories.put(type, new Factory(factory, m));
/*      */     }
/*      */   }
/*      */ 
/*      */   public void startDocument(LocatorEx locator, NamespaceContext nsContext) throws SAXException {
/*  402 */     if (locator != null)
/*  403 */       this.locator = locator;
/*  404 */     this.environmentNamespaceContext = nsContext;
/*      */ 
/*  406 */     this.result = null;
/*  407 */     this.current = this.root;
/*      */ 
/*  409 */     this.patchersLen = 0;
/*  410 */     this.aborted = false;
/*  411 */     this.isUnmarshalInProgress = true;
/*  412 */     this.nsLen = 0;
/*      */ 
/*  414 */     setThreadAffinity();
/*      */ 
/*  416 */     if (this.expectedType != null)
/*  417 */       this.root.loader = EXPECTED_TYPE_ROOT_LOADER;
/*      */     else {
/*  419 */       this.root.loader = DEFAULT_ROOT_LOADER;
/*      */     }
/*  421 */     this.idResolver.startDocument(this);
/*      */   }
/*      */ 
/*      */   public void startElement(TagName tagName) throws SAXException {
/*  425 */     pushCoordinator();
/*      */     try {
/*  427 */       _startElement(tagName);
/*      */     } finally {
/*  429 */       popCoordinator();
/*      */     }
/*      */   }
/*      */ 
/*      */   private void _startElement(TagName tagName)
/*      */     throws SAXException
/*      */   {
/*  439 */     if (this.assoc != null) {
/*  440 */       this.currentElement = this.scanner.getCurrentElement();
/*      */     }
/*  442 */     Loader h = this.current.loader;
/*  443 */     this.current.push();
/*      */ 
/*  446 */     h.childElement(this.current, tagName);
/*  447 */     assert (this.current.loader != null);
/*      */ 
/*  449 */     this.current.loader.startElement(this.current, tagName);
/*      */   }
/*      */ 
/*      */   public void text(CharSequence pcdata) throws SAXException {
/*  453 */     State cur = this.current;
/*  454 */     pushCoordinator();
/*      */     try {
/*  456 */       if ((cur.elementDefaultValue != null) && 
/*  457 */         (pcdata.length() == 0))
/*      */       {
/*  459 */         pcdata = cur.elementDefaultValue;
/*      */       }
/*      */ 
/*  462 */       cur.loader.text(cur, pcdata);
/*      */     } finally {
/*  464 */       popCoordinator();
/*      */     }
/*      */   }
/*      */ 
/*      */   public final void endElement(TagName tagName) throws SAXException {
/*  469 */     pushCoordinator();
/*      */     try {
/*  471 */       State child = this.current;
/*      */ 
/*  474 */       child.loader.leaveElement(child, tagName);
/*      */ 
/*  477 */       Object target = child.target;
/*  478 */       Receiver recv = child.receiver;
/*  479 */       Intercepter intercepter = child.intercepter;
/*  480 */       child.pop();
/*      */ 
/*  483 */       if (intercepter != null)
/*  484 */         target = intercepter.intercept(this.current, target);
/*  485 */       if (recv != null)
/*  486 */         recv.receive(this.current, target);
/*      */     } finally {
/*  488 */       popCoordinator();
/*      */     }
/*      */   }
/*      */ 
/*      */   public void endDocument() throws SAXException {
/*  493 */     runPatchers();
/*  494 */     this.idResolver.endDocument();
/*      */ 
/*  496 */     this.isUnmarshalInProgress = false;
/*  497 */     this.currentElement = null;
/*  498 */     this.locator = DUMMY_INSTANCE;
/*  499 */     this.environmentNamespaceContext = null;
/*      */ 
/*  502 */     assert (this.root == this.current);
/*      */ 
/*  504 */     resetThreadAffinity();
/*      */   }
/*      */ 
/*      */   @Deprecated
/*      */   public boolean expectText()
/*      */   {
/*  512 */     return this.current.loader.expectText;
/*      */   }
/*      */ 
/*      */   @Deprecated
/*      */   public XmlVisitor.TextPredictor getPredictor()
/*      */   {
/*  520 */     return this;
/*      */   }
/*      */ 
/*      */   public UnmarshallingContext getContext() {
/*  524 */     return this;
/*      */   }
/*      */ 
/*      */   public Object getResult()
/*      */     throws UnmarshalException
/*      */   {
/*  531 */     if (this.isUnmarshalInProgress) {
/*  532 */       throw new IllegalStateException();
/*      */     }
/*  534 */     if (!this.aborted) return this.result;
/*      */ 
/*  537 */     throw new UnmarshalException((String)null);
/*      */   }
/*      */ 
/*      */   public Object createInstance(Class<?> clazz)
/*      */     throws SAXException
/*      */   {
/*  545 */     if (!this.factories.isEmpty()) {
/*  546 */       Factory factory = (Factory)this.factories.get(clazz);
/*  547 */       if (factory != null)
/*  548 */         return factory.createInstance();
/*      */     }
/*  550 */     return ClassFactory.create(clazz);
/*      */   }
/*      */ 
/*      */   public Object createInstance(JaxBeanInfo beanInfo)
/*      */     throws SAXException
/*      */   {
/*  558 */     if (!this.factories.isEmpty()) {
/*  559 */       Factory factory = (Factory)this.factories.get(beanInfo.jaxbType);
/*  560 */       if (factory != null)
/*  561 */         return factory.createInstance();
/*      */     }
/*      */     try {
/*  564 */       return beanInfo.createInstance(this);
/*      */     } catch (IllegalAccessException e) {
/*  566 */       Loader.reportError("Unable to create an instance of " + beanInfo.jaxbType.getName(), e, false);
/*      */     } catch (InvocationTargetException e) {
/*  568 */       Loader.reportError("Unable to create an instance of " + beanInfo.jaxbType.getName(), e, false);
/*      */     } catch (InstantiationException e) {
/*  570 */       Loader.reportError("Unable to create an instance of " + beanInfo.jaxbType.getName(), e, false);
/*      */     }
/*  572 */     return null;
/*      */   }
/*      */ 
/*      */   public void handleEvent(ValidationEvent event, boolean canRecover)
/*      */     throws SAXException
/*      */   {
/*  594 */     ValidationEventHandler eventHandler = this.parent.getEventHandler();
/*      */ 
/*  596 */     boolean recover = eventHandler.handleEvent(event);
/*      */ 
/*  600 */     if (!recover) this.aborted = true;
/*      */ 
/*  602 */     if ((!canRecover) || (!recover))
/*  603 */       throw new SAXParseException2(event.getMessage(), this.locator, new UnmarshalException(event.getMessage(), event.getLinkedException()));
/*      */   }
/*      */ 
/*      */   public boolean handleEvent(ValidationEvent event)
/*      */   {
/*      */     try
/*      */     {
/*  612 */       boolean recover = this.parent.getEventHandler().handleEvent(event);
/*  613 */       if (!recover) this.aborted = true;
/*  614 */       return recover;
/*      */     }
/*      */     catch (RuntimeException re) {
/*      */     }
/*  618 */     return false;
/*      */   }
/*      */ 
/*      */   public void handleError(Exception e)
/*      */     throws SAXException
/*      */   {
/*  628 */     handleError(e, true);
/*      */   }
/*      */ 
/*      */   public void handleError(Exception e, boolean canRecover) throws SAXException {
/*  632 */     handleEvent(new ValidationEventImpl(1, e.getMessage(), this.locator.getLocation(), e), canRecover);
/*      */   }
/*      */ 
/*      */   public void handleError(String msg) {
/*  636 */     handleEvent(new ValidationEventImpl(1, msg, this.locator.getLocation()));
/*      */   }
/*      */ 
/*      */   protected ValidationEventLocator getLocation() {
/*  640 */     return this.locator.getLocation();
/*      */   }
/*      */ 
/*      */   public LocatorEx getLocator()
/*      */   {
/*  649 */     return this.locator;
/*      */   }
/*      */ 
/*      */   public void errorUnresolvedIDREF(Object bean, String idref, LocatorEx loc)
/*      */     throws SAXException
/*      */   {
/*  655 */     handleEvent(new ValidationEventImpl(1, Messages.UNRESOLVED_IDREF.format(new Object[] { idref }), loc.getLocation()), true);
/*      */   }
/*      */ 
/*      */   public void addPatcher(Patcher job)
/*      */   {
/*  685 */     if (this.patchers == null)
/*  686 */       this.patchers = new Patcher[32];
/*  687 */     if (this.patchers.length == this.patchersLen) {
/*  688 */       Patcher[] buf = new Patcher[this.patchersLen * 2];
/*  689 */       System.arraycopy(this.patchers, 0, buf, 0, this.patchersLen);
/*  690 */       this.patchers = buf;
/*      */     }
/*  692 */     this.patchers[(this.patchersLen++)] = job;
/*      */   }
/*      */ 
/*      */   private void runPatchers() throws SAXException
/*      */   {
/*  697 */     if (this.patchers != null)
/*  698 */       for (int i = 0; i < this.patchersLen; i++) {
/*  699 */         this.patchers[i].run();
/*  700 */         this.patchers[i] = null;
/*      */       }
/*      */   }
/*      */ 
/*      */   public String addToIdTable(String id)
/*      */     throws SAXException
/*      */   {
/*  732 */     Object o = this.current.target;
/*  733 */     if (o == null)
/*  734 */       o = this.current.prev.target;
/*  735 */     this.idResolver.bind(id, o);
/*  736 */     return id;
/*      */   }
/*      */ 
/*      */   public Callable getObjectFromId(String id, Class targetType)
/*      */     throws SAXException
/*      */   {
/*  749 */     return this.idResolver.resolve(id, targetType);
/*      */   }
/*      */ 
/*      */   public void startPrefixMapping(String prefix, String uri)
/*      */   {
/*  761 */     if (this.nsBind.length == this.nsLen)
/*      */     {
/*  763 */       String[] n = new String[this.nsLen * 2];
/*  764 */       System.arraycopy(this.nsBind, 0, n, 0, this.nsLen);
/*  765 */       this.nsBind = n;
/*      */     }
/*  767 */     this.nsBind[(this.nsLen++)] = prefix;
/*  768 */     this.nsBind[(this.nsLen++)] = uri;
/*      */   }
/*      */   public void endPrefixMapping(String prefix) {
/*  771 */     this.nsLen -= 2;
/*      */   }
/*      */   private String resolveNamespacePrefix(String prefix) {
/*  774 */     if (prefix.equals("xml")) {
/*  775 */       return "http://www.w3.org/XML/1998/namespace";
/*      */     }
/*  777 */     for (int i = this.nsLen - 2; i >= 0; i -= 2) {
/*  778 */       if (prefix.equals(this.nsBind[i])) {
/*  779 */         return this.nsBind[(i + 1)];
/*      */       }
/*      */     }
/*  782 */     if (this.environmentNamespaceContext != null)
/*      */     {
/*  784 */       return this.environmentNamespaceContext.getNamespaceURI(prefix.intern());
/*      */     }
/*      */ 
/*  788 */     if (prefix.equals("")) {
/*  789 */       return "";
/*      */     }
/*      */ 
/*  792 */     return null;
/*      */   }
/*      */ 
/*      */   public String[] getNewlyDeclaredPrefixes()
/*      */   {
/*  803 */     return getPrefixList(this.current.prev.numNsDecl);
/*      */   }
/*      */ 
/*      */   public String[] getAllDeclaredPrefixes()
/*      */   {
/*  814 */     return getPrefixList(0);
/*      */   }
/*      */ 
/*      */   private String[] getPrefixList(int startIndex) {
/*  818 */     int size = (this.current.numNsDecl - startIndex) / 2;
/*  819 */     String[] r = new String[size];
/*  820 */     for (int i = 0; i < r.length; i++)
/*  821 */       r[i] = this.nsBind[(startIndex + i * 2)];
/*  822 */     return r;
/*      */   }
/*      */ 
/*      */   public Iterator<String> getPrefixes(String uri)
/*      */   {
/*  833 */     return Collections.unmodifiableList(getAllPrefixesInList(uri)).iterator();
/*      */   }
/*      */ 
/*      */   private List<String> getAllPrefixesInList(String uri)
/*      */   {
/*  838 */     List a = new ArrayList();
/*      */ 
/*  840 */     if (uri == null)
/*  841 */       throw new IllegalArgumentException();
/*  842 */     if (uri.equals("http://www.w3.org/XML/1998/namespace")) {
/*  843 */       a.add("xml");
/*  844 */       return a;
/*      */     }
/*  846 */     if (uri.equals("http://www.w3.org/2000/xmlns/")) {
/*  847 */       a.add("xmlns");
/*  848 */       return a;
/*      */     }
/*      */ 
/*  851 */     for (int i = this.nsLen - 2; i >= 0; i -= 2) {
/*  852 */       if ((!uri.equals(this.nsBind[(i + 1)])) || 
/*  853 */         (!getNamespaceURI(this.nsBind[i]).equals(this.nsBind[(i + 1)])))
/*      */         continue;
/*  855 */       a.add(this.nsBind[i]);
/*      */     }
/*  857 */     return a;
/*      */   }
/*      */ 
/*      */   public String getPrefix(String uri) {
/*  861 */     if (uri == null)
/*  862 */       throw new IllegalArgumentException();
/*  863 */     if (uri.equals("http://www.w3.org/XML/1998/namespace"))
/*  864 */       return "xml";
/*  865 */     if (uri.equals("http://www.w3.org/2000/xmlns/")) {
/*  866 */       return "xmlns";
/*      */     }
/*  868 */     for (int i = this.nsLen - 2; i >= 0; i -= 2)
/*  869 */       if ((uri.equals(this.nsBind[(i + 1)])) && 
/*  870 */         (getNamespaceURI(this.nsBind[i]).equals(this.nsBind[(i + 1)])))
/*      */       {
/*  872 */         return this.nsBind[i];
/*      */       }
/*  874 */     if (this.environmentNamespaceContext != null) {
/*  875 */       return this.environmentNamespaceContext.getPrefix(uri);
/*      */     }
/*  877 */     return null;
/*      */   }
/*      */ 
/*      */   public String getNamespaceURI(String prefix) {
/*  881 */     if (prefix == null)
/*  882 */       throw new IllegalArgumentException();
/*  883 */     if (prefix.equals("xmlns")) {
/*  884 */       return "http://www.w3.org/2000/xmlns/";
/*      */     }
/*  886 */     return resolveNamespacePrefix(prefix);
/*      */   }
/*      */ 
/*      */   public void startScope(int frameSize)
/*      */   {
/*  925 */     this.scopeTop += frameSize;
/*      */ 
/*  928 */     if (this.scopeTop >= this.scopes.length) {
/*  929 */       Scope[] s = new Scope[Math.max(this.scopeTop + 1, this.scopes.length * 2)];
/*  930 */       System.arraycopy(this.scopes, 0, s, 0, this.scopes.length);
/*  931 */       for (int i = this.scopes.length; i < s.length; i++)
/*  932 */         s[i] = new Scope(this);
/*  933 */       this.scopes = s;
/*      */     }
/*      */   }
/*      */ 
/*      */   public void endScope(int frameSize)
/*      */     throws SAXException
/*      */   {
/*      */     try
/*      */     {
/*  949 */       for (; frameSize > 0; this.scopeTop -= 1) {
/*  950 */         this.scopes[this.scopeTop].finish();
/*      */ 
/*  949 */         frameSize--;
/*      */       }
/*      */     } catch (AccessorException e) {
/*  952 */       handleError(e);
/*      */ 
/*  956 */       for (; frameSize > 0; frameSize--)
/*  957 */         this.scopes[(this.scopeTop--)] = new Scope(this);
/*      */     }
/*      */   }
/*      */ 
/*      */   public Scope getScope(int offset)
/*      */   {
/*  971 */     return this.scopes[(this.scopeTop - offset)];
/*      */   }
/*      */ 
/*      */   public void recordInnerPeer(Object innerPeer)
/*      */   {
/* 1076 */     if (this.assoc != null)
/* 1077 */       this.assoc.addInner(this.currentElement, innerPeer);
/*      */   }
/*      */ 
/*      */   public Object getInnerPeer()
/*      */   {
/* 1088 */     if ((this.assoc != null) && (this.isInplaceMode)) {
/* 1089 */       return this.assoc.getInnerPeer(this.currentElement);
/*      */     }
/* 1091 */     return null;
/*      */   }
/*      */ 
/*      */   public void recordOuterPeer(Object outerPeer)
/*      */   {
/* 1102 */     if (this.assoc != null)
/* 1103 */       this.assoc.addOuter(this.currentElement, outerPeer);
/*      */   }
/*      */ 
/*      */   public Object getOuterPeer()
/*      */   {
/* 1114 */     if ((this.assoc != null) && (this.isInplaceMode)) {
/* 1115 */       return this.assoc.getOuterPeer(this.currentElement);
/*      */     }
/* 1117 */     return null;
/*      */   }
/*      */ 
/*      */   public String getXMIMEContentType()
/*      */   {
/* 1139 */     Object t = this.current.target;
/* 1140 */     if (t == null) return null;
/* 1141 */     return getJAXBContext().getXMIMEContentType(t);
/*      */   }
/*      */ 
/*      */   public static UnmarshallingContext getInstance()
/*      */   {
/* 1149 */     return (UnmarshallingContext)Coordinator._getInstance();
/*      */   }
/*      */ 
/*      */   static
/*      */   {
/*  104 */     LocatorImpl loc = new LocatorImpl();
/*  105 */     loc.setPublicId(null);
/*  106 */     loc.setSystemId(null);
/*  107 */     loc.setLineNumber(-1);
/*  108 */     loc.setColumnNumber(-1);
/*  109 */     DUMMY_INSTANCE = new LocatorExWrapper(loc);
/*      */ 
/*  984 */     DEFAULT_ROOT_LOADER = new DefaultRootLoader(null);
/*  985 */     EXPECTED_TYPE_ROOT_LOADER = new ExpectedTypeRootLoader(null);
/*      */   }
/*      */ 
/*      */   private static final class ExpectedTypeRootLoader extends Loader
/*      */     implements Receiver
/*      */   {
/*      */     public void childElement(UnmarshallingContext.State state, TagName ea)
/*      */     {
/* 1042 */       UnmarshallingContext context = state.getContext();
/*      */ 
/* 1045 */       QName qn = new QName(ea.uri, ea.local);
/* 1046 */       state.prev.target = new JAXBElement(qn, context.expectedType.jaxbType, null, null);
/* 1047 */       state.receiver = this;
/*      */ 
/* 1052 */       state.loader = new XsiNilLoader(context.expectedType.getLoader(null, true));
/*      */     }
/*      */ 
/*      */     public void receive(UnmarshallingContext.State state, Object o) {
/* 1056 */       JAXBElement e = (JAXBElement)state.target;
/* 1057 */       e.setValue(o);
/* 1058 */       state.getContext().recordOuterPeer(e);
/* 1059 */       UnmarshallingContext.access$1002(state.getContext(), e);
/*      */     }
/*      */   }
/*      */ 
/*      */   private static final class DefaultRootLoader extends Loader
/*      */     implements Receiver
/*      */   {
/*      */     public void childElement(UnmarshallingContext.State state, TagName ea)
/*      */       throws SAXException
/*      */     {
/*  997 */       Loader loader = state.getContext().selectRootLoader(state, ea);
/*  998 */       if (loader != null) {
/*  999 */         state.loader = loader;
/* 1000 */         state.receiver = this;
/* 1001 */         return;
/*      */       }
/*      */ 
/* 1006 */       JaxBeanInfo beanInfo = XsiTypeLoader.parseXsiType(state, ea, null);
/* 1007 */       if (beanInfo == null)
/*      */       {
/* 1009 */         reportUnexpectedChildElement(ea, false);
/* 1010 */         return;
/*      */       }
/*      */ 
/* 1013 */       state.loader = beanInfo.getLoader(null, false);
/* 1014 */       state.prev.backup = new JAXBElement(ea.createQName(), Object.class, null);
/* 1015 */       state.receiver = this;
/*      */     }
/*      */ 
/*      */     public Collection<QName> getExpectedChildElements()
/*      */     {
/* 1020 */       return UnmarshallingContext.getInstance().getJAXBContext().getValidRootNames();
/*      */     }
/*      */ 
/*      */     public void receive(UnmarshallingContext.State state, Object o) {
/* 1024 */       if (state.backup != null) {
/* 1025 */         ((JAXBElement)state.backup).setValue(o);
/* 1026 */         o = state.backup;
/*      */       }
/* 1028 */       UnmarshallingContext.access$1002(state.getContext(), o);
/*      */     }
/*      */   }
/*      */ 
/*      */   private static class Factory
/*      */   {
/*      */     private final Object factorInstance;
/*      */     private final Method method;
/*      */ 
/*      */     public Factory(Object factorInstance, Method method)
/*      */     {
/*  276 */       this.factorInstance = factorInstance;
/*  277 */       this.method = method;
/*      */     }
/*      */ 
/*      */     public Object createInstance() throws SAXException {
/*      */       try {
/*  282 */         return this.method.invoke(this.factorInstance, new Object[0]);
/*      */       } catch (IllegalAccessException e) {
/*  284 */         UnmarshallingContext.getInstance().handleError(e, false);
/*      */       } catch (InvocationTargetException e) {
/*  286 */         UnmarshallingContext.getInstance().handleError(e, false);
/*      */       }
/*  288 */       return null;
/*      */     }
/*      */   }
/*      */ 
/*      */   public final class State
/*      */   {
/*      */     public Loader loader;
/*      */     public Receiver receiver;
/*      */     public Intercepter intercepter;
/*      */     public Object target;
/*      */     public Object backup;
/*      */     private int numNsDecl;
/*      */     public String elementDefaultValue;
/*      */     public final State prev;
/*      */     private State next;
/*      */ 
/*      */     public UnmarshallingContext getContext()
/*      */     {
/*  240 */       return UnmarshallingContext.this;
/*      */     }
/*      */ 
/*      */     private State(State prev) {
/*  244 */       this.prev = prev;
/*  245 */       if (prev != null)
/*  246 */         prev.next = this;
/*      */     }
/*      */ 
/*      */     private void push() {
/*  250 */       if (this.next == null)
/*  251 */         UnmarshallingContext.this.allocateMoreStates();
/*  252 */       State n = this.next;
/*  253 */       n.numNsDecl = UnmarshallingContext.this.nsLen;
/*  254 */       UnmarshallingContext.access$202(UnmarshallingContext.this, n);
/*      */     }
/*      */ 
/*      */     private void pop() {
/*  258 */       assert (this.prev != null);
/*  259 */       this.loader = null;
/*  260 */       this.receiver = null;
/*  261 */       this.intercepter = null;
/*  262 */       this.elementDefaultValue = null;
/*  263 */       this.target = null;
/*  264 */       UnmarshallingContext.access$202(UnmarshallingContext.this, this.prev);
/*      */     }
/*      */   }
/*      */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     com.sun.xml.bind.v2.runtime.unmarshaller.UnmarshallingContext
 * JD-Core Version:    0.6.0
 */