/*     */ package com.sun.xml.bind.v2.runtime.reflect;
/*     */ 
/*     */ import com.sun.xml.bind.api.AccessorException;
/*     */ import com.sun.xml.bind.v2.runtime.XMLSerializer;
/*     */ import java.util.Map;
/*     */ 
/*     */ final class PrimitiveArrayListerShort<BeanT> extends Lister<BeanT, short[], Short, ShortArrayPack>
/*     */ {
/*     */   static void register()
/*     */   {
/*  55 */     Lister.primitiveArrayListers.put(Short.TYPE, new PrimitiveArrayListerShort());
/*     */   }
/*     */ 
/*     */   public ListIterator<Short> iterator(short[] objects, XMLSerializer context) {
/*  59 */     return new ListIterator(objects) {
/*  60 */       int idx = 0;
/*     */ 
/*  62 */       public boolean hasNext() { return this.idx < this.val$objects.length; }
/*     */ 
/*     */       public Short next()
/*     */       {
/*  66 */         return Short.valueOf(this.val$objects[(this.idx++)]);
/*     */       } } ;
/*     */   }
/*     */ 
/*     */   public ShortArrayPack startPacking(BeanT current, Accessor<BeanT, short[]> acc) {
/*  72 */     return new ShortArrayPack();
/*     */   }
/*     */ 
/*     */   public void addToPack(ShortArrayPack objects, Short o) {
/*  76 */     objects.add(o);
/*     */   }
/*     */ 
/*     */   public void endPacking(ShortArrayPack pack, BeanT bean, Accessor<BeanT, short[]> acc) throws AccessorException {
/*  80 */     acc.set(bean, pack.build());
/*     */   }
/*     */ 
/*     */   public void reset(BeanT o, Accessor<BeanT, short[]> acc) throws AccessorException {
/*  84 */     acc.set(o, new short[0]);
/*     */   }
/*  88 */   static final class ShortArrayPack { short[] buf = new short[16];
/*     */     int size;
/*     */ 
/*     */     void add(Short b) {
/*  92 */       if (this.buf.length == this.size)
/*     */       {
/*  94 */         short[] nb = new short[this.buf.length * 2];
/*  95 */         System.arraycopy(this.buf, 0, nb, 0, this.buf.length);
/*  96 */         this.buf = nb;
/*     */       }
/*  98 */       this.buf[(this.size++)] = b.shortValue();
/*     */     }
/*     */ 
/*     */     short[] build() {
/* 102 */       if (this.buf.length == this.size)
/*     */       {
/* 104 */         return this.buf;
/*     */       }
/* 106 */       short[] r = new short[this.size];
/* 107 */       System.arraycopy(this.buf, 0, r, 0, this.size);
/* 108 */       return r;
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     com.sun.xml.bind.v2.runtime.reflect.PrimitiveArrayListerShort
 * JD-Core Version:    0.6.0
 */