/*     */ package com.sun.xml.bind.v2.runtime.reflect;
/*     */ 
/*     */ import com.sun.xml.bind.api.AccessorException;
/*     */ import com.sun.xml.bind.v2.runtime.XMLSerializer;
/*     */ import java.util.Map;
/*     */ 
/*     */ final class PrimitiveArrayListerByte<BeanT> extends Lister<BeanT, byte[], Byte, ByteArrayPack>
/*     */ {
/*     */   static void register()
/*     */   {
/*  55 */     Lister.primitiveArrayListers.put(Byte.TYPE, new PrimitiveArrayListerByte());
/*     */   }
/*     */ 
/*     */   public ListIterator<Byte> iterator(byte[] objects, XMLSerializer context) {
/*  59 */     return new ListIterator(objects) {
/*  60 */       int idx = 0;
/*     */ 
/*  62 */       public boolean hasNext() { return this.idx < this.val$objects.length; }
/*     */ 
/*     */       public Byte next()
/*     */       {
/*  66 */         return Byte.valueOf(this.val$objects[(this.idx++)]);
/*     */       } } ;
/*     */   }
/*     */ 
/*     */   public ByteArrayPack startPacking(BeanT current, Accessor<BeanT, byte[]> acc) {
/*  72 */     return new ByteArrayPack();
/*     */   }
/*     */ 
/*     */   public void addToPack(ByteArrayPack objects, Byte o) {
/*  76 */     objects.add(o);
/*     */   }
/*     */ 
/*     */   public void endPacking(ByteArrayPack pack, BeanT bean, Accessor<BeanT, byte[]> acc) throws AccessorException {
/*  80 */     acc.set(bean, pack.build());
/*     */   }
/*     */ 
/*     */   public void reset(BeanT o, Accessor<BeanT, byte[]> acc) throws AccessorException {
/*  84 */     acc.set(o, new byte[0]);
/*     */   }
/*  88 */   static final class ByteArrayPack { byte[] buf = new byte[16];
/*     */     int size;
/*     */ 
/*     */     void add(Byte b) {
/*  92 */       if (this.buf.length == this.size)
/*     */       {
/*  94 */         byte[] nb = new byte[this.buf.length * 2];
/*  95 */         System.arraycopy(this.buf, 0, nb, 0, this.buf.length);
/*  96 */         this.buf = nb;
/*     */       }
/*  98 */       this.buf[(this.size++)] = b.byteValue();
/*     */     }
/*     */ 
/*     */     byte[] build() {
/* 102 */       if (this.buf.length == this.size)
/*     */       {
/* 104 */         return this.buf;
/*     */       }
/* 106 */       byte[] r = new byte[this.size];
/* 107 */       System.arraycopy(this.buf, 0, r, 0, this.size);
/* 108 */       return r;
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     com.sun.xml.bind.v2.runtime.reflect.PrimitiveArrayListerByte
 * JD-Core Version:    0.6.0
 */