/*     */ package com.sun.xml.bind.v2.runtime.reflect;
/*     */ 
/*     */ import com.sun.xml.bind.api.AccessorException;
/*     */ import com.sun.xml.bind.v2.runtime.XMLSerializer;
/*     */ import java.util.Map;
/*     */ 
/*     */ final class PrimitiveArrayListerBoolean<BeanT> extends Lister<BeanT, boolean[], Boolean, BooleanArrayPack>
/*     */ {
/*     */   static void register()
/*     */   {
/*  55 */     Lister.primitiveArrayListers.put(Boolean.TYPE, new PrimitiveArrayListerBoolean());
/*     */   }
/*     */ 
/*     */   public ListIterator<Boolean> iterator(boolean[] objects, XMLSerializer context) {
/*  59 */     return new ListIterator(objects) {
/*  60 */       int idx = 0;
/*     */ 
/*  62 */       public boolean hasNext() { return this.idx < this.val$objects.length; }
/*     */ 
/*     */       public Boolean next()
/*     */       {
/*  66 */         return Boolean.valueOf(this.val$objects[(this.idx++)]);
/*     */       } } ;
/*     */   }
/*     */ 
/*     */   public BooleanArrayPack startPacking(BeanT current, Accessor<BeanT, boolean[]> acc) {
/*  72 */     return new BooleanArrayPack();
/*     */   }
/*     */ 
/*     */   public void addToPack(BooleanArrayPack objects, Boolean o) {
/*  76 */     objects.add(o);
/*     */   }
/*     */ 
/*     */   public void endPacking(BooleanArrayPack pack, BeanT bean, Accessor<BeanT, boolean[]> acc) throws AccessorException {
/*  80 */     acc.set(bean, pack.build());
/*     */   }
/*     */ 
/*     */   public void reset(BeanT o, Accessor<BeanT, boolean[]> acc) throws AccessorException {
/*  84 */     acc.set(o, new boolean[0]);
/*     */   }
/*  88 */   static final class BooleanArrayPack { boolean[] buf = new boolean[16];
/*     */     int size;
/*     */ 
/*     */     void add(Boolean b) {
/*  92 */       if (this.buf.length == this.size)
/*     */       {
/*  94 */         boolean[] nb = new boolean[this.buf.length * 2];
/*  95 */         System.arraycopy(this.buf, 0, nb, 0, this.buf.length);
/*  96 */         this.buf = nb;
/*     */       }
/*  98 */       this.buf[(this.size++)] = b.booleanValue();
/*     */     }
/*     */ 
/*     */     boolean[] build() {
/* 102 */       if (this.buf.length == this.size)
/*     */       {
/* 104 */         return this.buf;
/*     */       }
/* 106 */       boolean[] r = new boolean[this.size];
/* 107 */       System.arraycopy(this.buf, 0, r, 0, this.size);
/* 108 */       return r;
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     com.sun.xml.bind.v2.runtime.reflect.PrimitiveArrayListerBoolean
 * JD-Core Version:    0.6.0
 */