/*     */ package com.sun.xml.bind.v2.runtime.reflect;
/*     */ 
/*     */ import com.sun.istack.SAXException2;
/*     */ import com.sun.xml.bind.api.AccessorException;
/*     */ import com.sun.xml.bind.v2.ClassFactory;
/*     */ import com.sun.xml.bind.v2.TODO;
/*     */ import com.sun.xml.bind.v2.model.core.Adapter;
/*     */ import com.sun.xml.bind.v2.model.core.ID;
/*     */ import com.sun.xml.bind.v2.model.nav.Navigator;
/*     */ import com.sun.xml.bind.v2.model.nav.ReflectionNavigator;
/*     */ import com.sun.xml.bind.v2.runtime.JAXBContextImpl;
/*     */ import com.sun.xml.bind.v2.runtime.JaxBeanInfo;
/*     */ import com.sun.xml.bind.v2.runtime.XMLSerializer;
/*     */ import com.sun.xml.bind.v2.runtime.unmarshaller.LocatorEx;
/*     */ import com.sun.xml.bind.v2.runtime.unmarshaller.LocatorEx.Snapshot;
/*     */ import com.sun.xml.bind.v2.runtime.unmarshaller.Patcher;
/*     */ import com.sun.xml.bind.v2.runtime.unmarshaller.UnmarshallingContext;
/*     */ import java.lang.ref.WeakReference;
/*     */ import java.lang.reflect.Array;
/*     */ import java.lang.reflect.ParameterizedType;
/*     */ import java.lang.reflect.Type;
/*     */ import java.util.ArrayList;
/*     */ import java.util.Collection;
/*     */ import java.util.Collections;
/*     */ import java.util.HashMap;
/*     */ import java.util.Iterator;
/*     */ import java.util.List;
/*     */ import java.util.Map;
/*     */ import java.util.WeakHashMap;
/*     */ import java.util.concurrent.Callable;
/*     */ import javax.xml.bind.JAXBException;
/*     */ import org.xml.sax.SAXException;
/*     */ 
/*     */ public abstract class Lister<BeanT, PropT, ItemT, PackT>
/*     */ {
/*     */   private static final Map<Class, WeakReference<Lister>> arrayListerCache;
/*     */   static final Map<Class, Lister> primitiveArrayListers;
/*     */   public static final Lister ERROR;
/*     */   private static final ListIterator EMPTY_ITERATOR;
/*     */ 
/*     */   public abstract ListIterator<ItemT> iterator(PropT paramPropT, XMLSerializer paramXMLSerializer);
/*     */ 
/*     */   public abstract PackT startPacking(BeanT paramBeanT, Accessor<BeanT, PropT> paramAccessor)
/*     */     throws AccessorException;
/*     */ 
/*     */   public abstract void addToPack(PackT paramPackT, ItemT paramItemT)
/*     */     throws AccessorException;
/*     */ 
/*     */   public abstract void endPacking(PackT paramPackT, BeanT paramBeanT, Accessor<BeanT, PropT> paramAccessor)
/*     */     throws AccessorException;
/*     */ 
/*     */   public abstract void reset(BeanT paramBeanT, Accessor<BeanT, PropT> paramAccessor)
/*     */     throws AccessorException;
/*     */ 
/*     */   public static <BeanT, PropT, ItemT, PackT> Lister<BeanT, PropT, ItemT, PackT> create(Type fieldType, ID idness, Adapter<Type, Class> adapter)
/*     */   {
/* 126 */     Class rawType = Navigator.REFLECTION.erasure(fieldType);
/*     */     Lister l;
/* 130 */     if (rawType.isArray()) {
/* 131 */       Class itemType = rawType.getComponentType();
/* 132 */       l = getArrayLister(itemType);
/*     */     }
/*     */     else
/*     */     {
/*     */       Lister l;
/* 134 */       if (Collection.class.isAssignableFrom(rawType)) {
/* 135 */         Type bt = Navigator.REFLECTION.getBaseClass(fieldType, Collection.class);
/*     */         Class itemType;
/*     */         Class itemType;
/* 136 */         if ((bt instanceof ParameterizedType))
/* 137 */           itemType = Navigator.REFLECTION.erasure(((ParameterizedType)bt).getActualTypeArguments()[0]);
/*     */         else
/* 139 */           itemType = Object.class;
/* 140 */         l = new CollectionLister(getImplClass(rawType));
/*     */       } else {
/* 142 */         return null;
/*     */       }
/*     */     }
/*     */     Lister l;
/*     */     Class itemType;
/* 144 */     if (idness == ID.IDREF) {
/* 145 */       l = new IDREFS(l, itemType);
/*     */     }
/* 147 */     if (adapter != null) {
/* 148 */       l = new AdaptedLister(l, (Class)adapter.adapterType);
/*     */     }
/* 150 */     return l;
/*     */   }
/*     */ 
/*     */   private static Class getImplClass(Class<?> fieldType) {
/* 154 */     return ClassFactory.inferImplClass(fieldType, ClassFactory.COLLECTION_IMPL_CLASSES);
/*     */   }
/*     */ 
/*     */   private static Lister getArrayLister(Class componentType)
/*     */   {
/* 167 */     Lister l = null;
/* 168 */     if (componentType.isPrimitive()) {
/* 169 */       l = (Lister)primitiveArrayListers.get(componentType);
/*     */     } else {
/* 171 */       WeakReference wr = (WeakReference)arrayListerCache.get(componentType);
/* 172 */       if (wr != null)
/* 173 */         l = (Lister)wr.get();
/* 174 */       if (l == null) {
/* 175 */         l = new ArrayLister(componentType);
/* 176 */         arrayListerCache.put(componentType, new WeakReference(l));
/*     */       }
/*     */     }
/* 179 */     assert (l != null);
/* 180 */     return l;
/*     */   }
/*     */ 
/*     */   public static <A, B, C, D> Lister<A, B, C, D> getErrorInstance()
/*     */   {
/* 457 */     return ERROR;
/*     */   }
/*     */ 
/*     */   static
/*     */   {
/* 160 */     arrayListerCache = Collections.synchronizedMap(new WeakHashMap());
/*     */ 
/* 244 */     primitiveArrayListers = new HashMap();
/*     */ 
/* 248 */     PrimitiveArrayListerBoolean.register();
/* 249 */     PrimitiveArrayListerByte.register();
/* 250 */     PrimitiveArrayListerCharacter.register();
/* 251 */     PrimitiveArrayListerDouble.register();
/* 252 */     PrimitiveArrayListerFloat.register();
/* 253 */     PrimitiveArrayListerInteger.register();
/* 254 */     PrimitiveArrayListerLong.register();
/* 255 */     PrimitiveArrayListerShort.register();
/*     */ 
/* 460 */     ERROR = new Lister() {
/*     */       public ListIterator iterator(Object o, XMLSerializer context) {
/* 462 */         return Lister.EMPTY_ITERATOR;
/*     */       }
/*     */ 
/*     */       public Object startPacking(Object o, Accessor accessor) {
/* 466 */         return null;
/*     */       }
/*     */ 
/*     */       public void addToPack(Object o, Object o1)
/*     */       {
/*     */       }
/*     */ 
/*     */       public void endPacking(Object o, Object o1, Accessor accessor)
/*     */       {
/*     */       }
/*     */ 
/*     */       public void reset(Object o, Accessor accessor)
/*     */       {
/*     */       }
/*     */     };
/* 479 */     EMPTY_ITERATOR = new ListIterator() {
/*     */       public boolean hasNext() {
/* 481 */         return false;
/*     */       }
/*     */ 
/*     */       public Object next() {
/* 485 */         throw new IllegalStateException();
/*     */       }
/*     */     };
/*     */   }
/*     */ 
/*     */   public static final class IDREFSIterator
/*     */     implements ListIterator<String>
/*     */   {
/*     */     private final ListIterator i;
/*     */     private final XMLSerializer context;
/*     */     private Object last;
/*     */ 
/*     */     private IDREFSIterator(ListIterator i, XMLSerializer context)
/*     */     {
/* 427 */       this.i = i;
/* 428 */       this.context = context;
/*     */     }
/*     */ 
/*     */     public boolean hasNext() {
/* 432 */       return this.i.hasNext();
/*     */     }
/*     */ 
/*     */     public Object last()
/*     */     {
/* 439 */       return this.last;
/*     */     }
/*     */ 
/*     */     public String next() throws SAXException, JAXBException {
/* 443 */       this.last = this.i.next();
/* 444 */       String id = this.context.grammar.getBeanInfo(this.last, true).getId(this.last, this.context);
/* 445 */       if (id == null) {
/* 446 */         this.context.errorMissingId(this.last);
/*     */       }
/* 448 */       return id;
/*     */     }
/*     */   }
/*     */ 
/*     */   private static final class IDREFS<BeanT, PropT> extends Lister<BeanT, PropT, String, IDREFS<BeanT, PropT>.Pack>
/*     */   {
/*     */     private final Lister<BeanT, PropT, Object, Object> core;
/*     */     private final Class itemType;
/*     */ 
/*     */     public IDREFS(Lister core, Class itemType)
/*     */     {
/* 332 */       this.core = core;
/* 333 */       this.itemType = itemType;
/*     */     }
/*     */ 
/*     */     public ListIterator<String> iterator(PropT prop, XMLSerializer context) {
/* 337 */       ListIterator i = this.core.iterator(prop, context);
/*     */ 
/* 339 */       return new Lister.IDREFSIterator(i, context, null);
/*     */     }
/*     */ 
/*     */     public IDREFS<BeanT, PropT>.Pack startPacking(BeanT bean, Accessor<BeanT, PropT> acc) {
/* 343 */       return new Pack(bean, acc);
/*     */     }
/*     */ 
/*     */     public void addToPack(IDREFS<BeanT, PropT>.Pack pack, String item) {
/* 347 */       pack.add(item);
/*     */     }
/*     */ 
/*     */     public void endPacking(IDREFS<BeanT, PropT>.Pack pack, BeanT bean, Accessor<BeanT, PropT> acc) {
/*     */     }
/*     */ 
/*     */     public void reset(BeanT bean, Accessor<BeanT, PropT> acc) throws AccessorException {
/* 354 */       this.core.reset(bean, acc);
/*     */     }
/*     */     private class Pack implements Patcher {
/*     */       private final BeanT bean;
/* 362 */       private final List<String> idrefs = new ArrayList();
/*     */       private final UnmarshallingContext context;
/*     */       private final Accessor<BeanT, PropT> acc;
/*     */       private final LocatorEx location;
/*     */ 
/* 368 */       public Pack(Accessor<BeanT, PropT> bean) { this.bean = bean;
/* 369 */         this.acc = acc;
/* 370 */         this.context = UnmarshallingContext.getInstance();
/* 371 */         this.location = new LocatorEx.Snapshot(this.context.getLocator());
/* 372 */         this.context.addPatcher(this); }
/*     */ 
/*     */       public void add(String item)
/*     */       {
/* 376 */         this.idrefs.add(item);
/*     */       }
/*     */ 
/*     */       public void run()
/*     */         throws SAXException
/*     */       {
/*     */         try
/*     */         {
/* 384 */           Object pack = Lister.this.startPacking(this.bean, this.acc);
/*     */ 
/* 386 */           for (String id : this.idrefs) { Callable callable = this.context.getObjectFromId(id, Lister.IDREFS.this.itemType);
/*     */             Object t;
/*     */             try {
/* 391 */               t = callable != null ? callable.call() : null;
/*     */             } catch (SAXException e) {
/* 393 */               throw e;
/*     */             } catch (Exception e) {
/* 395 */               throw new SAXException2(e);
/*     */             }
/*     */ 
/* 398 */             if (t == null) {
/* 399 */               this.context.errorUnresolvedIDREF(this.bean, id, this.location);
/*     */             } else {
/* 401 */               TODO.prototype();
/* 402 */               Lister.this.addToPack(pack, t);
/*     */             }
/*     */           }
/*     */ 
/* 406 */           Lister.this.endPacking(pack, this.bean, this.acc);
/*     */         } catch (AccessorException e) {
/* 408 */           this.context.handleError(e);
/*     */         }
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public static final class CollectionLister<BeanT, T extends Collection> extends Lister<BeanT, T, Object, T>
/*     */   {
/*     */     private final Class<? extends T> implClass;
/*     */ 
/*     */     public CollectionLister(Class<? extends T> implClass)
/*     */     {
/* 270 */       this.implClass = implClass;
/*     */     }
/*     */ 
/*     */     public ListIterator iterator(T collection, XMLSerializer context) {
/* 274 */       Iterator itr = collection.iterator();
/* 275 */       return new ListIterator(itr) {
/*     */         public boolean hasNext() {
/* 277 */           return this.val$itr.hasNext();
/*     */         }
/*     */         public Object next() {
/* 280 */           return this.val$itr.next();
/*     */         } } ;
/*     */     }
/*     */ 
/*     */     public T startPacking(BeanT bean, Accessor<BeanT, T> acc) throws AccessorException {
/* 286 */       Collection collection = (Collection)acc.get(bean);
/* 287 */       if (collection == null) {
/* 288 */         collection = (Collection)ClassFactory.create(this.implClass);
/* 289 */         if (!acc.isAdapted())
/* 290 */           acc.set(bean, collection);
/*     */       }
/* 292 */       collection.clear();
/* 293 */       return collection;
/*     */     }
/*     */ 
/*     */     public void addToPack(T collection, Object o) {
/* 297 */       collection.add(o);
/*     */     }
/*     */ 
/*     */     public void endPacking(T collection, BeanT bean, Accessor<BeanT, T> acc)
/*     */       throws AccessorException
/*     */     {
/* 308 */       if (acc.isAdapted())
/* 309 */         acc.set(bean, collection);
/*     */     }
/*     */ 
/*     */     public void reset(BeanT bean, Accessor<BeanT, T> acc) throws AccessorException {
/* 313 */       Collection collection = (Collection)acc.get(bean);
/* 314 */       if (collection == null) {
/* 315 */         return;
/*     */       }
/* 317 */       collection.clear();
/*     */     }
/*     */   }
/*     */ 
/*     */   public static final class Pack<ItemT> extends ArrayList<ItemT>
/*     */   {
/*     */     private final Class<ItemT> itemType;
/*     */ 
/*     */     public Pack(Class<ItemT> itemType)
/*     */     {
/* 233 */       this.itemType = itemType;
/*     */     }
/*     */ 
/*     */     public ItemT[] build() {
/* 237 */       return super.toArray((Object[])(Object[])Array.newInstance(this.itemType, size()));
/*     */     }
/*     */   }
/*     */ 
/*     */   private static final class ArrayLister<BeanT, ItemT> extends Lister<BeanT, ItemT[], ItemT, Lister.Pack<ItemT>>
/*     */   {
/*     */     private final Class<ItemT> itemType;
/*     */ 
/*     */     public ArrayLister(Class<ItemT> itemType)
/*     */     {
/* 195 */       this.itemType = itemType;
/*     */     }
/*     */ 
/*     */     public ListIterator<ItemT> iterator(ItemT[] objects, XMLSerializer context) {
/* 199 */       return new ListIterator(objects) {
/* 200 */         int idx = 0;
/*     */ 
/* 202 */         public boolean hasNext() { return this.idx < this.val$objects.length; }
/*     */ 
/*     */         public ItemT next()
/*     */         {
/* 206 */           return this.val$objects[(this.idx++)];
/*     */         } } ;
/*     */     }
/*     */ 
/*     */     public Lister.Pack startPacking(BeanT current, Accessor<BeanT, ItemT[]> acc) {
/* 212 */       return new Lister.Pack(this.itemType);
/*     */     }
/*     */ 
/*     */     public void addToPack(Lister.Pack<ItemT> objects, ItemT o) {
/* 216 */       objects.add(o);
/*     */     }
/*     */ 
/*     */     public void endPacking(Lister.Pack<ItemT> pack, BeanT bean, Accessor<BeanT, ItemT[]> acc) throws AccessorException {
/* 220 */       acc.set(bean, pack.build());
/*     */     }
/*     */ 
/*     */     public void reset(BeanT o, Accessor<BeanT, ItemT[]> acc) throws AccessorException {
/* 224 */       acc.set(o, (Object[])(Object[])Array.newInstance(this.itemType, 0));
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     com.sun.xml.bind.v2.runtime.reflect.Lister
 * JD-Core Version:    0.6.0
 */