/*     */ package com.sun.xml.bind.v2.runtime.reflect;
/*     */ 
/*     */ import com.sun.istack.Nullable;
/*     */ import com.sun.xml.bind.Util;
/*     */ import com.sun.xml.bind.api.AccessorException;
/*     */ import com.sun.xml.bind.v2.model.core.Adapter;
/*     */ import com.sun.xml.bind.v2.model.nav.Navigator;
/*     */ import com.sun.xml.bind.v2.model.nav.ReflectionNavigator;
/*     */ import com.sun.xml.bind.v2.runtime.JAXBContextImpl;
/*     */ import com.sun.xml.bind.v2.runtime.reflect.opt.OptimizedAccessorFactory;
/*     */ import com.sun.xml.bind.v2.runtime.unmarshaller.Loader;
/*     */ import com.sun.xml.bind.v2.runtime.unmarshaller.Receiver;
/*     */ import com.sun.xml.bind.v2.runtime.unmarshaller.UnmarshallingContext.State;
/*     */ import java.lang.reflect.Field;
/*     */ import java.lang.reflect.InvocationTargetException;
/*     */ import java.lang.reflect.Method;
/*     */ import java.lang.reflect.Modifier;
/*     */ import java.lang.reflect.Type;
/*     */ import java.util.HashMap;
/*     */ import java.util.Map;
/*     */ import java.util.logging.Level;
/*     */ import java.util.logging.Logger;
/*     */ import javax.xml.bind.JAXBElement;
/*     */ import javax.xml.bind.annotation.adapters.XmlAdapter;
/*     */ import org.xml.sax.SAXException;
/*     */ 
/*     */ public abstract class Accessor<BeanT, ValueT>
/*     */   implements Receiver
/*     */ {
/*     */   public final Class<ValueT> valueType;
/* 196 */   private static boolean accessWarned = false;
/*     */ 
/* 415 */   private static final Accessor ERROR = new Accessor() {
/*     */     public Object get(Object o) {
/* 417 */       return null;
/*     */     }
/*     */ 
/*     */     public void set(Object o, Object o1)
/*     */     {
/*     */     }
/* 415 */   };
/*     */ 
/* 427 */   public static final Accessor<JAXBElement, Object> JAXB_ELEMENT_VALUE = new Accessor() {
/*     */     public Object get(JAXBElement jaxbElement) {
/* 429 */       return jaxbElement.getValue();
/*     */     }
/*     */ 
/*     */     public void set(JAXBElement jaxbElement, Object o) {
/* 433 */       jaxbElement.setValue(o);
/*     */     }
/* 427 */   };
/*     */ 
/* 440 */   private static final Map<Class, Object> uninitializedValues = new HashMap();
/*     */ 
/*     */   public Class<ValueT> getValueType()
/*     */   {
/*  89 */     return this.valueType;
/*     */   }
/*     */ 
/*     */   protected Accessor(Class<ValueT> valueType) {
/*  93 */     this.valueType = valueType;
/*     */   }
/*     */ 
/*     */   public Accessor<BeanT, ValueT> optimize(@Nullable JAXBContextImpl context)
/*     */   {
/* 106 */     return this;
/*     */   }
/*     */ 
/*     */   public abstract ValueT get(BeanT paramBeanT)
/*     */     throws AccessorException;
/*     */ 
/*     */   public abstract void set(BeanT paramBeanT, ValueT paramValueT)
/*     */     throws AccessorException;
/*     */ 
/*     */   public Object getUnadapted(BeanT bean)
/*     */     throws AccessorException
/*     */   {
/* 147 */     return get(bean);
/*     */   }
/*     */ 
/*     */   public boolean isAdapted()
/*     */   {
/* 156 */     return false;
/*     */   }
/*     */ 
/*     */   public void setUnadapted(BeanT bean, Object value)
/*     */     throws AccessorException
/*     */   {
/* 166 */     set(bean, value);
/*     */   }
/*     */ 
/*     */   public void receive(UnmarshallingContext.State state, Object o) throws SAXException {
/*     */     try {
/* 171 */       set(state.target, o);
/*     */     } catch (AccessorException e) {
/* 173 */       Loader.handleGenericException(e, true);
/*     */     }
/*     */   }
/*     */ 
/*     */   public final <T> Accessor<BeanT, T> adapt(Class<T> targetType, Class<? extends XmlAdapter<T, ValueT>> adapter)
/*     */   {
/* 182 */     return new AdaptedAccessor(targetType, this, adapter);
/*     */   }
/*     */ 
/*     */   public final <T> Accessor<BeanT, T> adapt(Adapter<Type, Class> adapter) {
/* 186 */     return new AdaptedAccessor(Navigator.REFLECTION.erasure((Type)adapter.defaultType), this, (Class)adapter.adapterType);
/*     */   }
/*     */ 
/*     */   public static <A, B> Accessor<A, B> getErrorInstance()
/*     */   {
/* 412 */     return ERROR;
/*     */   }
/*     */ 
/*     */   static
/*     */   {
/* 453 */     uninitializedValues.put(Byte.TYPE, Byte.valueOf(0));
/* 454 */     uninitializedValues.put(Boolean.TYPE, Boolean.valueOf(false));
/* 455 */     uninitializedValues.put(Character.TYPE, Character.valueOf('\000'));
/* 456 */     uninitializedValues.put(Float.TYPE, Float.valueOf(0.0F));
/* 457 */     uninitializedValues.put(Double.TYPE, Double.valueOf(0.0D));
/* 458 */     uninitializedValues.put(Integer.TYPE, Integer.valueOf(0));
/* 459 */     uninitializedValues.put(Long.TYPE, Long.valueOf(0L));
/* 460 */     uninitializedValues.put(Short.TYPE, Short.valueOf(0));
/*     */   }
/*     */ 
/*     */   public static class SetterOnlyReflection<BeanT, ValueT> extends Accessor.GetterSetterReflection<BeanT, ValueT>
/*     */   {
/*     */     public SetterOnlyReflection(Method setter)
/*     */     {
/* 398 */       super(setter);
/*     */     }
/*     */ 
/*     */     public ValueT get(BeanT bean) throws AccessorException
/*     */     {
/* 403 */       throw new AccessorException(Messages.NO_GETTER.format(new Object[] { this.setter.toString() }));
/*     */     }
/*     */   }
/*     */ 
/*     */   public static class GetterOnlyReflection<BeanT, ValueT> extends Accessor.GetterSetterReflection<BeanT, ValueT>
/*     */   {
/*     */     public GetterOnlyReflection(Method getter)
/*     */     {
/* 381 */       super(null);
/*     */     }
/*     */ 
/*     */     public void set(BeanT bean, ValueT value) throws AccessorException
/*     */     {
/* 386 */       throw new AccessorException(Messages.NO_SETTER.format(new Object[] { this.getter.toString() }));
/*     */     }
/*     */   }
/*     */ 
/*     */   public static class GetterSetterReflection<BeanT, ValueT> extends Accessor<BeanT, ValueT>
/*     */   {
/*     */     public final Method getter;
/*     */     public final Method setter;
/* 286 */     private static final Logger logger = Util.getClassLogger();
/*     */ 
/*     */     public GetterSetterReflection(Method getter, Method setter) {
/* 289 */       super();
/*     */ 
/* 293 */       this.getter = getter;
/* 294 */       this.setter = setter;
/*     */ 
/* 296 */       if (getter != null)
/* 297 */         makeAccessible(getter);
/* 298 */       if (setter != null)
/* 299 */         makeAccessible(setter);
/*     */     }
/*     */ 
/*     */     private void makeAccessible(Method m) {
/* 303 */       if ((!Modifier.isPublic(m.getModifiers())) || (!Modifier.isPublic(m.getDeclaringClass().getModifiers())))
/*     */         try {
/* 305 */           m.setAccessible(true);
/*     */         } catch (SecurityException e) {
/* 307 */           if (!Accessor.accessWarned)
/*     */           {
/* 309 */             logger.log(Level.WARNING, Messages.UNABLE_TO_ACCESS_NON_PUBLIC_FIELD.format(new Object[] { m.getDeclaringClass().getName(), m.getName() }), e);
/*     */           }
/*     */ 
/* 313 */           Accessor.access$002(true);
/*     */         }
/*     */     }
/*     */ 
/*     */     public ValueT get(BeanT bean) throws AccessorException
/*     */     {
/*     */       try {
/* 320 */         return this.getter.invoke(bean, new Object[0]);
/*     */       } catch (IllegalAccessException e) {
/* 322 */         throw new IllegalAccessError(e.getMessage()); } catch (InvocationTargetException e) {
/*     */       }
/* 324 */       throw handleInvocationTargetException(e);
/*     */     }
/*     */ 
/*     */     public void set(BeanT bean, ValueT value) throws AccessorException
/*     */     {
/*     */       try {
/* 330 */         if (value == null)
/* 331 */           value = Accessor.uninitializedValues.get(this.valueType);
/* 332 */         this.setter.invoke(bean, new Object[] { value });
/*     */       } catch (IllegalAccessException e) {
/* 334 */         throw new IllegalAccessError(e.getMessage());
/*     */       } catch (InvocationTargetException e) {
/* 336 */         throw handleInvocationTargetException(e);
/*     */       }
/*     */     }
/*     */ 
/*     */     private AccessorException handleInvocationTargetException(InvocationTargetException e)
/*     */     {
/* 342 */       Throwable t = e.getTargetException();
/* 343 */       if ((t instanceof RuntimeException))
/* 344 */         throw ((RuntimeException)t);
/* 345 */       if ((t instanceof Error)) {
/* 346 */         throw ((Error)t);
/*     */       }
/*     */ 
/* 353 */       return new AccessorException(t);
/*     */     }
/*     */ 
/*     */     public Accessor<BeanT, ValueT> optimize(JAXBContextImpl context)
/*     */     {
/* 358 */       if ((this.getter == null) || (this.setter == null))
/*     */       {
/* 360 */         return this;
/* 361 */       }if ((context != null) && (context.fastBoot))
/*     */       {
/* 363 */         return this;
/*     */       }
/* 365 */       Accessor acc = OptimizedAccessorFactory.get(this.getter, this.setter);
/* 366 */       if (acc != null) {
/* 367 */         return acc;
/*     */       }
/* 369 */       return this;
/*     */     }
/*     */   }
/*     */ 
/*     */   public static final class ReadOnlyFieldReflection<BeanT, ValueT> extends Accessor.FieldReflection<BeanT, ValueT>
/*     */   {
/*     */     public ReadOnlyFieldReflection(Field f)
/*     */     {
/* 265 */       super();
/*     */     }
/*     */ 
/*     */     public void set(BeanT bean, ValueT value)
/*     */     {
/*     */     }
/*     */ 
/*     */     public Accessor<BeanT, ValueT> optimize(JAXBContextImpl context)
/*     */     {
/* 274 */       return this;
/*     */     }
/*     */   }
/*     */ 
/*     */   public static class FieldReflection<BeanT, ValueT> extends Accessor<BeanT, ValueT>
/*     */   {
/*     */     public final Field f;
/* 205 */     private static final Logger logger = Util.getClassLogger();
/*     */ 
/*     */     public FieldReflection(Field f)
/*     */     {
/* 210 */       super();
/* 211 */       this.f = f;
/*     */ 
/* 213 */       int mod = f.getModifiers();
/* 214 */       if ((!Modifier.isPublic(mod)) || (Modifier.isFinal(mod)) || (!Modifier.isPublic(f.getDeclaringClass().getModifiers())))
/*     */         try {
/* 216 */           f.setAccessible(true);
/*     */         } catch (SecurityException e) {
/* 218 */           if (!Accessor.accessWarned)
/*     */           {
/* 220 */             logger.log(Level.WARNING, Messages.UNABLE_TO_ACCESS_NON_PUBLIC_FIELD.format(new Object[] { f.getDeclaringClass().getName(), f.getName() }), e);
/*     */           }
/*     */ 
/* 224 */           Accessor.access$002(true);
/*     */         }
/*     */     }
/*     */ 
/*     */     public ValueT get(BeanT bean)
/*     */     {
/*     */       try {
/* 231 */         return this.f.get(bean); } catch (IllegalAccessException e) {
/*     */       }
/* 233 */       throw new IllegalAccessError(e.getMessage());
/*     */     }
/*     */ 
/*     */     public void set(BeanT bean, ValueT value)
/*     */     {
/*     */       try {
/* 239 */         if (value == null)
/* 240 */           value = Accessor.uninitializedValues.get(this.valueType);
/* 241 */         this.f.set(bean, value);
/*     */       } catch (IllegalAccessException e) {
/* 243 */         throw new IllegalAccessError(e.getMessage());
/*     */       }
/*     */     }
/*     */ 
/*     */     public Accessor<BeanT, ValueT> optimize(JAXBContextImpl context)
/*     */     {
/* 249 */       if ((context != null) && (context.fastBoot))
/*     */       {
/* 251 */         return this;
/* 252 */       }Accessor acc = OptimizedAccessorFactory.get(this.f);
/* 253 */       if (acc != null) {
/* 254 */         return acc;
/*     */       }
/* 256 */       return this;
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     com.sun.xml.bind.v2.runtime.reflect.Accessor
 * JD-Core Version:    0.6.0
 */