/*      */ package com.sun.xml.bind.v2.runtime;
/*      */ 
/*      */ import com.sun.istack.SAXException2;
/*      */ import com.sun.xml.bind.CycleRecoverable;
/*      */ import com.sun.xml.bind.CycleRecoverable.Context;
/*      */ import com.sun.xml.bind.marshaller.NamespacePrefixMapper;
/*      */ import com.sun.xml.bind.util.ValidationEventLocatorExImpl;
/*      */ import com.sun.xml.bind.v2.runtime.output.MTOMXmlOutput;
/*      */ import com.sun.xml.bind.v2.runtime.output.NamespaceContextImpl;
/*      */ import com.sun.xml.bind.v2.runtime.output.NamespaceContextImpl.Element;
/*      */ import com.sun.xml.bind.v2.runtime.output.Pcdata;
/*      */ import com.sun.xml.bind.v2.runtime.output.XmlOutput;
/*      */ import com.sun.xml.bind.v2.runtime.unmarshaller.Base64Data;
/*      */ import com.sun.xml.bind.v2.runtime.unmarshaller.IntData;
/*      */ import com.sun.xml.bind.v2.util.CollisionCheckStack;
/*      */ import java.io.IOException;
/*      */ import java.lang.reflect.Method;
/*      */ import java.util.HashSet;
/*      */ import java.util.Iterator;
/*      */ import java.util.Map;
/*      */ import java.util.Map.Entry;
/*      */ import java.util.Set;
/*      */ import javax.activation.MimeType;
/*      */ import javax.xml.bind.DatatypeConverter;
/*      */ import javax.xml.bind.JAXBException;
/*      */ import javax.xml.bind.Marshaller;
/*      */ import javax.xml.bind.Marshaller.Listener;
/*      */ import javax.xml.bind.ValidationEvent;
/*      */ import javax.xml.bind.ValidationEventHandler;
/*      */ import javax.xml.bind.ValidationEventLocator;
/*      */ import javax.xml.bind.annotation.DomHandler;
/*      */ import javax.xml.bind.attachment.AttachmentMarshaller;
/*      */ import javax.xml.bind.helpers.NotIdentifiableEventImpl;
/*      */ import javax.xml.bind.helpers.ValidationEventImpl;
/*      */ import javax.xml.bind.helpers.ValidationEventLocatorImpl;
/*      */ import javax.xml.namespace.QName;
/*      */ import javax.xml.stream.XMLStreamException;
/*      */ import javax.xml.transform.Source;
/*      */ import javax.xml.transform.Transformer;
/*      */ import javax.xml.transform.TransformerException;
/*      */ import javax.xml.transform.sax.SAXResult;
/*      */ import org.xml.sax.SAXException;
/*      */ 
/*      */ public final class XMLSerializer extends Coordinator
/*      */ {
/*      */   public final JAXBContextImpl grammar;
/*      */   private XmlOutput out;
/*      */   public final NameList nameList;
/*      */   public final int[] knownUri2prefixIndexMap;
/*      */   private final NamespaceContextImpl nsContext;
/*      */   private NamespaceContextImpl.Element nse;
/*  149 */   private boolean textHasAlreadyPrinted = false;
/*      */ 
/*  154 */   private boolean seenRoot = false;
/*      */   private final MarshallerImpl marshaller;
/*  160 */   private final Set<Object> idReferencedObjects = new HashSet();
/*      */ 
/*  163 */   private final Set<Object> objectsWithId = new HashSet();
/*      */ 
/*  169 */   private final CollisionCheckStack<Object> cycleDetectionStack = new CollisionCheckStack();
/*      */   private String schemaLocation;
/*      */   private String noNsSchemaLocation;
/*      */   private Transformer identityTransformer;
/*      */   private ContentHandlerAdaptor contentHandlerAdapter;
/*      */   private boolean fragment;
/*      */   private Base64Data base64Data;
/*  191 */   private final IntData intData = new IntData();
/*      */   public AttachmentMarshaller attachmentMarshaller;
/*      */   private MimeType expectedMimeType;
/*      */   private boolean inlineBinaryFlag;
/*      */   private QName schemaType;
/*      */ 
/*      */   XMLSerializer(MarshallerImpl _owner)
/*      */   {
/*  197 */     this.marshaller = _owner;
/*  198 */     this.grammar = this.marshaller.context;
/*  199 */     this.nsContext = new NamespaceContextImpl(this);
/*  200 */     this.nameList = this.marshaller.context.nameList;
/*  201 */     this.knownUri2prefixIndexMap = new int[this.nameList.namespaceURIs.length];
/*      */   }
/*      */ 
/*      */   public Base64Data getCachedBase64DataInstance()
/*      */   {
/*  208 */     if (this.base64Data == null)
/*  209 */       this.base64Data = new Base64Data();
/*  210 */     return this.base64Data;
/*      */   }
/*      */ 
/*      */   private String getIdFromObject(Object identifiableObject)
/*      */     throws SAXException, JAXBException
/*      */   {
/*  217 */     return this.grammar.getBeanInfo(identifiableObject, true).getId(identifiableObject, this);
/*      */   }
/*      */ 
/*      */   private void handleMissingObjectError(String fieldName) throws SAXException, IOException, XMLStreamException {
/*  221 */     reportMissingObjectError(fieldName);
/*      */ 
/*  224 */     endNamespaceDecls(null);
/*  225 */     endAttributes();
/*      */   }
/*      */ 
/*      */   public void reportError(ValidationEvent ve) throws SAXException
/*      */   {
/*      */     ValidationEventHandler handler;
/*      */     try {
/*  233 */       handler = this.marshaller.getEventHandler();
/*      */     } catch (JAXBException e) {
/*  235 */       throw new SAXException2(e);
/*      */     }
/*      */ 
/*  238 */     if (!handler.handleEvent(ve)) {
/*  239 */       if ((ve.getLinkedException() instanceof Exception)) {
/*  240 */         throw new SAXException2((Exception)ve.getLinkedException());
/*      */       }
/*  242 */       throw new SAXException2(ve.getMessage());
/*      */     }
/*      */   }
/*      */ 
/*      */   public final void reportError(String fieldName, Throwable t)
/*      */     throws SAXException
/*      */   {
/*  253 */     ValidationEvent ve = new ValidationEventImpl(1, t.getMessage(), getCurrentLocation(fieldName), t);
/*      */ 
/*  255 */     reportError(ve);
/*      */   }
/*      */ 
/*      */   public void startElement(Name tagName, Object outerPeer) {
/*  259 */     startElement();
/*  260 */     this.nse.setTagName(tagName, outerPeer);
/*      */   }
/*      */ 
/*      */   public void startElement(String nsUri, String localName, String preferredPrefix, Object outerPeer) {
/*  264 */     startElement();
/*  265 */     int idx = this.nsContext.declareNsUri(nsUri, preferredPrefix, false);
/*  266 */     this.nse.setTagName(idx, localName, outerPeer);
/*      */   }
/*      */ 
/*      */   public void startElementForce(String nsUri, String localName, String forcedPrefix, Object outerPeer)
/*      */   {
/*  274 */     startElement();
/*  275 */     int idx = this.nsContext.force(nsUri, forcedPrefix);
/*  276 */     this.nse.setTagName(idx, localName, outerPeer);
/*      */   }
/*      */ 
/*      */   public void endNamespaceDecls(Object innerPeer) throws IOException, XMLStreamException {
/*  280 */     this.nsContext.collectionMode = false;
/*  281 */     this.nse.startElement(this.out, innerPeer);
/*      */   }
/*      */ 
/*      */   public void endAttributes()
/*      */     throws SAXException, IOException, XMLStreamException
/*      */   {
/*  289 */     if (!this.seenRoot) {
/*  290 */       this.seenRoot = true;
/*  291 */       if ((this.schemaLocation != null) || (this.noNsSchemaLocation != null)) {
/*  292 */         int p = this.nsContext.getPrefixIndex("http://www.w3.org/2001/XMLSchema-instance");
/*  293 */         if (this.schemaLocation != null)
/*  294 */           this.out.attribute(p, "schemaLocation", this.schemaLocation);
/*  295 */         if (this.noNsSchemaLocation != null) {
/*  296 */           this.out.attribute(p, "noNamespaceSchemaLocation", this.noNsSchemaLocation);
/*      */         }
/*      */       }
/*      */     }
/*  300 */     this.out.endStartTag();
/*      */   }
/*      */ 
/*      */   public void endElement()
/*      */     throws SAXException, IOException, XMLStreamException
/*      */   {
/*  308 */     this.nse.endElement(this.out);
/*  309 */     this.nse = this.nse.pop();
/*  310 */     this.textHasAlreadyPrinted = false;
/*      */   }
/*      */ 
/*      */   public void leafElement(Name tagName, String data, String fieldName) throws SAXException, IOException, XMLStreamException {
/*  314 */     if (this.seenRoot) {
/*  315 */       this.textHasAlreadyPrinted = false;
/*  316 */       this.nse = this.nse.push();
/*  317 */       this.out.beginStartTag(tagName);
/*  318 */       this.out.endStartTag();
/*  319 */       this.out.text(data, false);
/*  320 */       this.out.endTag(tagName);
/*  321 */       this.nse = this.nse.pop();
/*      */     }
/*      */     else
/*      */     {
/*  325 */       startElement(tagName, null);
/*  326 */       endNamespaceDecls(null);
/*  327 */       endAttributes();
/*  328 */       this.out.text(data, false);
/*  329 */       endElement();
/*      */     }
/*      */   }
/*      */ 
/*      */   public void leafElement(Name tagName, Pcdata data, String fieldName) throws SAXException, IOException, XMLStreamException {
/*  334 */     if (this.seenRoot) {
/*  335 */       this.textHasAlreadyPrinted = false;
/*  336 */       this.nse = this.nse.push();
/*  337 */       this.out.beginStartTag(tagName);
/*  338 */       this.out.endStartTag();
/*  339 */       this.out.text(data, false);
/*  340 */       this.out.endTag(tagName);
/*  341 */       this.nse = this.nse.pop();
/*      */     }
/*      */     else
/*      */     {
/*  345 */       startElement(tagName, null);
/*  346 */       endNamespaceDecls(null);
/*  347 */       endAttributes();
/*  348 */       this.out.text(data, false);
/*  349 */       endElement();
/*      */     }
/*      */   }
/*      */ 
/*      */   public void leafElement(Name tagName, int data, String fieldName) throws SAXException, IOException, XMLStreamException {
/*  354 */     this.intData.reset(data);
/*  355 */     leafElement(tagName, this.intData, fieldName);
/*      */   }
/*      */ 
/*      */   public void text(String text, String fieldName)
/*      */     throws SAXException, IOException, XMLStreamException
/*      */   {
/*  395 */     if (text == null) {
/*  396 */       reportMissingObjectError(fieldName);
/*  397 */       return;
/*      */     }
/*      */ 
/*  400 */     this.out.text(text, this.textHasAlreadyPrinted);
/*  401 */     this.textHasAlreadyPrinted = true;
/*      */   }
/*      */ 
/*      */   public void text(Pcdata text, String fieldName)
/*      */     throws SAXException, IOException, XMLStreamException
/*      */   {
/*  410 */     if (text == null) {
/*  411 */       reportMissingObjectError(fieldName);
/*  412 */       return;
/*      */     }
/*      */ 
/*  415 */     this.out.text(text, this.textHasAlreadyPrinted);
/*  416 */     this.textHasAlreadyPrinted = true;
/*      */   }
/*      */ 
/*      */   public void attribute(String uri, String local, String value)
/*      */     throws SAXException
/*      */   {
/*      */     int prefix;
/*      */     int prefix;
/*  421 */     if (uri.length() == 0)
/*      */     {
/*  423 */       prefix = -1;
/*      */     }
/*  425 */     else prefix = this.nsContext.getPrefixIndex(uri);
/*      */ 
/*      */     try
/*      */     {
/*  429 */       this.out.attribute(prefix, local, value);
/*      */     } catch (IOException e) {
/*  431 */       throw new SAXException2(e);
/*      */     } catch (XMLStreamException e) {
/*  433 */       throw new SAXException2(e);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void attribute(Name name, CharSequence value)
/*      */     throws IOException, XMLStreamException
/*      */   {
/*  440 */     this.out.attribute(name, value.toString());
/*      */   }
/*      */ 
/*      */   public NamespaceContext2 getNamespaceContext() {
/*  444 */     return this.nsContext;
/*      */   }
/*      */ 
/*      */   public String onID(Object owner, String value)
/*      */   {
/*  449 */     this.objectsWithId.add(owner);
/*  450 */     return value;
/*      */   }
/*      */   public String onIDREF(Object obj) throws SAXException {
/*      */     String id;
/*      */     try {
/*  456 */       id = getIdFromObject(obj);
/*      */     } catch (JAXBException e) {
/*  458 */       reportError(null, e);
/*  459 */       return null;
/*      */     }
/*  461 */     this.idReferencedObjects.add(obj);
/*  462 */     if (id == null) {
/*  463 */       reportError(new NotIdentifiableEventImpl(1, Messages.NOT_IDENTIFIABLE.format(new Object[0]), new ValidationEventLocatorImpl(obj)));
/*      */     }
/*      */ 
/*  468 */     return id;
/*      */   }
/*      */ 
/*      */   public void childAsRoot(Object obj)
/*      */     throws JAXBException, IOException, SAXException, XMLStreamException
/*      */   {
/*  476 */     JaxBeanInfo beanInfo = this.grammar.getBeanInfo(obj, true);
/*      */ 
/*  481 */     this.cycleDetectionStack.pushNocheck(obj);
/*      */ 
/*  483 */     boolean lookForLifecycleMethods = beanInfo.lookForLifecycleMethods();
/*  484 */     if (lookForLifecycleMethods) {
/*  485 */       fireBeforeMarshalEvents(beanInfo, obj);
/*      */     }
/*      */ 
/*  488 */     beanInfo.serializeRoot(obj, this);
/*      */ 
/*  490 */     if (lookForLifecycleMethods) {
/*  491 */       fireAfterMarshalEvents(beanInfo, obj);
/*      */     }
/*      */ 
/*  494 */     this.cycleDetectionStack.pop();
/*      */   }
/*      */ 
/*      */   private Object pushObject(Object obj, String fieldName)
/*      */     throws SAXException
/*      */   {
/*  510 */     if (!this.cycleDetectionStack.push(obj)) {
/*  511 */       return obj;
/*      */     }
/*      */ 
/*  514 */     if ((obj instanceof CycleRecoverable)) {
/*  515 */       obj = ((CycleRecoverable)obj).onCycleDetected(new CycleRecoverable.Context() {
/*      */         public Marshaller getMarshaller() {
/*  517 */           return XMLSerializer.this.marshaller;
/*      */         }
/*      */       });
/*  520 */       if (obj != null)
/*      */       {
/*  524 */         this.cycleDetectionStack.pop();
/*  525 */         return pushObject(obj, fieldName);
/*      */       }
/*  527 */       return null;
/*      */     }
/*      */ 
/*  531 */     reportError(new ValidationEventImpl(1, Messages.CYCLE_IN_MARSHALLER.format(new Object[] { this.cycleDetectionStack.getCycleString() }), getCurrentLocation(fieldName), null));
/*      */ 
/*  536 */     return null;
/*      */   }
/*      */ 
/*      */   public final void childAsSoleContent(Object child, String fieldName)
/*      */     throws SAXException, IOException, XMLStreamException
/*      */   {
/*  555 */     if (child == null) {
/*  556 */       handleMissingObjectError(fieldName);
/*      */     } else {
/*  558 */       child = pushObject(child, fieldName);
/*  559 */       if (child == null)
/*      */       {
/*  561 */         endNamespaceDecls(null);
/*  562 */         endAttributes();
/*  563 */         this.cycleDetectionStack.pop();
/*      */       }
/*      */       JaxBeanInfo beanInfo;
/*      */       try {
/*  568 */         beanInfo = this.grammar.getBeanInfo(child, true);
/*      */       } catch (JAXBException e) {
/*  570 */         reportError(fieldName, e);
/*      */ 
/*  572 */         endNamespaceDecls(null);
/*  573 */         endAttributes();
/*  574 */         this.cycleDetectionStack.pop();
/*  575 */         return;
/*      */       }
/*      */ 
/*  578 */       boolean lookForLifecycleMethods = beanInfo.lookForLifecycleMethods();
/*  579 */       if (lookForLifecycleMethods) {
/*  580 */         fireBeforeMarshalEvents(beanInfo, child);
/*      */       }
/*      */ 
/*  583 */       beanInfo.serializeURIs(child, this);
/*  584 */       endNamespaceDecls(child);
/*  585 */       beanInfo.serializeAttributes(child, this);
/*  586 */       endAttributes();
/*  587 */       beanInfo.serializeBody(child, this);
/*      */ 
/*  589 */       if (lookForLifecycleMethods) {
/*  590 */         fireAfterMarshalEvents(beanInfo, child);
/*      */       }
/*      */ 
/*  593 */       this.cycleDetectionStack.pop();
/*      */     }
/*      */   }
/*      */ 
/*      */   public final void childAsXsiType(Object child, String fieldName, JaxBeanInfo expected)
/*      */     throws SAXException, IOException, XMLStreamException
/*      */   {
/*  622 */     if (child == null) {
/*  623 */       handleMissingObjectError(fieldName);
/*      */     } else {
/*  625 */       child = pushObject(child, fieldName);
/*  626 */       if (child == null) {
/*  627 */         endNamespaceDecls(null);
/*  628 */         endAttributes();
/*  629 */         return;
/*      */       }
/*      */ 
/*  632 */       boolean asExpected = child.getClass() == expected.jaxbType;
/*  633 */       JaxBeanInfo actual = expected;
/*  634 */       QName actualTypeName = null;
/*      */ 
/*  636 */       if ((asExpected) && (actual.lookForLifecycleMethods())) {
/*  637 */         fireBeforeMarshalEvents(actual, child);
/*      */       }
/*      */ 
/*  640 */       if (!asExpected) {
/*      */         try {
/*  642 */           actual = this.grammar.getBeanInfo(child, true);
/*  643 */           if (actual.lookForLifecycleMethods())
/*  644 */             fireBeforeMarshalEvents(actual, child);
/*      */         }
/*      */         catch (JAXBException e) {
/*  647 */           reportError(fieldName, e);
/*  648 */           endNamespaceDecls(null);
/*  649 */           endAttributes();
/*  650 */           return;
/*      */         }
/*  652 */         if (actual == expected) {
/*  653 */           asExpected = true;
/*      */         } else {
/*  655 */           actualTypeName = actual.getTypeName(child);
/*  656 */           if (actualTypeName == null) {
/*  657 */             reportError(new ValidationEventImpl(1, Messages.SUBSTITUTED_BY_ANONYMOUS_TYPE.format(new Object[] { expected.jaxbType.getName(), child.getClass().getName(), actual.jaxbType.getName() }), getCurrentLocation(fieldName)));
/*      */           }
/*      */           else
/*      */           {
/*  666 */             getNamespaceContext().declareNamespace("http://www.w3.org/2001/XMLSchema-instance", "xsi", true);
/*  667 */             getNamespaceContext().declareNamespace(actualTypeName.getNamespaceURI(), null, false);
/*      */           }
/*      */         }
/*      */       }
/*  671 */       actual.serializeURIs(child, this);
/*  672 */       endNamespaceDecls(child);
/*  673 */       if (!asExpected) {
/*  674 */         attribute("http://www.w3.org/2001/XMLSchema-instance", "type", DatatypeConverter.printQName(actualTypeName, getNamespaceContext()));
/*      */       }
/*      */ 
/*  677 */       actual.serializeAttributes(child, this);
/*  678 */       endAttributes();
/*  679 */       actual.serializeBody(child, this);
/*      */ 
/*  681 */       if (actual.lookForLifecycleMethods()) {
/*  682 */         fireAfterMarshalEvents(actual, child);
/*      */       }
/*      */ 
/*  685 */       this.cycleDetectionStack.pop();
/*      */     }
/*      */   }
/*      */ 
/*      */   private void fireAfterMarshalEvents(JaxBeanInfo beanInfo, Object currentTarget)
/*      */   {
/*  700 */     if (beanInfo.hasAfterMarshalMethod()) {
/*  701 */       Method m = beanInfo.getLifecycleMethods().afterMarshal;
/*  702 */       fireMarshalEvent(currentTarget, m);
/*      */     }
/*      */ 
/*  706 */     Marshaller.Listener externalListener = this.marshaller.getListener();
/*  707 */     if (externalListener != null)
/*  708 */       externalListener.afterMarshal(currentTarget);
/*      */   }
/*      */ 
/*      */   private void fireBeforeMarshalEvents(JaxBeanInfo beanInfo, Object currentTarget)
/*      */   {
/*  724 */     if (beanInfo.hasBeforeMarshalMethod()) {
/*  725 */       Method m = beanInfo.getLifecycleMethods().beforeMarshal;
/*  726 */       fireMarshalEvent(currentTarget, m);
/*      */     }
/*      */ 
/*  730 */     Marshaller.Listener externalListener = this.marshaller.getListener();
/*  731 */     if (externalListener != null)
/*  732 */       externalListener.beforeMarshal(currentTarget);
/*      */   }
/*      */ 
/*      */   private void fireMarshalEvent(Object target, Method m)
/*      */   {
/*      */     try {
/*  738 */       m.invoke(target, new Object[] { this.marshaller });
/*      */     }
/*      */     catch (Exception e) {
/*  741 */       throw new IllegalStateException(e);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void attWildcardAsURIs(Map<QName, String> attributes, String fieldName) {
/*  746 */     if (attributes == null) return;
/*  747 */     for (Map.Entry e : attributes.entrySet()) {
/*  748 */       QName n = (QName)e.getKey();
/*  749 */       String nsUri = n.getNamespaceURI();
/*  750 */       if (nsUri.length() > 0) {
/*  751 */         String p = n.getPrefix();
/*  752 */         if (p.length() == 0) p = null;
/*  753 */         this.nsContext.declareNsUri(nsUri, p, true);
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   public void attWildcardAsAttributes(Map<QName, String> attributes, String fieldName) throws SAXException {
/*  759 */     if (attributes == null) return;
/*  760 */     for (Map.Entry e : attributes.entrySet()) {
/*  761 */       QName n = (QName)e.getKey();
/*  762 */       attribute(n.getNamespaceURI(), n.getLocalPart(), (String)e.getValue());
/*      */     }
/*      */   }
/*      */ 
/*      */   public final void writeXsiNilTrue()
/*      */     throws SAXException, IOException, XMLStreamException
/*      */   {
/*  777 */     getNamespaceContext().declareNamespace("http://www.w3.org/2001/XMLSchema-instance", "xsi", true);
/*  778 */     endNamespaceDecls(null);
/*  779 */     attribute("http://www.w3.org/2001/XMLSchema-instance", "nil", "true");
/*  780 */     endAttributes();
/*      */   }
/*      */ 
/*      */   public <E> void writeDom(E element, DomHandler<E, ?> domHandler, Object parentBean, String fieldName) throws SAXException {
/*  784 */     Source source = domHandler.marshal(element, this);
/*  785 */     if (this.contentHandlerAdapter == null)
/*  786 */       this.contentHandlerAdapter = new ContentHandlerAdaptor(this);
/*      */     try {
/*  788 */       getIdentityTransformer().transform(source, new SAXResult(this.contentHandlerAdapter));
/*      */     } catch (TransformerException e) {
/*  790 */       reportError(fieldName, e);
/*      */     }
/*      */   }
/*      */ 
/*      */   public Transformer getIdentityTransformer() {
/*  795 */     if (this.identityTransformer == null)
/*  796 */       this.identityTransformer = JAXBContextImpl.createTransformer();
/*  797 */     return this.identityTransformer;
/*      */   }
/*      */ 
/*      */   public void setPrefixMapper(NamespacePrefixMapper prefixMapper) {
/*  801 */     this.nsContext.setPrefixMapper(prefixMapper);
/*      */   }
/*      */ 
/*      */   public void startDocument(XmlOutput out, boolean fragment, String schemaLocation, String noNsSchemaLocation)
/*      */     throws IOException, SAXException, XMLStreamException
/*      */   {
/*  813 */     setThreadAffinity();
/*  814 */     pushCoordinator();
/*  815 */     this.nsContext.reset();
/*  816 */     this.nse = this.nsContext.getCurrent();
/*  817 */     if ((this.attachmentMarshaller != null) && (this.attachmentMarshaller.isXOPPackage()))
/*  818 */       out = new MTOMXmlOutput(out);
/*  819 */     this.out = out;
/*  820 */     this.objectsWithId.clear();
/*  821 */     this.idReferencedObjects.clear();
/*  822 */     this.textHasAlreadyPrinted = false;
/*  823 */     this.seenRoot = false;
/*  824 */     this.schemaLocation = schemaLocation;
/*  825 */     this.noNsSchemaLocation = noNsSchemaLocation;
/*  826 */     this.fragment = fragment;
/*  827 */     this.inlineBinaryFlag = false;
/*  828 */     this.expectedMimeType = null;
/*  829 */     this.cycleDetectionStack.reset();
/*      */ 
/*  831 */     out.startDocument(this, fragment, this.knownUri2prefixIndexMap, this.nsContext);
/*      */   }
/*      */ 
/*      */   public void endDocument() throws IOException, SAXException, XMLStreamException {
/*  835 */     this.out.endDocument(this.fragment);
/*      */   }
/*      */ 
/*      */   public void close() {
/*  839 */     popCoordinator();
/*  840 */     resetThreadAffinity();
/*      */   }
/*      */ 
/*      */   public void addInscopeBinding(String nsUri, String prefix)
/*      */   {
/*  853 */     this.nsContext.put(nsUri, prefix);
/*      */   }
/*      */ 
/*      */   public String getXMIMEContentType()
/*      */   {
/*  867 */     String v = this.grammar.getXMIMEContentType(this.cycleDetectionStack.peek());
/*  868 */     if (v != null) return v;
/*      */ 
/*  871 */     if (this.expectedMimeType != null) {
/*  872 */       return this.expectedMimeType.toString();
/*      */     }
/*  874 */     return null;
/*      */   }
/*      */ 
/*      */   private void startElement() {
/*  878 */     this.nse = this.nse.push();
/*      */ 
/*  880 */     if (!this.seenRoot)
/*      */     {
/*  883 */       String[] knownUris = this.nameList.namespaceURIs;
/*  884 */       for (int i = 0; i < knownUris.length; i++) {
/*  885 */         this.knownUri2prefixIndexMap[i] = this.nsContext.declareNsUri(knownUris[i], null, this.nameList.nsUriCannotBeDefaulted[i]);
/*      */       }
/*      */ 
/*  889 */       String[] uris = this.nsContext.getPrefixMapper().getPreDeclaredNamespaceUris();
/*  890 */       if (uris != null) {
/*  891 */         for (String uri : uris) {
/*  892 */           if (uri != null)
/*  893 */             this.nsContext.declareNsUri(uri, null, false);
/*      */         }
/*      */       }
/*  896 */       String[] pairs = this.nsContext.getPrefixMapper().getPreDeclaredNamespaceUris2();
/*  897 */       if (pairs != null) {
/*  898 */         for (int i = 0; i < pairs.length; i += 2) {
/*  899 */           String prefix = pairs[i];
/*  900 */           String nsUri = pairs[(i + 1)];
/*  901 */           if ((prefix == null) || (nsUri == null))
/*      */           {
/*      */             continue;
/*      */           }
/*  905 */           this.nsContext.put(nsUri, prefix);
/*      */         }
/*      */       }
/*      */ 
/*  909 */       if ((this.schemaLocation != null) || (this.noNsSchemaLocation != null)) {
/*  910 */         this.nsContext.declareNsUri("http://www.w3.org/2001/XMLSchema-instance", "xsi", true);
/*      */       }
/*      */     }
/*      */ 
/*  914 */     this.nsContext.collectionMode = true;
/*  915 */     this.textHasAlreadyPrinted = false;
/*      */   }
/*      */ 
/*      */   public MimeType setExpectedMimeType(MimeType expectedMimeType)
/*      */   {
/*  925 */     MimeType old = this.expectedMimeType;
/*  926 */     this.expectedMimeType = expectedMimeType;
/*  927 */     return old;
/*      */   }
/*      */ 
/*      */   public boolean setInlineBinaryFlag(boolean value)
/*      */   {
/*  936 */     boolean old = this.inlineBinaryFlag;
/*  937 */     this.inlineBinaryFlag = value;
/*  938 */     return old;
/*      */   }
/*      */ 
/*      */   public boolean getInlineBinaryFlag() {
/*  942 */     return this.inlineBinaryFlag;
/*      */   }
/*      */ 
/*      */   public QName setSchemaType(QName st)
/*      */   {
/*  957 */     QName old = this.schemaType;
/*  958 */     this.schemaType = st;
/*  959 */     return old;
/*      */   }
/*      */ 
/*      */   public QName getSchemaType() {
/*  963 */     return this.schemaType;
/*      */   }
/*      */ 
/*      */   public void setObjectIdentityCycleDetection(boolean val) {
/*  967 */     this.cycleDetectionStack.setUseIdentity(val);
/*      */   }
/*      */   public boolean getObjectIdentityCycleDetection() {
/*  970 */     return this.cycleDetectionStack.getUseIdentity();
/*      */   }
/*      */ 
/*      */   void reconcileID() throws SAXException
/*      */   {
/*  975 */     this.idReferencedObjects.removeAll(this.objectsWithId);
/*      */ 
/*  977 */     for (Iterator i$ = this.idReferencedObjects.iterator(); i$.hasNext(); ) { Object idObj = i$.next();
/*      */       try {
/*  979 */         String id = getIdFromObject(idObj);
/*  980 */         reportError(new NotIdentifiableEventImpl(1, Messages.DANGLING_IDREF.format(new Object[] { id }), new ValidationEventLocatorImpl(idObj)));
/*      */       }
/*      */       catch (JAXBException e)
/*      */       {
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/*  990 */     this.idReferencedObjects.clear();
/*  991 */     this.objectsWithId.clear();
/*      */   }
/*      */ 
/*      */   public boolean handleError(Exception e) {
/*  995 */     return handleError(e, this.cycleDetectionStack.peek(), null);
/*      */   }
/*      */ 
/*      */   public boolean handleError(Exception e, Object source, String fieldName) {
/*  999 */     return handleEvent(new ValidationEventImpl(1, e.getMessage(), new ValidationEventLocatorExImpl(source, fieldName), e));
/*      */   }
/*      */ 
/*      */   public boolean handleEvent(ValidationEvent event)
/*      */   {
/*      */     try
/*      */     {
/* 1009 */       return this.marshaller.getEventHandler().handleEvent(event);
/*      */     } catch (JAXBException e) {
/*      */     }
/* 1012 */     throw new Error(e);
/*      */   }
/*      */ 
/*      */   private void reportMissingObjectError(String fieldName) throws SAXException
/*      */   {
/* 1017 */     reportError(new ValidationEventImpl(1, Messages.MISSING_OBJECT.format(new Object[] { fieldName }), getCurrentLocation(fieldName), new NullPointerException()));
/*      */   }
/*      */ 
/*      */   public void errorMissingId(Object obj)
/*      */     throws SAXException
/*      */   {
/* 1028 */     reportError(new ValidationEventImpl(1, Messages.MISSING_ID.format(new Object[] { obj }), new ValidationEventLocatorImpl(obj)));
/*      */   }
/*      */ 
/*      */   public ValidationEventLocator getCurrentLocation(String fieldName)
/*      */   {
/* 1035 */     return new ValidationEventLocatorExImpl(this.cycleDetectionStack.peek(), fieldName);
/*      */   }
/*      */ 
/*      */   protected ValidationEventLocator getLocation() {
/* 1039 */     return getCurrentLocation(null);
/*      */   }
/*      */ 
/*      */   public static XMLSerializer getInstance()
/*      */   {
/* 1047 */     return (XMLSerializer)Coordinator._getInstance();
/*      */   }
/*      */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     com.sun.xml.bind.v2.runtime.XMLSerializer
 * JD-Core Version:    0.6.0
 */