/*     */ package com.sun.xml.bind.v2.runtime;
/*     */ 
/*     */ import com.sun.xml.bind.util.ValidationEventLocatorExImpl;
/*     */ import java.util.Collections;
/*     */ import java.util.HashMap;
/*     */ import java.util.Map;
/*     */ import java.util.Map.Entry;
/*     */ import javax.xml.bind.ValidationEvent;
/*     */ import javax.xml.bind.annotation.adapters.XmlAdapter;
/*     */ import javax.xml.bind.helpers.PrintConversionEventImpl;
/*     */ import javax.xml.bind.helpers.ValidationEventImpl;
/*     */ import javax.xml.bind.helpers.ValidationEventLocatorImpl;
/*     */ import org.xml.sax.SAXException;
/*     */ 
/*     */ public class RuntimeUtil
/*     */ {
/*     */   public static final Map<Class, Class> boxToPrimitive;
/*     */   public static final Map<Class, Class> primitiveToBox;
/*     */ 
/*     */   public static void handlePrintConversionException(Object caller, Exception e, XMLSerializer serializer)
/*     */     throws SAXException
/*     */   {
/* 112 */     if ((e instanceof SAXException))
/*     */     {
/* 116 */       throw ((SAXException)e);
/*     */     }
/* 118 */     ValidationEvent ve = new PrintConversionEventImpl(1, e.getMessage(), new ValidationEventLocatorImpl(caller), e);
/*     */ 
/* 121 */     serializer.reportError(ve);
/*     */   }
/*     */ 
/*     */   public static void handleTypeMismatchError(XMLSerializer serializer, Object parentObject, String fieldName, Object childObject)
/*     */     throws SAXException
/*     */   {
/* 130 */     ValidationEvent ve = new ValidationEventImpl(1, Messages.TYPE_MISMATCH.format(new Object[] { getTypeName(parentObject), fieldName, getTypeName(childObject) }), new ValidationEventLocatorExImpl(parentObject, fieldName));
/*     */ 
/* 138 */     serializer.reportError(ve);
/*     */   }
/*     */ 
/*     */   private static String getTypeName(Object o) {
/* 142 */     return o.getClass().getName();
/*     */   }
/*     */ 
/*     */   static
/*     */   {
/*  86 */     Map b = new HashMap();
/*  87 */     b.put(Byte.TYPE, Byte.class);
/*  88 */     b.put(Short.TYPE, Short.class);
/*  89 */     b.put(Integer.TYPE, Integer.class);
/*  90 */     b.put(Long.TYPE, Long.class);
/*  91 */     b.put(Character.TYPE, Character.class);
/*  92 */     b.put(Boolean.TYPE, Boolean.class);
/*  93 */     b.put(Float.TYPE, Float.class);
/*  94 */     b.put(Double.TYPE, Double.class);
/*  95 */     b.put(Void.TYPE, Void.class);
/*     */ 
/*  97 */     primitiveToBox = Collections.unmodifiableMap(b);
/*     */ 
/*  99 */     Map p = new HashMap();
/* 100 */     for (Map.Entry e : b.entrySet()) {
/* 101 */       p.put(e.getValue(), e.getKey());
/*     */     }
/* 103 */     boxToPrimitive = Collections.unmodifiableMap(p);
/*     */   }
/*     */ 
/*     */   public static final class ToStringAdapter extends XmlAdapter<String, Object>
/*     */   {
/*     */     public Object unmarshal(String s)
/*     */     {
/*  63 */       throw new UnsupportedOperationException();
/*     */     }
/*     */ 
/*     */     public String marshal(Object o) {
/*  67 */       if (o == null) return null;
/*  68 */       return o.toString();
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     com.sun.xml.bind.v2.runtime.RuntimeUtil
 * JD-Core Version:    0.6.0
 */